/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.inputinterface.filestate;

import ciss.phase_viewer.inputinterface.filestate.FileState;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import java.io.File;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FileStateObserver {
    private Logger logger = Logger.getLogger((String)FileStateObserver.class.getName());
    private long period = 20L;
    private String dir;
    private String[] filters;
    private File[] previousFiles;
    private long[] previousLastModified;
    private static String LOCK_FILE = "__LOCK__";
    private Vector listeners = null;

    public static boolean generateLockFile(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File lock = new File(String.valueOf(dir.getAbsolutePath()) + System.getProperty("file.separator") + LOCK_FILE);
        try {
            lock.createNewFile();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean removeLockFile(File dir) {
        if (!dir.isDirectory()) {
            return false;
        }
        File lock = new File(String.valueOf(dir.getAbsolutePath()) + System.getProperty("file.separator") + LOCK_FILE);
        lock.delete();
        return true;
    }

    public FileStateObserver(String dir, String[] filters) {
        this.dir = dir;
        this.filters = filters;
        this.init();
    }

    public FileStateObserver(String dir, String[] filters, long period) {
        this(dir, filters);
        this.period = period;
    }

    private void init() {
        this.logger.debug((Object)"initializing FileStateObserver...");
        File[] list = new File(this.dir).listFiles();
        if (list == null || list.length == 0) {
            return;
        }
        Vector<File> vec = new Vector<File>();
        int i = 0;
        while (i < list.length) {
            int j = 0;
            while (j < this.filters.length) {
                if (list[i].getName().matches(this.filters[j])) {
                    vec.addElement(list[i]);
                }
                ++j;
            }
            ++i;
        }
        if (vec.size() != 0) {
            this.previousFiles = new File[vec.size()];
            vec.copyInto(this.previousFiles);
            this.updatePreviousLastModified();
        }
    }

    private void updatePreviousLastModified() {
        if (this.previousFiles == null || this.previousFiles.length == 0) {
            this.previousLastModified = null;
            return;
        }
        this.previousLastModified = new long[this.previousFiles.length];
        int i = 0;
        while (i < this.previousFiles.length) {
            this.previousLastModified[i] = this.previousFiles[i].lastModified();
            ++i;
        }
    }

    public void addFileStateListener(FileStateListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector();
            this.listeners.addElement(listener);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new FileTimerTask(), 0L, this.period);
        } else {
            this.listeners.addElement(listener);
        }
    }

    public void removeFileStateListener(FileStateListener listener) {
        if (this.listeners == null) {
            this.logger.debug((Object)"no listener to remove");
            return;
        }
        this.logger.debug((Object)("removing listener: " + listener));
        this.listeners.remove(listener);
    }

    class FileTimerTask
    extends TimerTask {
        FileTimerTask() {
        }

        @Override
        public void run() {
            if (FileStateObserver.this.listeners == null || FileStateObserver.this.listeners.size() == 0) {
                return;
            }
            File[] files = new File(FileStateObserver.this.dir).listFiles();
            if (files == null) {
                return;
            }
            Vector<File> vec = new Vector<File>();
            int j = 0;
            while (j < FileStateObserver.this.filters.length) {
                int i = 0;
                while (i < files.length) {
                    if (files[i].getName().matches(FileStateObserver.this.filters[j])) {
                        vec.addElement(files[i]);
                    }
                    ++i;
                }
                ++j;
            }
            Object[] filesNow = new File[vec.size()];
            vec.copyInto(filesNow);
            if (filesNow == null || filesNow.length == 0) {
                if (FileStateObserver.this.previousFiles == null || FileStateObserver.this.previousFiles.length == 0) {
                    return;
                }
                FileState[] state = new FileState[FileStateObserver.this.previousFiles.length];
                int i = 0;
                while (i < state.length) {
                    state[i] = new FileState(FileStateObserver.this.previousFiles[i], FileState.FILE_REMOVED);
                    ++i;
                }
                FileStateChangeEvent ev = new FileStateChangeEvent(state);
                int i2 = 0;
                while (i2 < FileStateObserver.this.listeners.size()) {
                    ((FileStateListener)FileStateObserver.this.listeners.get(i2)).fileStateChanged(ev);
                    ++i2;
                }
                FileStateObserver.this.previousFiles = null;
                FileStateObserver.this.updatePreviousLastModified();
                return;
            }
            if (FileStateObserver.this.previousFiles == null || FileStateObserver.this.previousFiles.length == 0) {
                if (filesNow == null || filesNow.length == 0) {
                    return;
                }
                FileState[] state = new FileState[filesNow.length];
                int i = 0;
                while (i < state.length) {
                    state[i] = new FileState((File)filesNow[i], FileState.FILE_CREATED);
                    ++i;
                }
                FileStateChangeEvent ev = new FileStateChangeEvent(state);
                int i3 = 0;
                while (i3 < FileStateObserver.this.listeners.size()) {
                    ((FileStateListener)FileStateObserver.this.listeners.get(i3)).fileStateChanged(ev);
                    ++i3;
                }
                FileStateObserver.this.previousFiles = (File[])filesNow;
                FileStateObserver.this.updatePreviousLastModified();
                FileStateObserver.this.logger.debug((Object)"prev null, files were created");
                return;
            }
            Vector<Object> modified = new Vector<Object>();
            Vector<Object> created = new Vector<Object>();
            int i = 0;
            while (i < filesNow.length) {
                boolean bprev = false;
                int j2 = 0;
                while (j2 < FileStateObserver.this.previousFiles.length) {
                    if (((File)filesNow[i]).equals(FileStateObserver.this.previousFiles[j2])) {
                        if (((File)filesNow[i]).lastModified() != FileStateObserver.this.previousLastModified[j2]) {
                            modified.addElement(filesNow[i]);
                        }
                        bprev = true;
                    }
                    ++j2;
                }
                if (!bprev) {
                    created.addElement(filesNow[i]);
                }
                ++i;
            }
            Vector<File> removed = new Vector<File>();
            int i4 = 0;
            while (i4 < FileStateObserver.this.previousFiles.length) {
                boolean bnow = false;
                int j3 = 0;
                while (j3 < filesNow.length) {
                    if (FileStateObserver.this.previousFiles[i4].equals(filesNow[j3])) {
                        bnow = true;
                    }
                    ++j3;
                }
                if (!bnow) {
                    removed.addElement(FileStateObserver.this.previousFiles[i4]);
                }
                ++i4;
            }
            FileStateObserver.this.previousFiles = (File[])filesNow;
            FileStateObserver.this.updatePreviousLastModified();
            if (modified.size() == 0 && created.size() == 0 && removed.size() == 0) {
                FileStateObserver.this.logger.debug((Object)"no file has changed");
                return;
            }
            File lfile = new File(String.valueOf(FileStateObserver.this.dir) + System.getProperty("file.separator") + LOCK_FILE);
            if (lfile.exists()) {
                return;
            }
            Vector<FileState> fileStates = new Vector<FileState>();
            int i5 = 0;
            while (i5 < modified.size()) {
                fileStates.addElement(new FileState((File)modified.get(i5), FileState.FILE_MODIFIED));
                ++i5;
            }
            i5 = 0;
            while (i5 < created.size()) {
                fileStates.addElement(new FileState((File)created.get(i5), FileState.FILE_CREATED));
                ++i5;
            }
            i5 = 0;
            while (i5 < removed.size()) {
                fileStates.addElement(new FileState((File)removed.get(i5), FileState.FILE_REMOVED));
                ++i5;
            }
            if (fileStates.size() == 0) {
                return;
            }
            Object[] states = new FileState[fileStates.size()];
            fileStates.copyInto(states);
            FileStateChangeEvent fe = new FileStateChangeEvent((FileState[])states);
            int i6 = 0;
            while (i6 < FileStateObserver.this.listeners.size()) {
                ((FileStateListener)FileStateObserver.this.listeners.elementAt(i6)).fileStateChanged(fe);
                ++i6;
            }
        }
    }
}

