/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph.mouse;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.graph.GraphPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;

public class MouseMotionListenerChartPanel
implements MouseMotionListener {
    private Logger logger = Logger.getLogger((String)MouseMotionListenerChartPanel.class.getName());
    private GraphPanel graphPanel;
    private JLabel labelxy;
    private Format format = ConstParameters.formater_float;
    private float[] prevPos = new float[]{0.0f, 0.0f};
    private int ignoreCount = 0;
    private ValueAxis domain;
    private ValueAxis range;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;
    private double xh;
    private double yh;

    public MouseMotionListenerChartPanel(GraphPanel panel) {
        this.graphPanel = panel;
        this.labelxy = new JLabel("x: y: ");
        if (panel.getPlotProperties().getPlotType() == 0) {
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.add((Component)this.labelxy, "West");
            this.graphPanel.getContentPane().add((Component)p, "South");
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        float[] pos = this.mousePos2GraphPos(e);
        if (pos != null) {
            this.labelxy.setText(" x:  " + this.format.format(String.valueOf(pos[0])) + "  y:  " + this.format.format(String.valueOf(pos[1])));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.ignoreCount = 0;
        if (this.prevPos == null) {
            this.prevPos = new float[2];
            this.prevPos = this.mousePos2GraphPos(e);
            return;
        }
        float[] currentPos = this.mousePos2GraphPos(e);
        if (currentPos == null) {
            return;
        }
        this.logger.debug((Object)("currentPos: x=" + currentPos[0] + ", y=" + currentPos[1]));
        this.logger.debug((Object)("previousPos: x=" + this.prevPos[0] + ", y=" + this.prevPos[1]));
        float difx = this.prevPos[0] - currentPos[0];
        float dify = this.prevPos[1] - currentPos[1];
        Plot plot = this.graphPanel.getChart().getPlot();
        if (!(plot instanceof CombinedDomainXYPlot) && !(plot instanceof CombinedRangeXYPlot)) {
            return;
        }
        PlotRenderingInfo plotinfo = this.graphPanel.getChartPanel().getChartRenderingInfo().getPlotInfo();
        XYPlot xyplot = null;
        if (plot instanceof CombinedDomainXYPlot) {
            xyplot = ((CombinedDomainXYPlot)plot).findSubplot(plotinfo, (Point2D)new Point2D.Double(e.getX(), e.getY()));
        } else if (plot instanceof CombinedRangeXYPlot) {
            xyplot = ((CombinedRangeXYPlot)plot).findSubplot(plotinfo, (Point2D)new Point2D.Double(e.getX(), e.getY()));
        }
        if (xyplot == null) {
            return;
        }
        ValueAxis domain = xyplot.getDomainAxis();
        ValueAxis range = xyplot.getRangeAxis();
        double xmin = domain.getLowerBound();
        double xmax = domain.getUpperBound();
        double ymin = range.getLowerBound();
        double ymax = range.getUpperBound();
        double newxmin = xmin + (double)difx;
        double newxmax = xmax + (double)difx;
        double newymin = ymin + (double)dify;
        double newymax = ymax + (double)dify;
        domain.setLowerBound(newxmin);
        domain.setUpperBound(newxmax);
        range.setLowerBound(newymin);
        range.setUpperBound(newymax);
        this.prevPos[0] = currentPos[0];
        this.prevPos[1] = currentPos[1];
    }

    private float[] mousePos2GraphPos(MouseEvent e) {
        Plot plot = this.graphPanel.getChart().getPlot();
        if (!(plot instanceof CombinedDomainXYPlot) && !(plot instanceof CombinedRangeXYPlot)) {
            return null;
        }
        PlotRenderingInfo plotinfo = this.graphPanel.getChartPanel().getChartRenderingInfo().getPlotInfo();
        XYPlot xyplot = null;
        if (plot instanceof CombinedDomainXYPlot) {
            xyplot = ((CombinedDomainXYPlot)plot).findSubplot(plotinfo, (Point2D)new Point2D.Double(e.getX(), e.getY()));
        } else if (plot instanceof CombinedRangeXYPlot) {
            xyplot = ((CombinedRangeXYPlot)plot).findSubplot(plotinfo, (Point2D)new Point2D.Double(e.getX(), e.getY()));
        }
        if (xyplot == null) {
            return null;
        }
        this.domain = xyplot.getDomainAxis();
        this.range = xyplot.getRangeAxis();
        this.xmin = this.domain.getLowerBound();
        this.xmax = this.domain.getUpperBound();
        this.ymin = this.range.getLowerBound();
        this.ymax = this.range.getUpperBound();
        Rectangle2D dataArea = this.graphPanel.getChartPanel().getScreenDataArea(e.getX(), e.getY());
        if (dataArea == null) {
            return null;
        }
        double x = (double)e.getX() - dataArea.getX();
        double y = dataArea.getY() + dataArea.getHeight() - (double)e.getY();
        this.xh = (this.xmax - this.xmin) / dataArea.getWidth();
        this.yh = (this.ymax - this.ymin) / dataArea.getHeight();
        float posx = (float)(this.xmin + x * this.xh);
        float posy = (float)(this.ymin + y * this.yh);
        return new float[]{posx, posy};
    }
}

