/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.graph;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.graph.DataTab;
import ciss.phase_viewer.graph.GraphPanel;
import ciss.phase_viewer.graph.dataset.DataSet;
import ciss.phase_viewer.graph.dataset.DataSetCollection;
import ciss.phase_viewer.graph.dataset.DataSetElement;
import ciss.phase_viewer.graph.dataset.DataSetManipulator;
import ciss.phase_viewer.graph.dataset.PlotProperties;
import ciss.phase_viewer.graph.dataset.SubPlotProperties;
import ciss.phase_viewer.outputinterface.OutputData;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import org.apache.log4j.Logger;

public class DataPanel
extends JPanel {
    private static Logger logger = Logger.getLogger((String)DataPanel.class.getName());
    private OutputData[] outputData;
    private JTabbedPane tabbedPane;
    private JPanel panel;
    public static final int TABBED = 0;
    public static final int SINGLE = 1;
    private int mode = 0;
    private JComboBox comboplottypes;
    private JToggleButton btntoggle;

    public DataPanel(OutputData[] outputData) {
        this.outputData = outputData;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    public DataPanel(OutputData[] outputData, int mode) {
        this.outputData = outputData;
        this.mode = mode;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    public DataPanel(OutputData outputDat) {
        this.outputData = new OutputData[1];
        this.outputData[0] = outputDat;
        this.mode = 1;
        this.setLayout(new BoxLayout(this, 1));
        this.init();
    }

    private void init() {
        if (this.outputData == null || this.outputData.length == 0) {
            return;
        }
        this.create();
        if (this.mode == 0) {
            this.add(this.tabbedPane);
        } else if (this.mode == 1) {
            this.add(this.panel);
        }
        this.add(this.createButtonPanel());
    }

    public void setOutputData(OutputData[] outputData) {
        this.outputData = outputData;
        this.create();
    }

    public void setOutputData(OutputData outData) {
        if (this.outputData == null) {
            this.outputData = new OutputData[1];
        }
        this.outputData[0] = outData;
        this.create();
    }

    private void create() {
        if (this.outputData == null || this.outputData.length == 0) {
            return;
        }
        if (this.mode == 0) {
            if (this.tabbedPane == null) {
                this.tabbedPane = new JTabbedPane();
                this.tabbedPane.setTabLayoutPolicy(1);
            }
            this.tabbedPane.removeAll();
            int i = 0;
            while (i < this.outputData.length) {
                DataTab tab = new DataTab(this.outputData[i]);
                this.tabbedPane.addTab(this.outputData[i].getName(), tab);
                this.tabbedPane.setToolTipTextAt(i, this.outputData[i].getDescription());
                ++i;
            }
        } else if (this.mode == 1) {
            if (this.panel == null) {
                this.panel = new JPanel();
                this.panel.setLayout(new GridLayout());
            }
            this.panel.removeAll();
            DataTab tab = new DataTab(this.outputData[0]);
            this.panel.add(tab);
            this.panel.revalidate();
        }
    }

    private JPanel createButtonPanel() {
        String[] plottypes = new String[]{"xy", "pie"};
        JPanel p = new JPanel();
        JButton btnquickplot = new JButton("quick plot");
        JButton btnplot = new JButton("plot");
        this.comboplottypes = new JComboBox<String>(plottypes);
        JButton btnload = new JButton("load data");
        JButton btntoclip = new JButton("to clipboard");
        JButton btnexport = new JButton("export");
        this.btntoggle = new JToggleButton("toggle selection mode");
        JButton btndel = new JButton("delete data");
        JButton btnsavedata = new JButton("save data");
        JButton btnclose = new JButton("close");
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new BoxLayout(pbtn, 1));
        JPanel pplot = new JPanel();
        pplot.setLayout(new BoxLayout(pplot, 0));
        pplot.add(btntoclip);
        pplot.add(btnexport);
        pplot.add(this.btntoggle);
        pplot.add(btnquickplot);
        pplot.add(this.comboplottypes);
        pplot.add(btnplot);
        pbtn.add(pplot);
        p.add(pbtn);
        btnquickplot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!DataPanel.this.doQuickPlot()) {
                    logger.error((Object)"plot failed.");
                }
            }
        });
        btnplot.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanel.this.bootDataSetManipulator();
            }
        });
        this.btntoggle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTab tab = DataPanel.this.getDataTab();
                if (tab == null) {
                    logger.error((Object)"invalid data tab.");
                    return;
                }
                JTable table = tab.getTable();
                if (table == null) {
                    logger.error((Object)"'null' table");
                    return;
                }
                table.setRowSelectionAllowed(DataPanel.this.btntoggle.isSelected());
            }
        });
        btnexport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanel.this.doExport();
            }
        });
        btntoclip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPanel.this.toClipboard();
            }
        });
        return p;
    }

    private void toClipboard() {
        DataTab tab = this.getDataTab();
        if (tab == null) {
            logger.error((Object)"invalid data tab.");
            return;
        }
        JTable table = tab.getTable();
        if (table == null) {
            logger.error((Object)"'null' table");
            return;
        }
        StringBuffer str = new StringBuffer();
        int numcols = table.getColumnCount();
        int numrows = table.getRowCount();
        int i = 0;
        while (i < numrows) {
            int j = 0;
            while (j < numcols) {
                if (j == 0) {
                    str.append(table.getValueAt(i, j));
                } else {
                    str.append("\t" + table.getValueAt(i, j));
                }
                ++j;
            }
            str.append("\n");
            ++i;
        }
        Utils.toClipboard(str.toString());
    }

    private void doExport() {
        DataTab tab = this.getDataTab();
        if (tab == null) {
            logger.error((Object)"invalid data tab.");
            return;
        }
        JTable table = tab.getTable();
        if (table == null) {
            logger.error((Object)"'null' table");
            return;
        }
        ChaseFileChooser chooser = new ChaseFileChooser("base", true);
        chooser.setFileSelectionMode(0);
        if (chooser.showDialog(this, "do export") != 0) {
            logger.info((Object)"canceled");
            return;
        }
        File exportTo = chooser.getSelectedFile();
        int numcols = table.getColumnCount();
        int numrows = table.getRowCount();
        logger.info((Object)"writing identifiers...");
        String idents = "#  ";
        int i = 0;
        while (i < numcols) {
            idents = String.valueOf(idents) + table.getColumnName(i) + "  ";
            ++i;
        }
        PrintWriter writer = null;
        try {
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(exportTo)));
                writer.println(idents);
                logger.info((Object)"writing data...");
                int i2 = 0;
                while (i2 < numrows) {
                    String rowdata = "";
                    int j = 0;
                    while (j < numcols) {
                        rowdata = String.valueOf(rowdata) + table.getModel().getValueAt(i2, j) + "  ";
                        ++j;
                    }
                    writer.println(rowdata);
                    ++i2;
                }
                logger.info((Object)("... export to " + exportTo.getAbsolutePath() + " finished."));
            }
            catch (Exception exc) {
                logger.error((Object)"failed export.");
                exc.printStackTrace();
                try {
                    writer.close();
                }
                catch (Exception exc2) {
                    exc2.printStackTrace();
                }
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
        }
    }

    private void bootDataSetManipulator() {
        DataSet[] dsets = this.createDataSet();
        DataSetManipulator manip = new DataSetManipulator(dsets);
    }

    private DataSet[] createDataSet() {
        DataSet[] ret = null;
        ret = this.mode == 0 ? new DataSet[this.tabbedPane.getTabCount()] : new DataSet[1];
        JTable[] tables = this.getTables();
        String[] names = this.getNames();
        if (tables == null || names == null) {
            return null;
        }
        int i = 0;
        while (i < tables.length) {
            ret[i] = new DataSet(names[i]);
            ret[i].setFileName(this.outputData[i].getFileName());
            int nrow = tables[i].getRowCount();
            int ncol = tables[i].getColumnCount();
            String[] idents = new String[ncol];
            int j = 0;
            while (j < ncol) {
                idents[j] = tables[i].getColumnName(j);
                ++j;
            }
            j = 0;
            while (j < ncol) {
                String[] data = new String[nrow];
                int k = 0;
                while (k < nrow) {
                    data[k] = (String)tables[i].getValueAt(k, j);
                    ++k;
                }
                ret[i].addData(data, idents[j]);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    private JTable[] getTables() {
        if (this.mode == 0) {
            JTable[] tables = new JTable[this.tabbedPane.getTabCount()];
            int i = 0;
            while (i < this.tabbedPane.getTabCount()) {
                tables[i] = ((DataTab)this.tabbedPane.getComponentAt(i)).getTable();
                ++i;
            }
            return tables;
        }
        if (this.mode == 1) {
            JTable[] tables = new JTable[1];
            int ii = 0;
            while (ii < this.panel.getComponentCount()) {
                Component component = this.panel.getComponent(ii);
                if (component instanceof DataTab) {
                    tables[0] = ((DataTab)component).getTable();
                    return tables;
                }
                ++ii;
            }
        }
        return null;
    }

    private DataTab getDataTab() {
        DataTab ret = null;
        if (this.mode == 0) {
            ret = (DataTab)this.tabbedPane.getSelectedComponent();
        } else if (this.mode == 1) {
            int ii = 0;
            while (ii < this.panel.getComponentCount()) {
                Component component = this.panel.getComponent(ii);
                if (component instanceof DataTab) {
                    ret = (DataTab)component;
                    break;
                }
                ++ii;
            }
        }
        return ret;
    }

    private String[] getNames() {
        String[] names = null;
        if (this.mode == 0) {
            names = new String[this.tabbedPane.getTabCount()];
            int i = 0;
            while (i < this.tabbedPane.getTabCount()) {
                names[i] = ((DataTab)this.tabbedPane.getComponentAt(i)).getDataName();
                ++i;
            }
            return names;
        }
        if (this.mode == 1) {
            names = new String[1];
            int ii = 0;
            while (ii < this.panel.getComponentCount()) {
                Component component = this.panel.getComponent(ii);
                if (component instanceof DataTab) {
                    names[0] = ((DataTab)component).getDataName();
                    return names;
                }
                ++ii;
            }
        }
        return names;
    }

    private boolean doQuickPlot() {
        int numSelected_rows;
        int[] index_selected_rows;
        JTable table = null;
        int tabnum = 0;
        if (this.mode == 0) {
            tabnum = this.tabbedPane.getSelectedIndex();
            if (tabnum < 0) {
                return false;
            }
            table = ((DataTab)this.tabbedPane.getComponentAt(tabnum)).getTable();
        } else if (this.mode == 1) {
            int ii = 0;
            while (ii < this.panel.getComponentCount()) {
                Component component = this.panel.getComponent(ii);
                if (component instanceof DataTab) {
                    table = ((DataTab)component).getTable();
                    break;
                }
                ++ii;
            }
        }
        int numCols = table.getColumnCount();
        int numRows = table.getRowCount();
        int numIdent = numCols;
        int[] index_selected = table.getSelectedColumns();
        int numSelected = index_selected.length;
        if (table.getRowSelectionAllowed()) {
            index_selected_rows = table.getSelectedRows();
            numSelected_rows = index_selected_rows.length;
        } else {
            index_selected_rows = new int[numRows];
            int i = 0;
            while (i < numRows) {
                index_selected_rows[i] = i;
                ++i;
            }
            numSelected_rows = numRows;
        }
        if (numSelected <= 1) {
            logger.error((Object)"select at least two columns!");
            return false;
        }
        if (numSelected_rows <= 0) {
            logger.error((Object)"select at least one row!");
            return false;
        }
        DataSet dset = new DataSet(this.outputData[tabnum].getName());
        String[] idents = this.outputData[tabnum].getIdentifier();
        if (idents == null || idents.length != numCols) {
            logger.warn((Object)"invalid identifiers. defaults are used.");
            idents[0] = "x";
            int i = 1;
            while (i < numCols) {
                idents[i] = "y" + String.valueOf(i);
                ++i;
            }
        }
        String[] selectedIdents = new String[numSelected];
        int i = 0;
        while (i < numSelected) {
            selectedIdents[i] = idents[index_selected[i]];
            ++i;
        }
        i = 0;
        while (i < numSelected) {
            String[] data = new String[numSelected_rows];
            int j = 0;
            while (j < numSelected_rows) {
                data[j] = (String)table.getModel().getValueAt(index_selected_rows[j], index_selected[i]);
                ++j;
            }
            dset.addData(data, selectedIdents[i]);
            ++i;
        }
        DataSetElement[] dse = dset.getData();
        DataSetElement[] dsey = new DataSetElement[dse.length - 1];
        int i2 = 1;
        while (i2 < dse.length) {
            dsey[i2 - 1] = dse[i2];
            ++i2;
        }
        String axisx = selectedIdents[0];
        String axisy = selectedIdents[0];
        int i3 = 1;
        while (i3 < selectedIdents.length) {
            axisy = String.valueOf(axisy) + ", " + selectedIdents[i3];
            ++i3;
        }
        int type = this.comboplottypes.getSelectedIndex();
        PlotProperties props = new PlotProperties();
        if (type == 0) {
            props.setPlotType(0);
        } else if (type == 1) {
            props.setPlotType(1);
        }
        props.setTitle(this.outputData[tabnum].getName());
        DataSetCollection coll = new DataSetCollection(this.outputData[tabnum].getName());
        coll.initData();
        coll.setRangeAxisName(0, axisy);
        coll.setDomainAxisName(0, axisx);
        coll.setDomain(0, dse[0]);
        int i4 = 0;
        while (i4 < dsey.length) {
            coll.addRange(0, dsey[i4]);
            ++i4;
        }
        SubPlotProperties spp = new SubPlotProperties(coll);
        props.addSubPlotProperties(spp);
        String title = this.outputData[tabnum].getName().replaceAll("\\s", "_");
        String dir = new File(this.outputData[tabnum].getFileName()).getParent();
        GraphPanel gpanel = new GraphPanel(title, props, dir);
        return true;
    }
}

