/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.common;

import ciss.phase_viewer.common.ChaseFileChooser;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.text.JTextComponent;

public class ChooserButton
extends JButton {
    public static final int DIRECTORY = 0;
    public static final int FILES = 1;
    private int mode = 1;
    private String dir;
    private JTextComponent tc;

    public ChooserButton() {
        super("choose");
        this.init();
    }

    public ChooserButton(int mode, JTextComponent tc) {
        super("choose");
        this.mode = mode;
        this.tc = tc;
        this.init();
    }

    public ChooserButton(String text, int mode, JTextComponent tc) {
        super(text);
        this.mode = mode;
        this.tc = tc;
        this.init();
    }

    private void init() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChooserButton.this.bootFileChooser();
            }
        });
    }

    private void bootFileChooser() {
        ChaseFileChooser fdlg = new ChaseFileChooser();
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        fdlg.setCurrentDirectory(new File(System.getProperty("user.dir")));
        if (this.mode == 1) {
            fdlg.setFileSelectionMode(0);
        } else if (this.mode == 0) {
            fdlg.setFileSelectionMode(1);
        } else {
            System.out.println("wrong specification of mode");
            return;
        }
        if (fdlg.showDialog(this.tc, "Select") != 0) {
            return;
        }
        this.dir = fdlg.getSelectedFile().getAbsolutePath();
        this.tc.setText(this.dir);
    }
}

