/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.Cell;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.common.ElementInfo;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import org.apache.log4j.Logger;

public class Cube2AtomCoords {
    private Logger logger = Logger.getLogger((String)Cube2AtomCoords.class.getName());
    private String fileName;
    private AtomCoords coords;
    private boolean atomParseEnd = false;
    private Vector densityVector = new Vector();
    private float[][] chargeDensity;
    private String title = "";
    private String comment = "";
    private int lineCount;
    private boolean molecularOrbitalParseEnd = true;
    private Vector molinds;
    private int numdensitydata = 1;
    private VolumetricData vdata;
    private Vector vdatas = new Vector();
    private int numAt;
    private int[] nCell = new int[3];
    private float[][] deltaCell = new float[3][3];
    private float[] numValenceElectrons;
    private float[][] atomPos;
    private String[] elementName;
    private float[] origin = new float[3];
    private boolean isMolecularOrbital = false;

    public Cube2AtomCoords(String fileName) {
        this.fileName = fileName;
    }

    public AtomCoords getAtomCoords() {
        block25: {
            if (this.coords == null) {
                this.coords = new AtomCoords();
                this.coords.isCart(true);
                this.coords.setUnit(1);
            }
            FileReader freader = null;
            BufferedReader breader = null;
            try {
                String line;
                freader = new FileReader(this.fileName);
                breader = new BufferedReader(freader);
                this.title = breader.readLine();
                this.comment = breader.readLine();
                breader.close();
                breader = new BufferedReader(new FileReader(this.fileName));
                while ((line = breader.readLine()) != null) {
                    int i;
                    if (this.atomParseEnd && this.molecularOrbitalParseEnd) {
                        String[] density = line.trim().split("\\s+");
                        if (density != null) {
                            i = 0;
                            while (i < density.length) {
                                this.densityVector.addElement(density[i]);
                                ++i;
                            }
                        }
                    } else if (this.atomParseEnd && this.isMolecularOrbital) {
                        this.molecularOrbitalParseEnd = true;
                        String[] molorbs = line.split("\\s+");
                        this.molinds = new Vector();
                        if (molorbs.length >= 2) {
                            i = 1;
                            while (i < molorbs.length) {
                                this.molinds.add(molorbs[i]);
                                ++i;
                            }
                        }
                    } else {
                        this.parseLine(line.trim());
                    }
                    ++this.lineCount;
                }
            }
            catch (IOException ioe) {
                this.logger.error((Object)("error in parsing file: " + this.fileName));
                ioe.printStackTrace();
                try {
                    breader.close();
                    freader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
            catch (Exception exc) {
                try {
                    exc.printStackTrace();
                    break block25;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        breader.close();
                        freader.close();
                    }
                    catch (Exception exception) {}
                }
            }
            try {
                breader.close();
                freader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.createAtomCoords();
        return this.coords;
    }

    private void createChargeDensityArray() {
        if (this.densityVector.size() == 0) {
            this.logger.warn((Object)"no charge info found.");
        } else {
            this.logger.debug((Object)("number of 'density points': " + this.densityVector.size()));
            int nchargedata = this.densityVector.size() / this.numdensitydata;
            this.chargeDensity = new float[nchargedata][this.numdensitydata];
            try {
                int count = 0;
                int i = 0;
                while (i < nchargedata) {
                    int j = 0;
                    while (j < this.numdensitydata) {
                        this.chargeDensity[i][j] = Float.parseFloat(((String)this.densityVector.elementAt(count)).replace('D', 'E'));
                        ++count;
                        ++j;
                    }
                    ++i;
                }
            }
            catch (NumberFormatException exc) {
                this.logger.error((Object)"found non-float value for charge density.");
            }
        }
    }

    private void createAtomCoords() {
        String[][] strcell = new String[3][3];
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                strcell[i][j] = String.valueOf(this.deltaCell[i][j] * (float)this.nCell[i] / 0.52917725f);
                ++j;
            }
            ++i;
        }
        Cell cell = new Cell(strcell[0], strcell[1], strcell[2]);
        this.coords.setCell(cell);
        int i2 = 0;
        while (i2 < this.numAt) {
            double[] tmp = new double[3];
            int j = 0;
            while (j < 3) {
                tmp[j] = (double)this.atomPos[i2][j] - (double)this.origin[j];
                ++j;
            }
            Atom atom = new Atom(this.elementName[i2], tmp);
            atom.setNumValenceElectrons((int)this.numValenceElectrons[i2]);
            this.coords.getAtomList().addAtom(atom);
            ++i2;
        }
        this.coords.convert(6, 8);
        this.createChargeDensityArray();
        i2 = 0;
        while (i2 < this.chargeDensity.length) {
            this.vdata = new VolumetricData(this.chargeDensity[i2], this.nCell, this.deltaCell, this.origin);
            this.coords.setChargeDensity(this.vdata);
            if (this.isMolecularOrbital) {
                this.vdata.setMode(VolumetricData.MOLECULAR_ORBITAL);
                this.vdata.addMolecularOrbitalIndex(this.molinds.get(i2));
            }
            this.vdatas.add(this.vdata);
            ++i2;
        }
    }

    public VolumetricData getChargeDensity() {
        return this.getChargeDensities()[0];
    }

    public VolumetricData[] getChargeDensities() {
        VolumetricData[] vd = new VolumetricData[this.vdatas.size()];
        int i = 0;
        while (i < vd.length) {
            vd[i] = (VolumetricData)this.vdatas.get(i);
            ++i;
        }
        return vd;
    }

    private void allocateArrays() {
        this.numValenceElectrons = new float[this.numAt];
        this.atomPos = new float[this.numAt][3];
        this.elementName = new String[this.numAt];
    }

    private void parseLine(String line) throws IOException {
        if (this.lineCount <= 1) {
            return;
        }
        String[] arline = line.split("\\s+");
        if (arline == null || arline.length == 0) {
            throw new IOException();
        }
        if (this.lineCount == 2) {
            if (!this.parseFirstRow(arline)) {
                throw new IOException();
            }
            return;
        }
        if (this.lineCount >= 3 && this.lineCount <= 5) {
            if (!this.parseCell(arline)) {
                throw new IOException();
            }
            return;
        }
        if (this.lineCount >= 6 && this.lineCount < 6 + this.numAt) {
            if (!this.parseAtoms(arline)) {
                throw new IOException();
            }
            if (this.lineCount == this.numAt + 5) {
                this.atomParseEnd = true;
            }
            return;
        }
    }

    private boolean parseAtoms(String[] arline) {
        if (arline.length < 5) {
            return false;
        }
        int atnum = 0;
        try {
            atnum = (int)Float.parseFloat(arline[0]);
            this.numValenceElectrons[this.lineCount - 6] = Float.parseFloat(arline[1]);
            int i = 0;
            while (i < 3) {
                this.atomPos[this.lineCount - 6][i] = Float.parseFloat(arline[i + 2]);
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
            return false;
        }
        catch (ArrayIndexOutOfBoundsException aiobe) {
            aiobe.printStackTrace();
            return false;
        }
        ElementInfo ei = ElementInfo.getElementInfo();
        this.elementName[this.lineCount - 6] = ei.getSymbolFromNumber(atnum);
        return true;
    }

    private boolean parseFirstRow(String[] arline) {
        if (arline.length < 4) {
            return false;
        }
        String num = arline[0];
        try {
            this.numAt = Integer.parseInt(num);
            if (this.numAt < 0) {
                this.isMolecularOrbital = true;
                this.molecularOrbitalParseEnd = false;
                this.numAt *= -1;
            }
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)"invalid numAt.");
            return false;
        }
        this.allocateArrays();
        try {
            this.origin[0] = Float.parseFloat(arline[1]);
            this.origin[1] = Float.parseFloat(arline[2]);
            this.origin[2] = Float.parseFloat(arline[3]);
        }
        catch (NumberFormatException nfe) {
            this.logger.error((Object)"invalid origin.");
            return false;
        }
        return true;
    }

    private boolean parseCell(String[] arline) {
        if (arline.length < 4) {
            return false;
        }
        try {
            this.nCell[this.lineCount - 3] = Integer.parseInt(arline[0]);
            float factor = 0.52917725f;
            if (this.nCell[this.lineCount - 3] < 0) {
                factor = 1.0f;
                int n = this.lineCount - 3;
                this.nCell[n] = this.nCell[n] * -1;
            }
            this.numdensitydata *= this.nCell[this.lineCount - 3];
            int i = 0;
            while (i < 3) {
                this.deltaCell[this.lineCount - 3][i] = Float.parseFloat(arline[i + 1]) * factor;
                ++i;
            }
        }
        catch (NumberFormatException npe) {
            npe.printStackTrace();
            return false;
        }
        catch (ArrayIndexOutOfBoundsException aiob) {
            aiob.printStackTrace();
            return false;
        }
        return true;
    }
}

