/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.atomcoord;

import ciss.phase_viewer.atomcoord.Atom;
import ciss.phase_viewer.atomcoord.AtomEditor;
import ciss.phase_viewer.atomcoord.AtomEditorCheckBox;
import ciss.phase_viewer.atomcoord.AtomEditorComboBox;
import ciss.phase_viewer.atomcoord.AtomEditorEditors;
import ciss.phase_viewer.atomcoord.AtomEditorTextField;
import ciss.phase_viewer.common.TaggedString;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;

class AtomEditors {
    AtomEditors() {
    }

    static AtomEditorEditors getInstance(InputInterfaceTableColumns column, Atom atom, AtomEditor parent) {
        String editor = column.getCellEditor();
        String ini = "";
        ini = AtomEditors.initValue(column, atom);
        boolean bini = Utils.getBool(ini);
        if (editor.equals(InputInterfaceTableColumns.CHECK_BOX)) {
            return new AtomEditorCheckBox(column.getName(), bini, parent);
        }
        if (editor.equals(InputInterfaceTableColumns.COMBO_BOX)) {
            return new AtomEditorComboBox(column.getName(), ini, column.getChoices(), parent);
        }
        if (editor.equals(InputInterfaceTableColumns.TEXT_FIELD)) {
            return new AtomEditorTextField(column.getName(), ini, parent, column.getFormatter());
        }
        return null;
    }

    static void setValue(AtomEditorEditors editor, String name, Atom atom) {
        String ini = "";
        ini = AtomEditors.getValueFrom(name, atom);
        editor.setValue(ini);
    }

    private static String initValue(InputInterfaceTableColumns column, Atom atom) {
        if (atom == null) {
            return column.getDefaultValue();
        }
        return AtomEditors.getValueFrom(column.getName(), atom);
    }

    private static String getValueFrom(String name, Atom atom) {
        String element = "element";
        String rx = "rx";
        String ry = "ry";
        String rz = "rz";
        TaggedString[] au = atom.getAuxil();
        String ret = "";
        if (name.equals(element)) {
            ret = atom.getElementName();
        } else if (name.equals(rx)) {
            ret = atom.getPos()[0];
        } else if (name.equals(ry)) {
            ret = atom.getPos()[1];
        } else if (name.equals(rz)) {
            ret = atom.getPos()[2];
        } else if (au != null) {
            int i = 0;
            while (i < au.length) {
                if (au[i].getTag() != null && au[i].getTag().equals(name)) {
                    ret = au[i].getValue();
                    break;
                }
                ++i;
            }
        }
        return ret;
    }
}

