/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.vrml;

import ciss.phase_viewer.acviewer.J3DPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import javax.media.j3d.BranchGroup;
import org.apache.log4j.Logger;
import org.cybergarage.x3d.j3d.VRML97Saver;

public class VRMLExporter {
    private Logger logger = Logger.getLogger((String)VRMLExporter.class.getName());
    private J3DPanel parent;
    private BranchGroup bg;
    private boolean gzip = false;
    private VRML97Saver saver;
    public static final int SIMPLE_ANIM = 0;

    public VRMLExporter(J3DPanel parent) {
        this.parent = parent;
        this.bg = parent.getRootBranch();
    }

    public VRMLExporter() {
    }

    public void setGzip(boolean gzip) {
        this.gzip = gzip;
    }

    public void doExport(String fileName) {
        this.doExport(new File(fileName));
    }

    public void doExport(String fileName, BranchGroup bg) {
        this.bg = bg;
        this.doExport(new File(fileName));
    }

    public void doExport(File toFile) {
        if (this.saver == null) {
            this.saver = new VRML97Saver(false);
            this.saver.setBranchGroup(this.bg);
        }
        try {
            this.logger.info((Object)("exporting to " + toFile.getAbsolutePath()));
            this.saver.setBranchGroup(this.bg);
            this.saver.save(toFile.getAbsolutePath());
            this.logger.info((Object)"... done.");
            if (this.gzip) {
                this.doGzip(toFile);
            }
            this.saver.initialize();
            this.saver.clear();
            this.saver.initializeVRML97NodeStack();
            this.saver.nullify();
            this.saver = null;
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed export...");
            exc.printStackTrace();
        }
    }

    private void doGzip(File toFile) {
        this.logger.info((Object)("compressing " + toFile.getAbsolutePath() + " in the gzip format"));
        String outFilename = String.valueOf(toFile.getAbsolutePath()) + "__";
        try {
            int len;
            GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFilename));
            String inFilename = toFile.getAbsolutePath();
            FileInputStream in = new FileInputStream(inFilename);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
            out.finish();
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        toFile.delete();
        new File(outFilename).renameTo(toFile);
        this.logger.info((Object)"...done.");
    }

    public void concatVRMLFiles(File dir, File outfile, int framerate) {
        this.concatVRMLFiles(dir, outfile, 0, framerate);
    }

    public void concatVRMLFiles(File dir, File outfile, int mode, int framerate) {
        double freq = 1.0 / (double)framerate;
        File[] files = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(".wrl");
            }
        });
        if (files == null || files.length == 0) {
            this.logger.error((Object)("vrml file not found under directory " + dir.getAbsolutePath()));
            return;
        }
        int frameCount = files.length;
        if (mode == 0) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new FileWriter(outfile));
                writer.println("#VRML V2.0 utf8");
                writer.println("DEF SW Switch{");
                writer.println("    whichChoice 0");
                writer.println("    choice[");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    writer.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            int i = 0;
            while (i < files.length) {
                this.logger.info((Object)("concatinating : " + files[i].getName()));
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(files[i]));
                    reader.readLine();
                    String line = "";
                    while ((line = reader.readLine()) != null) {
                        writer.println(line);
                    }
                    reader.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    this.logger.error((Object)"failed concat");
                }
                ++i;
            }
            String post = "    ]\n";
            post = String.valueOf(post) + "}\n";
            post = String.valueOf(post) + "DEF SENSOR TouchSensor {\n";
            post = String.valueOf(post) + "}\n";
            post = String.valueOf(post) + "DEF SC Script {\n";
            post = String.valueOf(post) + "    eventOut SFBool enabled\n";
            post = String.valueOf(post) + "    eventIn SFBool clicked\n";
            post = String.valueOf(post) + "    url \"javascript:function clicked(){\n";
            post = String.valueOf(post) + "        enabled = !enabled\n";
            post = String.valueOf(post) + "    }\"\n";
            post = String.valueOf(post) + "}\n";
            post = String.valueOf(post) + "DEF TS TimeSensor{\n";
            post = String.valueOf(post) + "   enabled FALSE\n";
            post = String.valueOf(post) + "   loop TRUE\n";
            post = String.valueOf(post) + "   cycleInterval " + String.valueOf(freq) + "\n";
            post = String.valueOf(post) + "}\n";
            post = String.valueOf(post) + "DEF SCTime Script {\n";
            post = String.valueOf(post) + "    eventOut SFInt32 choice\n";
            post = String.valueOf(post) + "    eventIn SFTime cycleTime\n";
            post = String.valueOf(post) + "    field SFInt32 current 0\n";
            post = String.valueOf(post) + "    url \"javascript:function cycleTime(){\n";
            post = String.valueOf(post) + "        current++;\n";
            post = String.valueOf(post) + "        choice = current;\n";
            post = String.valueOf(post) + "        if ( current == " + String.valueOf(frameCount - 1) + " ) current = -1;\n";
            post = String.valueOf(post) + "    }\"\n";
            post = String.valueOf(post) + "}\n";
            post = String.valueOf(post) + "ROUTE SENSOR.touchTime TO SC.clicked\n";
            post = String.valueOf(post) + "ROUTE SC.enabled TO TS.enabled\n";
            post = String.valueOf(post) + "ROUTE TS.cycleTime TO SCTime.cycleTime\n";
            post = String.valueOf(post) + "ROUTE SCTime.choice TO SW.set_whichChoice\n";
            writer.print(post);
            writer.flush();
            writer.close();
            if (this.gzip) {
                this.doGzip(outfile);
            }
        }
    }
}

