/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements.atom;

import ciss.phase_viewer.acviewer.scenegraphelements.atom.AtomObject;
import javax.media.j3d.Appearance;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import org.apache.log4j.Logger;

public class AtomFilledCircle
extends OrientedShape3D {
    private Logger logger = Logger.getLogger((String)AtomFilledCircle.class.getName());
    private Shape3D shape;
    private float radius = 0.5f;
    private int resolution;
    private int length = this.resolution = 12;
    private float resolutionh = (float)this.resolution * 0.5f;
    private AtomObject parent;
    private Color3f c;

    public AtomFilledCircle(AtomObject parent, float radius, Color3f c) {
        this.parent = parent;
        this.radius = radius * 0.9f;
        this.c = c;
        this.shape = this.createShape();
        this.setGeometry(this.shape.getGeometry());
        this.setAppearance(this.shape.getAppearance());
        this.setAlignmentMode(1);
        this.setRotationPoint(new Point3f(0.0f, 0.0f, 0.0f));
    }

    public AtomObject getAtomObject() {
        return this.parent;
    }

    private Shape3D createShape() {
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(this.c.x, this.c.y, this.c.z, 0));
        TriangleFanArray tsa = new TriangleFanArray(this.length + 2, 1, new int[]{this.length + 2});
        Point3f center = new Point3f(0.0f, 0.0f, 0.0f);
        Point3f pt0 = new Point3f(this.radius, 0.0f, 0.0f);
        Point3f p0 = center;
        Point3f p1 = new Point3f();
        Point3f p2 = new Point3f();
        boolean count = false;
        tsa.setCoordinate(0, center);
        int i22 = 0;
        while (i22 <= this.resolution) {
            p1.x = (float)((double)this.radius * Math.cos((double)i22 * Math.PI / (double)this.resolutionh));
            p1.y = (float)((double)this.radius * Math.sin((double)i22 * Math.PI / (double)this.resolutionh));
            tsa.setCoordinate(i22, p1);
            ++i22;
        }
        try {
            tsa.setCapability(18);
        }
        catch (RestrictedAccessException i22) {
            // empty catch block
        }
        Shape3D circle = new Shape3D((Geometry)tsa, appearance);
        return circle;
    }
}

