/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.scenegraphelements;

import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.apache.log4j.Logger;

public class CylinderCreatorTG
extends TransformGroup {
    private static Logger logger = Logger.getLogger((String)CylinderCreatorTG.class.getName());
    private int edges;
    private double height;
    private double radius;
    private Appearance cylApp;
    private Point3d b;
    private Point3d a;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    public static int CYLINDER = 0;
    public static int WIRE = 1;
    private int mode = CYLINDER;
    private int linePattern = 0;
    private Color3f color3f;
    private BranchGroup branchGroup;
    private BranchGroup branchBranchGroup;
    private Node cyl;
    private Color3f cylcolor = null;
    private float height_buff;

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Appearance cylApp) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = 7;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.cylApp = cylApp;
        this.create();
    }

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Appearance cylApp, int edges) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = edges;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.cylApp = cylApp;
        this.create();
    }

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Color3f color3f, int edges) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = edges;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.color3f = color3f;
        this.createCylApp();
        this.create();
    }

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Color3f color3f, int edges, int mode) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = edges;
        this.mode = mode;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.color3f = color3f;
        this.createCylApp();
        this.create();
    }

    public CylinderCreatorTG(Point3d b, Point3d a, double radius, Color3f color3f, int edges, int mode, int linePattern) {
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
        this.edges = edges;
        this.mode = mode;
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.color3f = color3f;
        this.linePattern = linePattern;
        this.createCylApp();
        this.create();
    }

    public CylinderCreatorTG(Point3d b, Point3d a) {
        this.b = b;
        this.a = a;
        this.setCapability(18);
        this.setCapability(17);
        this.setCapability(1);
        this.setCapability(14);
        this.setCapability(12);
        this.setCapability(13);
    }

    private void createCylApp() {
        this.cylApp = new Appearance();
        Material material = new Material();
        material.setDiffuseColor(new Color3f(this.color3f));
        material.setShininess(120.0f);
        this.cylApp.setMaterial(material);
    }

    public void setResolution(int e) {
        this.edges = e;
    }

    public void setColor(Color3f color3f) {
        this.color3f = color3f;
        this.createCylApp();
    }

    public void create() {
        Transform3D tgm = this.getTransMatrix();
        if (tgm == null) {
            return;
        }
        this.setTransform(tgm);
        if (this.mode == CYLINDER) {
            this.cyl = new Cylinder((float)this.radius, (float)this.height, 1, this.edges, 1, this.cylApp);
            CylinderCreatorTG.setAllowIntersect((Cylinder)this.cyl);
        } else {
            this.cyl = this.createShape3DCyl();
        }
        this.branchGroup = new BranchGroup();
        this.branchGroup.setCapability(13);
        this.branchGroup.setCapability(14);
        this.branchBranchGroup = new BranchGroup();
        this.branchBranchGroup.setCapability(17);
        this.branchBranchGroup.addChild(this.cyl);
        this.branchGroup.addChild((Node)this.branchBranchGroup);
        this.addChild((Node)this.branchGroup);
    }

    private Node createShape3DCyl() {
        Shape3D nd = new Shape3D();
        this.cylcolor = this.color3f;
        LineArray lineArray = new LineArray(2, 5);
        lineArray.setCoordinate(0, new Point3f(0.0f, -((float)(this.height * 0.5)), 0.0f));
        lineArray.setColor(0, this.cylcolor);
        lineArray.setCoordinate(1, new Point3f(0.0f, (float)(this.height * 0.5), 0.0f));
        lineArray.setColor(1, this.cylcolor);
        LineAttributes lattr = new LineAttributes();
        lattr.setLineWidth((float)this.radius * 300.0f);
        lattr.setLinePattern(this.linePattern);
        Appearance app = new Appearance();
        app.setLineAttributes(lattr);
        try {
            lineArray.setCapability(18);
        }
        catch (RestrictedAccessException restrictedAccessException) {
            // empty catch block
        }
        nd.setGeometry((Geometry)lineArray);
        nd.setAppearance(app);
        return nd;
    }

    public void recreate(Point3d b, Point3d a, double radius, Appearance cylApp) {
        this.b = b;
        this.a = a;
        this.radius = radius;
        this.cylApp = cylApp;
        Transform3D tgm = this.getTransMatrix();
        if (tgm == null) {
            return;
        }
        this.setTransform(tgm);
        this.cyl = null;
        this.branchBranchGroup.detach();
        if (this.mode == CYLINDER) {
            this.cyl = new Cylinder((float)radius, (float)this.height, 1, this.edges, 1, cylApp);
            CylinderCreatorTG.setAllowIntersect((Cylinder)this.cyl);
        } else {
            this.cyl = this.createShape3DCyl();
        }
        this.height_buff = (float)this.height;
        this.branchBranchGroup = new BranchGroup();
        this.branchBranchGroup.setCapability(17);
        this.branchBranchGroup.addChild(this.cyl);
        this.branchGroup.addChild((Node)this.branchBranchGroup);
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setLinePattern(int linePattern) {
        this.linePattern = linePattern;
    }

    public void recreate(Point3d b, Point3d a, boolean force) {
        if (this.b.epsilonEquals((Tuple3d)b, 5.0E-5) && this.a.epsilonEquals((Tuple3d)a, 5.0E-5) && !force) {
            logger.debug((Object)"no need to update this bond.");
            return;
        }
        this.b = b;
        this.a = a;
        Transform3D tgm = this.getTransMatrix();
        if (tgm == null) {
            return;
        }
        this.setTransform(tgm);
        if (Math.abs(this.height_buff - (float)this.height) > 0.005f || force) {
            this.cyl = null;
            if (this.mode == CYLINDER) {
                if (force) {
                    this.createCylApp();
                }
                this.cyl = new Cylinder((float)this.radius, (float)this.height, 1, this.edges, 1, this.cylApp);
                CylinderCreatorTG.setAllowIntersect((Cylinder)this.cyl);
            } else {
                this.cyl = this.createShape3DCyl();
            }
            this.height_buff = (float)this.height;
            this.branchBranchGroup = new BranchGroup();
            this.branchBranchGroup.setCapability(17);
            this.branchBranchGroup.addChild(this.cyl);
            this.branchGroup.setChild((Node)this.branchBranchGroup, 0);
        }
    }

    private Transform3D getTransMatrix() {
        Vector3d center = new Vector3d();
        center.x = (this.a.x - this.b.x) / 2.0 + this.b.x;
        center.y = (this.a.y - this.b.y) / 2.0 + this.b.y;
        center.z = (this.a.z - this.b.z) / 2.0 + this.b.z;
        Vector3d unit = new Vector3d();
        unit.sub((Tuple3d)this.a, (Tuple3d)this.b);
        this.height = unit.length();
        unit.normalize();
        Vector3d uX = new Vector3d();
        Vector3d uY = new Vector3d();
        Vector3d uZ = new Vector3d();
        Transform3D rotateFix = new Transform3D();
        uY = new Vector3d(unit);
        uX.cross(unit, new Vector3d(0.0, 0.0, 1.0));
        double magX = uX.length();
        if (magX != 0.0) {
            uX.z /= magX;
            uX.x /= magX;
            uX.y /= magX;
            uZ.cross(uX, uY);
        } else {
            uX = new Vector3d(unit);
            uZ.cross(unit, new Vector3d(0.0, 1.0, 0.0));
            double magZ = uZ.length();
            uZ.x /= magZ;
            uZ.y /= magZ;
            uZ.z /= magZ;
            uY.cross(uZ, uX);
            rotateFix.rotZ(1.5707963267948966);
        }
        Transform3D transMatrix = new Transform3D();
        Transform3D rotateMatrix = new Transform3D(new Matrix4d(uX.x, uX.y, uX.z, 0.0, uY.x, uY.y, uY.z, 0.0, uZ.x, uZ.y, uZ.z, 0.0, 0.0, 0.0, 0.0, 1.0));
        try {
            rotateMatrix.invert();
        }
        catch (Exception exc) {
            return null;
        }
        transMatrix.mul(rotateMatrix);
        transMatrix.mul(rotateFix);
        transMatrix.setTranslation(center);
        return transMatrix;
    }

    public String toString() {
        return "edge coordinates: " + this.b.toString() + ", " + this.a.toString() + " radius: " + this.radius;
    }

    public static void setAllowIntersect(Cylinder cyl) {
        try {
            Enumeration enumer = cyl.getShape(0).getAllGeometries();
            while (enumer.hasMoreElements()) {
                ((Geometry)enumer.nextElement()).setCapability(18);
            }
            enumer = cyl.getShape(1).getAllGeometries();
            while (enumer.hasMoreElements()) {
                ((Geometry)enumer.nextElement()).setCapability(18);
            }
            enumer = cyl.getShape(2).getAllGeometries();
            while (enumer.hasMoreElements()) {
                ((Geometry)enumer.nextElement()).setCapability(18);
            }
        }
        catch (RestrictedAccessException restrictedAccessException) {
            // empty catch block
        }
    }

    public static void setAllowIntersect(Cone cone) {
        try {
            Enumeration enumer = cone.getShape(0).getAllGeometries();
            while (enumer.hasMoreElements()) {
                ((Geometry)enumer.nextElement()).setCapability(18);
            }
            enumer = cone.getShape(1).getAllGeometries();
            while (enumer.hasMoreElements()) {
                ((Geometry)enumer.nextElement()).setCapability(18);
            }
        }
        catch (RestrictedAccessException restrictedAccessException) {
            // empty catch block
        }
    }
}

