/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer.colormap;

import ciss.phase_viewer.acviewer.J3DPanel;
import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.acviewer.colormap.ColorMap;
import ciss.phase_viewer.acviewer.scenegraphelements.CapableText2D;
import ciss.phase_viewer.atomcoord.VolumetricData;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.text.DecimalFormat;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Node;
import javax.media.j3d.QuadArray;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.apache.log4j.Logger;

public class ColorBar
extends BranchGroup {
    private Logger logger = Logger.getLogger((String)ColorBar.class.getName());
    private ColorMap map;
    private boolean invert = false;
    private float width = 0.1f;
    private float widthh = this.width * 0.5f;
    private float height = 0.6f;
    private Point3f center = new Point3f(-0.85f, -0.8f, 0.0f);
    private int fontSize = 12;
    private Color3f fontColor = new Color3f(0.0f, 0.0f, 0.6f);
    private Float minval;
    private Float maxval;
    private int division = 5;
    private DecimalFormat format = new DecimalFormat("0.00E0");
    private static int LOG_SCALE = VolumetricData.LOG;
    private static int LINEAR_SCALE = VolumetricData.LINEAR;
    private int mode = LOG_SCALE;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private J3DPanel parent;
    private String title = "";
    private Shape3D shape3D;

    public ColorBar(ColorMap map, boolean invert, J3DPanel parent) {
        this.map = map;
        this.invert = invert;
        this.parent = parent;
        this.init();
    }

    public ColorBar(ColorMap map, boolean invert, Float minval, Float maxval, J3DPanel parent) {
        this.map = map;
        this.invert = invert;
        this.minval = minval;
        this.maxval = maxval;
        this.parent = parent;
        this.init();
    }

    public ColorBar(ColorMap map, boolean invert, Float minval, Float maxval, J3DPanel parent, String title) {
        this.map = map;
        this.invert = invert;
        this.minval = minval;
        this.maxval = maxval;
        this.parent = parent;
        this.title = title;
        this.init();
    }

    public ColorBar(ColorMap map, boolean invert, Float minval, Float maxval, int division, J3DPanel parent) {
        this.map = map;
        this.invert = invert;
        this.minval = minval;
        this.maxval = maxval;
        this.division = division;
        this.parent = parent;
        this.init();
    }

    public ColorBar(ColorMap map, boolean invert, Float minval, Float maxval, int division, int mode, J3DPanel parent) {
        this.map = map;
        this.invert = invert;
        this.minval = minval;
        this.maxval = maxval;
        this.division = division;
        this.parent = parent;
        this.init();
    }

    private void init() {
        this.setAttributes();
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(13);
        this.setCapability(14);
        this.shape3D = new Shape3D();
        this.shape3D.setCapability(13);
        this.addChild((Node)this.shape3D);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setPos(Point3f center) {
        this.center = center;
    }

    public Point3f getPos() {
        return this.center;
    }

    public String getTitle() {
        return this.title;
    }

    public void setInterpolationMode(int mode) {
        this.mode = mode;
    }

    public void create() {
        this.doRecreate();
    }

    public void recreate() {
        this.setAttributes();
        this.doRecreate();
    }

    private void setAttributes() {
        try {
            String[] pos = this.gp.getProperty("colorbar_position").split(",");
            this.center = new Point3f(Float.parseFloat(pos[0]), Float.parseFloat(pos[1]), Float.parseFloat(pos[2]));
            this.height = Float.parseFloat(this.gp.getProperty("colorbar_height"));
            this.width = Float.parseFloat(this.gp.getProperty("colorbar_width"));
            this.widthh = this.width * 0.5f;
            this.fontSize = Integer.parseInt(this.gp.getProperty("colorbar_scale_fontsize"));
            String[] color = this.gp.getProperty("colorbar_scale_fontcolor").split(",");
            this.fontColor = new Color3f(Float.parseFloat(color[0]), Float.parseFloat(color[1]), Float.parseFloat(color[2]));
            this.division = Integer.parseInt(this.gp.getProperty("colorbar_scale_division"));
            String formatString = this.gp.getProperty("colorbar_scale_format");
            this.format = new DecimalFormat(formatString);
        }
        catch (Exception exc) {
            this.logger.error((Object)"failed to set colorbar attributes.");
            exc.printStackTrace();
        }
    }

    public void recreate(ColorMap map, boolean invert, Float minval, Float maxval) {
        this.map = map;
        this.invert = invert;
        this.minval = minval;
        this.maxval = maxval;
        this.doRecreate();
    }

    public void recreate(ColorMap map, boolean invert) {
        this.map = map;
        this.invert = invert;
        this.doRecreate();
    }

    private void doRecreate() {
        QuadArray qr = this.getQuadArray();
        try {
            qr.setCapability(18);
        }
        catch (RestrictedAccessException restrictedAccessException) {
            // empty catch block
        }
        this.shape3D.setGeometry((Geometry)qr);
        try {
            int i = 0;
            while (i < this.numChildren()) {
                if (this.getChild(i) instanceof ScaleBG) {
                    ((ScaleBG)this.getChild(i)).detach();
                }
                ++i;
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        if (this.minval != null && this.maxval != null) {
            this.createScale();
        }
    }

    private QuadArray getQuadArray() {
        int resolution = this.map.getResolution();
        float delta = this.height / (float)resolution / 4.0f;
        Point3f[] coordinates = new Point3f[resolution * 4];
        Color3f[] color = new Color3f[resolution * 4];
        int i = 0;
        while (i < resolution * 4) {
            coordinates[i] = new Point3f(this.center.x - this.widthh, this.center.y + delta * (float)i, this.center.z);
            coordinates[i + 1] = new Point3f(this.center.x + this.widthh, this.center.y + delta * (float)i, this.center.z);
            coordinates[i + 2] = new Point3f(this.center.x + this.widthh, this.center.y + delta * (float)(i + 4), this.center.z);
            coordinates[i + 3] = new Point3f(this.center.x - this.widthh, this.center.y + delta * (float)(i + 4), this.center.z);
            float val = (float)i / ((float)resolution * 4.0f);
            Color3f color3f = this.map.getColor3f(val, this.invert);
            color[i + 3] = color3f;
            color[i + 2] = color3f;
            color[i + 1] = color3f;
            color[i] = color3f;
            i += 4;
        }
        QuadArray qarray = new QuadArray(coordinates.length, 5);
        int i2 = 0;
        while (i2 < resolution * 4) {
            Point3f[] p = new Point3f[]{coordinates[i2], coordinates[i2 + 1], coordinates[i2 + 2], coordinates[i2 + 3]};
            Color3f[] c = new Color3f[]{color[i2], color[i2 + 1], color[i2 + 2], color[i2 + 3]};
            qarray.setCoordinates(i2, p);
            qarray.setColors(i2, c);
            i2 += 4;
        }
        return qarray;
    }

    private void createScale() {
        ScaleBG bg = new ScaleBG();
        if (this.minval == null && this.maxval == null) {
            return;
        }
        float min = this.minval.floatValue();
        float max = this.maxval.floatValue();
        if (this.mode == LOG_SCALE) {
            if (min <= 0.0f) {
                min = -9.0f;
            }
            if (max <= 0.0f) {
                max = -8.0f;
            }
            if (min > max) {
                float tmp = min;
                min = max;
                max = tmp;
            }
            if (min == max) {
                max += -9.0f;
            }
        }
        CapableText2D mintext = new CapableText2D(this.format.format(min), this.fontColor, "TimesRoman", this.fontSize, 0);
        CapableText2D maxtext = new CapableText2D(this.format.format(max), this.fontColor, "TimesRoman", this.fontSize, 0);
        CapableText2D titletext = new CapableText2D(this.title, this.fontColor, "TimesRoman", this.fontSize, 0);
        Transform3D mintrans = new Transform3D();
        mintrans.setTranslation(new Vector3f(this.center.x + this.width * 0.5f, this.center.y - 0.05f, this.center.z));
        Transform3D maxtrans = new Transform3D();
        maxtrans.setTranslation(new Vector3f(this.center.x + this.width * 0.5f, this.center.y + this.height - 0.05f, this.center.z));
        Transform3D titletrans = new Transform3D();
        titletrans.setTranslation(new Vector3f(this.center.x - this.width * 0.5f, this.center.y + this.height + 0.05f, this.center.z));
        TransformGroup tgmin = new TransformGroup(mintrans);
        TransformGroup tgmax = new TransformGroup(maxtrans);
        TransformGroup tgtitle = new TransformGroup(titletrans);
        tgmin.addChild((Node)mintext);
        tgmax.addChild((Node)maxtext);
        tgtitle.addChild((Node)titletext);
        bg.addChild((Node)tgmin);
        bg.addChild((Node)tgmax);
        bg.addChild((Node)tgtitle);
        float div = this.height / (float)this.division;
        float delta = 1.0f / (float)this.division;
        int i = 1;
        while (i < this.division) {
            float yval = (float)i * div;
            float scaledVal = (float)i * delta;
            float origVal = 0.0f;
            if (this.mode == LOG_SCALE) {
                origVal = (float)BaseColorMap.getValueFromLogScaledValue(min, max, scaledVal);
            } else if (this.mode == LINEAR_SCALE) {
                origVal = (float)BaseColorMap.getValueFromLinearScaledValue(min, max, scaledVal);
            }
            this.logger.debug((Object)("origVal: " + origVal));
            CapableText2D text = new CapableText2D(this.format.format(origVal), this.fontColor, "TimesRoman", this.fontSize, 0);
            Transform3D trans = new Transform3D();
            trans.setTranslation(new Vector3f(this.center.x + this.width * 0.5f, this.center.y + yval - 0.05f, this.center.z));
            TransformGroup tg = new TransformGroup(trans);
            tg.addChild((Node)text);
            bg.addChild((Node)tg);
            ++i;
        }
        this.addChild((Node)bg);
    }

    public String toString() {
        String ret = this.title;
        ret = String.valueOf(ret) + " " + String.valueOf(this.minval) + " - " + String.valueOf(this.maxval);
        return ret;
    }

    class ScaleBG
    extends BranchGroup {
        public ScaleBG() {
            this.setCapability(17);
        }
    }
}

