/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.acviewer;

import ciss.phase_viewer.acviewer.ACVCaller;
import ciss.phase_viewer.atomcoord.AtomCoords;
import ciss.phase_viewer.atomcoord.symmetry.BravaisLattice;
import ciss.phase_viewer.common.StringConstants;
import ciss.phase_viewer.inputinterface.DataManager;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.plugins.projectmanipulator.phase.PhaseConstants;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ACVData {
    private Logger logger = Logger.getLogger((String)ACVData.class.getName());
    private ACVCaller caller;
    private Vector frames;
    private String parentDir;
    private InputInterface inputInterface;
    private String tag;
    private String fileName = "";
    private BravaisLattice bravaisLattice;

    public ACVData(ACVCaller caller, Vector frames, String parentDir, InputInterface inputInterface, String tag) {
        this.caller = caller;
        this.frames = frames;
        this.parentDir = parentDir;
        this.inputInterface = inputInterface;
        this.tag = tag;
    }

    public ACVData(ACVCaller caller, AtomCoords[] coords, String parentDir, InputInterface inputInterface, String tag) {
        this.caller = caller;
        this.frames = new Vector();
        if (coords != null && coords.length != 0) {
            int i = 0;
            while (i < coords.length) {
                this.frames.addElement(coords[i]);
                ++i;
            }
        }
        this.parentDir = parentDir;
        this.inputInterface = inputInterface;
        this.tag = tag;
    }

    public void setBravaisLattice(BravaisLattice bravaisLattice) {
        this.bravaisLattice = bravaisLattice;
    }

    public BravaisLattice getBravaisLattice() {
        return this.bravaisLattice;
    }

    public String getParentDir() {
        return this.parentDir;
    }

    public String getTag() {
        return this.tag;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public InputInterface getInputInterface() {
        if (this.inputInterface == null) {
            DataManager dm = new DataManager("foo", PhaseConstants.TABLESPEC, false);
            dm.parse();
        }
        return this.inputInterface;
    }

    public InputInterfaceTableColumns[] getTableColums() {
        if (this.tag == null) {
            this.tag = StringConstants.phase_atom_tag;
        }
        return this.inputInterface.getInputInterfaceTableSpecManager().getTableSpec(this.tag).getTableColumns();
    }

    public Vector getFrames() {
        return this.frames;
    }

    public AtomCoords getFirstFrame() {
        return (AtomCoords)this.frames.elementAt(0);
    }

    public ACVCaller getCaller() {
        return this.caller;
    }
}

