/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.cgm;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.AttributedCharacterIterator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.freehep.graphics2d.PrintColor;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.cgm.BeginMetafile;
import org.freehep.graphicsio.cgm.BeginPicture;
import org.freehep.graphicsio.cgm.BeginPictureBody;
import org.freehep.graphicsio.cgm.CGMOutputStream;
import org.freehep.graphicsio.cgm.CGMPathConstructor;
import org.freehep.graphicsio.cgm.CGMWriter;
import org.freehep.graphicsio.cgm.CellArray;
import org.freehep.graphicsio.cgm.CharacterHeight;
import org.freehep.graphicsio.cgm.CharacterOrientation;
import org.freehep.graphicsio.cgm.ClipIndicator;
import org.freehep.graphicsio.cgm.ColorSelectionMode;
import org.freehep.graphicsio.cgm.EdgeCap;
import org.freehep.graphicsio.cgm.EdgeColor;
import org.freehep.graphicsio.cgm.EdgeJoin;
import org.freehep.graphicsio.cgm.EdgeType;
import org.freehep.graphicsio.cgm.EdgeVisibility;
import org.freehep.graphicsio.cgm.EdgeWidth;
import org.freehep.graphicsio.cgm.EdgeWidthSpecificationMode;
import org.freehep.graphicsio.cgm.EndMetafile;
import org.freehep.graphicsio.cgm.EndPicture;
import org.freehep.graphicsio.cgm.FillColor;
import org.freehep.graphicsio.cgm.FontList;
import org.freehep.graphicsio.cgm.InteriorStyle;
import org.freehep.graphicsio.cgm.LineCap;
import org.freehep.graphicsio.cgm.LineColor;
import org.freehep.graphicsio.cgm.LineJoin;
import org.freehep.graphicsio.cgm.LineType;
import org.freehep.graphicsio.cgm.LineWidth;
import org.freehep.graphicsio.cgm.LineWidthSpecificationMode;
import org.freehep.graphicsio.cgm.MetafileDescription;
import org.freehep.graphicsio.cgm.MetafileElementList;
import org.freehep.graphicsio.cgm.MetafileVersion;
import org.freehep.graphicsio.cgm.MitreLimit;
import org.freehep.graphicsio.cgm.Text;
import org.freehep.graphicsio.cgm.TextColor;
import org.freehep.graphicsio.cgm.TextFontIndex;
import org.freehep.graphicsio.cgm.TransparentCellColour;
import org.freehep.graphicsio.cgm.VDCExtent;
import org.freehep.graphicsio.cgm.VDCType;
import org.freehep.util.UserProperties;
import org.freehep.util.io.Tag;
import org.freehep.util.io.TaggedOutput;

public class CGMGraphics2D
extends AbstractVectorGraphicsIO {
    private static final String rootKey = CGMGraphics2D.class.getName();
    private static final Color DEFAULT_TRANSPARENT_CELL_COLOR = new Color(1, 2, 3);
    public static final String BACKGROUND = rootKey + "." + "Background";
    public static final String BACKGROUND_COLOR = rootKey + "." + "BackgroundColor";
    public static final String BINARY = rootKey + ".Binary";
    public static final String AUTHOR = rootKey + ".Author";
    public static final String TITLE = rootKey + ".Title";
    public static final String SUBJECT = rootKey + ".Subject";
    public static final String KEYWORDS = rootKey + ".Keywords";
    private static final UserProperties defaultProperties = new UserProperties();
    public static final String version = "$Revision: 1.12 $";
    private static final int CGM_VERSION = 3;
    private static final double FONTSIZE_CORRECTION = 0.8;
    private static final String[] STANDARD_FONT;
    private OutputStream ros;
    private TaggedOutput os;
    private Color transparentCellColor = null;

    public static Properties getDefaultProperties() {
        return defaultProperties;
    }

    public static void setDefaultProperties(Properties newProperties) {
        defaultProperties.setProperties(newProperties);
    }

    public CGMGraphics2D(File file, Dimension size) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), size);
    }

    public CGMGraphics2D(File file, Component component) throws FileNotFoundException {
        this((OutputStream)new FileOutputStream(file), component);
    }

    public CGMGraphics2D(OutputStream os, Dimension size) {
        super(size, false);
        this.init(os);
    }

    public CGMGraphics2D(OutputStream os, Component component) {
        super(component, false);
        this.init(os);
    }

    private void init(OutputStream os) {
        this.ros = os;
        this.initProperties((Properties)defaultProperties);
    }

    protected CGMGraphics2D(CGMGraphics2D graphics) {
        super((AbstractVectorGraphicsIO)graphics, false);
        this.os = graphics.os;
        this.transparentCellColor = graphics.transparentCellColor;
    }

    public void writeHeader() throws IOException {
        this.os = this.isProperty(BINARY) ? new CGMOutputStream(new BufferedOutputStream(this.ros), 3) : new CGMWriter(new BufferedWriter(new OutputStreamWriter(this.ros)), 3);
        this.os.writeTag((Tag)new BeginMetafile("Generated by CGMGraphics2D, FreeHEP Graphics2D Driver"));
        this.writeMetafileDescriptor();
        this.os.writeTag((Tag)new BeginPicture("Picture"));
        this.writePictureDescriptor();
        this.writeBeginningOfPictureBody();
        if (this.getClip() != null) {
            this.setClip(this.getClip());
        }
    }

    protected void writeMetafileDescriptor() throws IOException {
        String producer = ((Object)((Object)this)).getClass().getName();
        if (!this.isDeviceIndependent()) {
            producer = producer + " " + version.substring(1, version.length() - 1);
        }
        this.os.writeTag((Tag)new MetafileVersion(3));
        this.os.writeTag((Tag)new MetafileDescription("Producer: " + producer));
        this.os.writeTag((Tag)new MetafileDescription("Creator: " + this.getCreator()));
        this.os.writeTag((Tag)new MetafileDescription("Title: " + this.getProperty(TITLE)));
        this.os.writeTag((Tag)new MetafileDescription("Author: " + this.getProperty(AUTHOR)));
        this.os.writeTag((Tag)new MetafileDescription("Subject: " + this.getProperty(SUBJECT)));
        this.os.writeTag((Tag)new MetafileDescription("Info: " + this.getProperty(KEYWORDS)));
        if (!this.isDeviceIndependent()) {
            this.os.writeTag((Tag)new MetafileDescription("CreationDate: " + new SimpleDateFormat().format(new Date())));
        }
        this.os.writeTag((Tag)new MetafileElementList(5));
        this.os.writeTag((Tag)new VDCType(1));
        this.os.writeTag((Tag)new FontList(STANDARD_FONT));
        this.os.writeTag((Tag)new ClipIndicator(true));
    }

    protected void writePictureDescriptor() throws IOException {
        this.os.writeTag((Tag)new ColorSelectionMode(1));
        this.os.writeTag((Tag)new EdgeWidthSpecificationMode(0));
        this.os.writeTag((Tag)new LineWidthSpecificationMode(0));
        Dimension size = this.getSize();
        this.os.writeTag((Tag)new VDCExtent(new Point2D.Double(0.0, size.height), new Point2D.Double(size.width, 0.0)));
    }

    protected void writeBeginningOfPictureBody() throws IOException {
        this.setTransparentCellColor(DEFAULT_TRANSPARENT_CELL_COLOR);
        this.os.writeTag((Tag)new BeginPictureBody());
        this.os.writeTag((Tag)new EdgeVisibility(false));
        this.os.writeTag((Tag)new EdgeCap(2));
        this.os.writeTag((Tag)new LineCap(2));
        this.os.writeTag((Tag)new EdgeColor(Color.black));
        this.os.writeTag((Tag)new FillColor(Color.black));
        this.os.writeTag((Tag)new LineColor(Color.black));
        this.os.writeTag((Tag)new TextColor(Color.black));
        this.os.writeTag((Tag)new EdgeJoin(2));
        this.os.writeTag((Tag)new LineJoin(2));
        this.os.writeTag((Tag)new EdgeType(1));
        this.os.writeTag((Tag)new LineType(1));
        this.os.writeTag((Tag)new EdgeWidth(1.0));
        this.os.writeTag((Tag)new LineWidth(1.0));
        this.os.writeTag((Tag)new InteriorStyle(1));
        this.os.writeTag((Tag)new CharacterHeight(this.getFont().getSize()));
        this.os.writeTag((Tag)new TextFontIndex(CGMGraphics2D.fontIndex(this.getFont())));
    }

    public void writeBackground() throws IOException {
        if (this.isProperty(BACKGROUND)) {
            this.setBackground(this.getPropertyColor(BACKGROUND_COLOR));
        } else {
            this.setBackground(this.getComponent() != null ? this.getComponent().getBackground() : Color.WHITE);
        }
        this.clearRect(0.0, 0.0, this.getSize().width, this.getSize().height);
    }

    public void writeTrailer() throws IOException {
        this.os.writeTag((Tag)new EndPicture());
        this.os.writeTag((Tag)new EndMetafile());
    }

    public void closeStream() throws IOException {
        this.os.close();
    }

    public Graphics create() {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        return new CGMGraphics2D(this);
    }

    public Graphics create(double x, double y, double width, double height) {
        try {
            this.writeGraphicsSave();
        }
        catch (IOException e) {
            this.handleException(e);
        }
        CGMGraphics2D graphics = new CGMGraphics2D(this);
        graphics.translate(x, y);
        graphics.clipRect(0.0, 0.0, width, height);
        return graphics;
    }

    protected void writeGraphicsSave() throws IOException {
    }

    protected void writeGraphicsRestore() throws IOException {
    }

    public void draw(Shape s) {
        try {
            if (this.getStroke() instanceof BasicStroke) {
                this.drawPath(s, false);
            } else {
                this.drawPath(this.getStroke().createStrokedShape(s), true);
            }
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fill(Shape s) {
        try {
            this.drawPath(s, true);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public void fillAndDraw(Shape s, Color fillColor) {
        try {
            this.setNonStrokeColor(fillColor);
            this.drawPath(s, true);
            this.setNonStrokeColor(this.getColor());
            this.drawPath(s, false);
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    private void drawPath(Shape s, boolean fill) throws IOException {
        CGMPathConstructor path = new CGMPathConstructor(this.os, fill, this.getTransform());
        boolean eo = path.addPath(s);
        path.writePolyline();
        if (!eo) {
            this.writeWarning(((Object)((Object)this)).getClass() + ": cannot fill using non-zero winding rule.");
        }
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": copyArea(int, int, int, int, int, int) not implemented.");
    }

    protected void writeImage(RenderedImage image, AffineTransform xform, Color bkg) throws IOException {
        int originX = image.getMinX();
        int originY = image.getMinY();
        int width = image.getWidth();
        int height = image.getHeight();
        Point untransformedP = new Point(originX, originY);
        Point untransformedQ = new Point(originX + width, originY + height);
        Point untransformedR = new Point(originX + width, 0);
        AffineTransform compoundTransform = this.getTransform();
        compoundTransform.concatenate(xform);
        Point2D p = compoundTransform.transform(untransformedP, null);
        Point2D q = compoundTransform.transform(untransformedQ, null);
        Point2D r = compoundTransform.transform(untransformedR, null);
        ColorModel colorModel = image.getColorModel();
        Raster raster = image.getData();
        Object currentDataElements = null;
        Color[][] colorArray = new Color[height][width];
        for (int xIndex = 0; xIndex < width; ++xIndex) {
            for (int yIndex = 0; yIndex < height; ++yIndex) {
                Color color;
                int alphaComponent = colorModel.getAlpha(currentDataElements = raster.getDataElements(xIndex, yIndex, currentDataElements));
                if (alphaComponent > 0 || this.transparentCellColor == null) {
                    int redComponent = colorModel.getRed(currentDataElements);
                    int greenComponent = colorModel.getGreen(currentDataElements);
                    int blueComponent = colorModel.getBlue(currentDataElements);
                    color = new Color(redComponent, greenComponent, blueComponent, alphaComponent);
                } else {
                    color = this.transparentCellColor;
                }
                colorArray[yIndex][xIndex] = color;
            }
        }
        CellArray cgmCellArray = new CellArray(p, q, r, colorArray);
        this.os.writeTag((Tag)cgmCellArray);
    }

    protected void writeString(String str, double x, double y) throws IOException {
        Point2D.Double point = new Point2D.Double(x, y);
        AffineTransform currentTransform = this.getTransform();
        this.os.writeTag((Tag)new CharacterOrientation(-currentTransform.getShearX(), -currentTransform.getScaleY(), currentTransform.getScaleX(), currentTransform.getShearY()));
        this.os.writeTag((Tag)new Text(currentTransform.transform(point, point), str));
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": drawString(AttributedCharacterIterator, float, float) not implemented.");
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": drawGlyphVector(GlyphVector, float, float) not implemented.");
    }

    protected void writeTransform(AffineTransform t) throws IOException {
    }

    protected void writeClip(Rectangle2D r2d) throws IOException {
        AffineTransform currentTransform = this.getTransform();
        Point2D xy = currentTransform.transform(new Point2D.Double(r2d.getX(), r2d.getY()), null);
        Point2D wh = currentTransform.deltaTransform(new Point2D.Double(r2d.getWidth(), r2d.getHeight()), null);
        r2d = new Rectangle2D.Double(xy.getX(), xy.getY(), wh.getX(), wh.getY());
    }

    protected void writeClip(Shape s) throws IOException {
        this.writeWarning(((Object)((Object)this)).getClass() + ": writeClip(Shape) not implemented.");
    }

    protected void writeWidth(float width) throws IOException {
        this.os.writeTag((Tag)new EdgeWidth(width));
        this.os.writeTag((Tag)new LineWidth(width));
    }

    protected void writeCap(int cap) throws IOException {
        switch (cap) {
            case 0: {
                this.os.writeTag((Tag)new EdgeCap(2));
                this.os.writeTag((Tag)new LineCap(2));
                break;
            }
            case 1: {
                this.os.writeTag((Tag)new EdgeCap(3));
                this.os.writeTag((Tag)new LineCap(3));
                break;
            }
            case 2: {
                this.os.writeTag((Tag)new EdgeCap(4));
                this.os.writeTag((Tag)new LineCap(4));
            }
        }
    }

    protected void writeJoin(int join) throws IOException {
        switch (join) {
            default: {
                this.os.writeTag((Tag)new EdgeJoin(2));
                this.os.writeTag((Tag)new LineJoin(2));
                break;
            }
            case 1: {
                this.os.writeTag((Tag)new EdgeJoin(3));
                this.os.writeTag((Tag)new LineJoin(3));
                break;
            }
            case 2: {
                this.os.writeTag((Tag)new EdgeJoin(4));
                this.os.writeTag((Tag)new LineJoin(4));
            }
        }
    }

    protected void writeMiterLimit(float limit) throws IOException {
        this.os.writeTag((Tag)new MitreLimit(limit));
    }

    protected void writeDash(double[] dash, double phase) throws IOException {
        switch (dash.length) {
            case 0: {
                this.os.writeTag((Tag)new EdgeType(1));
                this.os.writeTag((Tag)new LineType(1));
                break;
            }
            default: {
                this.os.writeTag((Tag)new EdgeType(2));
                this.os.writeTag((Tag)new LineType(2));
                break;
            }
            case 2: {
                this.os.writeTag((Tag)new EdgeType(3));
                this.os.writeTag((Tag)new LineType(3));
                break;
            }
            case 3: {
                this.os.writeTag((Tag)new EdgeType(4));
                this.os.writeTag((Tag)new LineType(4));
                break;
            }
            case 4: {
                this.os.writeTag((Tag)new EdgeType(5));
                this.os.writeTag((Tag)new LineType(5));
            }
        }
    }

    public void setPaintMode() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setPaintMode() not implemented.");
    }

    public void setXORMode(Color c1) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": setXORMode(Color) not implemented.");
    }

    public void setTransparentCellColor(Color color) throws IOException {
        if (color != null) {
            this.os.writeTag((Tag)new TransparentCellColour(true, color));
        } else {
            this.os.writeTag((Tag)new TransparentCellColour(false, null));
        }
        this.transparentCellColor = color;
    }

    protected void writePaint(Color c) throws IOException {
        this.os.writeTag((Tag)new LineColor(c));
        this.os.writeTag((Tag)new EdgeColor(c));
        this.os.writeTag((Tag)new FillColor(c));
        this.os.writeTag((Tag)new TextColor(c));
    }

    protected void writePaint(GradientPaint paint) throws IOException {
        this.setColor(PrintColor.mixColor((Color)paint.getColor1(), (Color)paint.getColor2()));
    }

    protected void writePaint(TexturePaint p) throws IOException {
        this.writeWarning(((Object)((Object)this)).getClass() + ": writePaint(TexturePaint) not implemented.");
    }

    protected void writePaint(Paint p) throws IOException {
        this.writeWarning(((Object)((Object)this)).getClass() + ": writePaint(Paint) not implemented for " + p.getClass());
    }

    public void setFont(Font font) {
        super.setFont(font);
        try {
            this.os.writeTag((Tag)new TextFontIndex(CGMGraphics2D.fontIndex(font)));
            this.os.writeTag((Tag)new CharacterHeight((double)font.getSize() * 0.8));
        }
        catch (IOException e) {
            this.handleException(e);
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        this.writeWarning(((Object)((Object)this)).getClass() + ": getDeviceConfiguration() not implemented.");
        return null;
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        this.writeWarning(((Object)((Object)this)).getClass() + ": hit(Rectangle, Shape, boolean) not implemented.");
        return false;
    }

    public void writeComment(String comment) throws IOException {
    }

    public String toString() {
        return "CGMGraphics2D";
    }

    private static int fontIndex(Font font) {
        StringBuffer fontName = new StringBuffer(font.getName());
        if (font.isBold() || font.isItalic()) {
            fontName.append("-");
        }
        if (font.isBold()) {
            fontName.append("Bold");
        }
        if (font.isItalic()) {
            fontName.append("Italic");
        }
        String name = fontName.toString();
        for (int i = 0; i < STANDARD_FONT.length; ++i) {
            if (!name.equals(STANDARD_FONT[i])) continue;
            return i + 1;
        }
        return 5;
    }

    private void setNonStrokeColor(Color c) throws IOException {
        this.os.writeTag((Tag)new FillColor(this.getPrintColor(c)));
    }

    protected TaggedOutput getTaggedOutput() {
        return this.os;
    }

    static {
        defaultProperties.setProperty(BACKGROUND, false);
        defaultProperties.setProperty(BACKGROUND_COLOR, Color.GRAY);
        defaultProperties.setProperty(BINARY, true);
        defaultProperties.setProperty(AUTHOR, "");
        defaultProperties.setProperty(TITLE, "");
        defaultProperties.setProperty(SUBJECT, "");
        defaultProperties.setProperty(KEYWORDS, "");
        STANDARD_FONT = new String[]{"Courier", "Courier-Bold", "Courier-Italic", "Courier-BoldItalic", "Helvetica", "Helvetica-Bold", "Helvetica-Italic", "Helvetica-BoldItalic", "TimesRoman", "TimesRoman-Bold", "TimesRoman-Italic", "TimesRoman-BoldItalic", "Symbol", "ZapfDingbats"};
    }
}

