/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.common;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import jp.advancesoft.chase.common.ExternalProgramExecuter;
import jp.advancesoft.chase.common.MyMessageBox;
import jp.advancesoft.chase.mainpanel.InternalFrameChase;
import org.apache.log4j.Logger;

public abstract class ExternalProgramPanel
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)ExternalProgramPanel.class.getName());
    private Container cont;
    private JButton btnok;
    private JButton btncancel;
    protected String exeString = new String();
    protected final String FS = System.getProperty("file.separator");
    private JPanel pbutton;
    private MyMessageBox mbox = new MyMessageBox();

    public ExternalProgramPanel(String title) {
        super(title, true, true, true, true);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createMainPanel());
        this.cont.add(this.createButtonPanel());
    }

    public ExternalProgramPanel(String title, Dimension size) {
        super(title, true, true, true, true, size);
        this.cont = this.getContentPane();
        this.cont.setLayout(new BoxLayout(this.cont, 1));
        this.cont.add(this.createMainPanel());
        this.cont.add(this.createButtonPanel());
    }

    public String getExeString() {
        return this.exeString;
    }

    public void setExeString(String exeString) {
        this.exeString = exeString;
    }

    private JPanel createButtonPanel() {
        this.pbutton = new JPanel();
        this.pbutton.setLayout(new FlowLayout());
        this.btnok = new JButton("OK");
        this.btncancel = new JButton("cancel");
        this.pbutton.add(this.btnok);
        this.pbutton.add(this.btncancel);
        this.btnok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ExternalProgramPanel.this.createExeString()) {
                    ExternalProgramPanel.this.dispose();
                    return;
                }
                if (!ExternalProgramPanel.this.bootExecuter()) {
                    ExternalProgramPanel.this.dispose();
                    return;
                }
                ExternalProgramPanel.this.bootPostProcess();
            }
        });
        this.btncancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExternalProgramPanel.this.dispose();
            }
        });
        return this.pbutton;
    }

    public boolean bootExecuter() {
        this.logger.info((Object)("executing: " + this.exeString));
        try {
            String str;
            BufferedReader[] br = ExternalProgramExecuter.executeGetBR(this.exeString);
            while ((str = br[0].readLine()) != null) {
                System.out.println(str);
            }
        }
        catch (Exception e) {
            this.mbox.setText("failed execution of " + this.exeString);
            return false;
        }
        return true;
    }

    public void bootPostProcess() {
    }

    public abstract boolean createExeString();

    public abstract JPanel createMainPanel();
}

