/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.unitcell;

import java.util.Vector;
import jp.advancesoft.chase.acviewer.MainPanel;
import jp.advancesoft.chase.atomcoord.Atom;
import jp.advancesoft.chase.atomcoord.AtomCoords;
import jp.advancesoft.chase.atomcoord.AtomList;
import jp.advancesoft.chase.atomcoord.Cell;
import jp.advancesoft.chase.common.VectorOperations;
import org.apache.log4j.Logger;

public class UnitCellOperations {
    public static Logger logger = Logger.getLogger((String)UnitCellOperations.class.getName());
    private Vector frames;
    private double eps = 1.0E-5;
    private boolean packAtoms = false;
    private boolean ab = false;
    private boolean ac = false;
    private boolean bc = false;
    private int curframe;
    private MainPanel parent;

    public UnitCellOperations(Vector frames, MainPanel parent) {
        this.frames = frames;
        this.parent = parent;
    }

    public void setEps(double eps) {
        this.eps = eps;
    }

    public void setPackAtomsIntoUnitCell(boolean packAtoms) {
        this.packAtoms = packAtoms;
    }

    public void setAddBoundaryAtoms(boolean ab, boolean ac, boolean bc) {
        this.ab = ab;
        this.ac = ac;
        this.bc = bc;
    }

    public void processFrame() {
        if (!(this.packAtoms || this.ab || this.ac || this.bc)) {
            return;
        }
        if (this.frames == null) {
            logger.error((Object)"'frames' vector is null.");
            return;
        }
        if (this.frames.size() == 0) {
            logger.error((Object)"no frames.");
            return;
        }
        for (int i = 0; i < this.frames.size(); ++i) {
            AtomCoords cds = (AtomCoords)this.frames.elementAt(i);
            if (this.frames.size() == 1) {
                cds.removeDupliCell();
            }
            if (this.packAtoms) {
                this.packAtomsIntoCell(cds);
            }
            if (!this.ab && !this.ac && !this.bc) continue;
            this.addBoundaryAtoms(cds);
        }
    }

    public void processFrame(AtomCoords cds) {
        if (!(this.packAtoms || this.ab || this.ac || this.bc)) {
            return;
        }
        if (this.packAtoms) {
            this.packAtomsIntoCell(cds);
        }
        if (this.ab || this.ac || this.bc) {
            this.addBoundaryAtoms(cds);
        }
    }

    private void packAtomsIntoCell(AtomCoords cds) {
        AtomList atomList = cds.getAtomList();
        double[][] cell = cds.getCellDouble(0);
        if (cell == null) {
            logger.error((Object)"invalid cell!");
            return;
        }
        double[][] plane01 = new double[2][3];
        double[][] plane02 = new double[2][3];
        double[][] plane12 = new double[2][3];
        plane01[0] = cell[0];
        plane01[1] = cell[1];
        plane02[0] = cell[2];
        plane02[1] = cell[0];
        plane12[0] = cell[1];
        plane12[1] = cell[2];
        int nat = atomList.size();
        double[] orig = new double[]{0.0, 0.0, 0.0};
        double[][] pospos = cds.getPosDouble();
        for (int i = 0; i < nat; ++i) {
            int j;
            double[] pos = pospos[i];
            double r01 = VectorOperations.getDistanceFromPlane(pos, plane01[0], plane01[1], orig, true);
            double r10 = VectorOperations.getDistanceFromPlane(pos, plane01[1], plane01[0], cell[2], true);
            double r02 = VectorOperations.getDistanceFromPlane(pos, plane02[0], plane02[1], orig, true);
            double r20 = VectorOperations.getDistanceFromPlane(pos, plane02[1], plane02[0], cell[1], true);
            double r12 = VectorOperations.getDistanceFromPlane(pos, plane12[0], plane12[1], orig, true);
            double r21 = VectorOperations.getDistanceFromPlane(pos, plane12[1], plane12[0], cell[0], true);
            if (r01 < 0.0) {
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] + cell[2][j];
                }
            } else if (r10 < 0.0) {
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] - cell[2][j];
                }
            }
            if (r02 < 0.0) {
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] + cell[1][j];
                }
            } else if (r20 < 0.0) {
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] - cell[1][j];
                }
            }
            if (r12 < 0.0) {
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] + cell[0][j];
                }
            } else if (r21 < 0.0) {
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    pos[n] = pos[n] - cell[0][j];
                }
            }
            pospos[i] = pos;
        }
        cds.setPosDouble(pospos, true);
    }

    private void addBoundaryAtoms(AtomCoords cds) {
        Cell cell = cds.getCell()[0];
        AtomList atomList = cds.getAtomList();
        double[][] dcell = cds.getCellDouble(0);
        double[][] plane1 = new double[2][3];
        double[][] plane2 = new double[2][3];
        logger.debug((Object)("size of atomlist: " + atomList.size()));
        int natm = atomList.size();
        double[][] plane = new double[2][3];
        if (this.ab) {
            plane[0] = dcell[0];
            plane[1] = dcell[1];
            this.addAtomToOppositePlane(plane, dcell[2], cds);
        }
        if (this.ac) {
            plane[0] = dcell[0];
            plane[1] = dcell[2];
            this.addAtomToOppositePlane(plane, dcell[1], cds);
        }
        if (this.bc) {
            plane[0] = dcell[1];
            plane[1] = dcell[2];
            this.addAtomToOppositePlane(plane, dcell[0], cds);
        }
    }

    private void addAtomToOppositePlane(double[][] plane, double[] shiftVector, AtomCoords cds) {
        double[] orig = new double[]{0.0, 0.0, 0.0};
        double[][] pospos = cds.getPosDouble();
        Vector<Double[]> newPos = new Vector<Double[]>();
        Vector<Integer> newPosIndex = new Vector<Integer>();
        for (int i = 0; i < cds.getNumAt(); ++i) {
            int j;
            Double[] npos;
            double[] pos = pospos[i];
            double r = VectorOperations.getDistanceFromPlane(pos, plane[0], plane[1], orig);
            double rop = VectorOperations.getDistanceFromPlane(pos, plane[1], plane[0], shiftVector);
            if (r < this.eps) {
                npos = new Double[3];
                for (j = 0; j < 3; ++j) {
                    npos[j] = new Double(pos[j] + shiftVector[j]);
                }
                newPos.addElement(npos);
                newPosIndex.addElement(new Integer(i));
                continue;
            }
            if (!(rop < this.eps)) continue;
            npos = new Double[3];
            for (j = 0; j < 3; ++j) {
                npos[j] = new Double(pos[j] - shiftVector[j]);
            }
            newPos.addElement(npos);
            newPosIndex.addElement(new Integer(i));
        }
        if (newPos == null || newPos.size() == 0) {
            return;
        }
        int undoCount = 0;
        for (int i = 0; i < newPos.size(); ++i) {
            Double[] npos = (Double[])newPos.elementAt(i);
            double[] tmp = new double[3];
            for (int j = 0; j < 3; ++j) {
                tmp[j] = npos[j];
            }
            int posIndex = (Integer)newPosIndex.elementAt(i);
            Atom atom = cds.getAtomList().getAtomAt(posIndex);
            Atom newAtom = new Atom(atom.getElementName(), tmp, atom.getAuxil());
            if (cds.checkDupli(newAtom)) continue;
            cds.getAtomList().addAtom(newAtom);
            ++undoCount;
        }
        cds.getAtomList().setUndoCount(undoCount);
    }
}

