/*
 * Decompiled with CFR 0.152.
 */
package jp.advancesoft.chase.acviewer.measure;

import java.util.Stack;
import jp.advancesoft.chase.acviewer.measure.Measurable;
import jp.advancesoft.chase.acviewer.scenegraphelements.AtomObject;

public abstract class Measure {
    protected Measurable measurable;
    protected int numAt;
    protected double[][] pos_moto;
    protected String[] id;
    protected double lenmax;
    protected double[] com;
    protected double[][] xyz;
    protected double result;

    public Measure(Measurable measurable) {
        this.measurable = measurable;
        this.lenmax = measurable.getLenMax();
        this.com = measurable.getCOM();
    }

    public abstract int getNumberOfNecessaryAtoms();

    public abstract void calculate();

    public abstract void draw();

    public void measure(Stack atomList) {
        int numAt = this.getNumberOfNecessaryAtoms();
        this.xyz = new double[numAt][3];
        this.id = new String[numAt];
        for (int i = 0; i < numAt; ++i) {
            AtomObject atom = (AtomObject)atomList.pop();
            this.xyz[i] = atom.getPosDouble();
            this.id[i] = atom.getID();
        }
        this.pos_moto = new double[numAt][3];
        for (int j = 0; j < numAt; ++j) {
            for (int i = 0; i < 3; ++i) {
                this.pos_moto[j][i] = this.xyz[j][i] * this.lenmax + this.com[i];
            }
        }
        this.calculate();
    }
}

