/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.x3d;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import org.cybergarage.x3d.parser.Parser;
import org.cybergarage.x3d.parser.x3d.X3DHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class X3DParser
extends Parser {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final int DEFAULT_REPETITION = 1;
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_MEMORY_USAGE = false;
    protected static final boolean DEFAULT_TAGGINESS = false;
    protected long fElements;
    protected long fAttributes;
    protected long fCharacters;
    protected long fIgnorableWhitespace;
    protected long fTagCharacters;
    protected long fOtherCharacters;

    @Override
    public boolean parse(Reader reader) {
        X3DHandler counter = new X3DHandler(this);
        PrintWriter out = new PrintWriter(System.out);
        XMLReader parser = null;
        boolean repetition = true;
        boolean namespaces = true;
        boolean namespacePrefixes = false;
        boolean validation = false;
        boolean schemaValidation = false;
        boolean schemaFullChecking = false;
        boolean dynamicValidation = false;
        boolean memoryUsage = false;
        boolean tagginess = false;
        try {
            parser = XMLReaderFactory.createXMLReader();
        }
        catch (Exception e) {
            parser = null;
        }
        if (parser == null) {
            try {
                parser = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
            }
            catch (Exception e) {
                System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
            }
        }
        try {
            parser.setFeature(NAMESPACES_FEATURE_ID, namespaces);
            parser.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, namespacePrefixes);
            parser.setFeature(VALIDATION_FEATURE_ID, validation);
            parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, schemaValidation);
            parser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
            parser.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, dynamicValidation);
        }
        catch (SAXNotSupportedException e) {
        }
        catch (SAXNotRecognizedException e) {
            // empty catch block
        }
        parser.setContentHandler(counter);
        parser.setErrorHandler(counter);
        try {
            InputSource input = new InputSource(reader);
            parser.parse(input);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    private static void printUsage() {
        System.err.println("usage: java sax.X3DHandler (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -x number   Select number of repetitions.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Requires use of -v and not supported by all parsers.");
        System.err.println("  -m  | -M    Turn on/off memory usage report");
        System.err.println("  -t  | -T    Turn on/off \"tagginess\" report.");
        System.err.println("  --rem text  Output user defined comment before next parse.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.println("  Repetition: 1");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  Memory:     ");
        System.err.println("off");
        System.err.print("  Tagginess:  ");
        System.err.println("off");
        System.err.println();
        System.err.println("notes:");
        System.err.println("  The speed and memory results from this program should NOT be used as the");
        System.err.println("  basis of parser performance comparison! Real analytical methods should be");
        System.err.println("  used. For better results, perform multiple document parses within the same");
        System.err.println("  virtual machine to remove class loading from parse time and memory usage.");
        System.err.println();
        System.err.println("  The \"tagginess\" measurement gives a rough estimate of the percentage of");
        System.err.println("  markup versus content in the XML document. The percent tagginess of a ");
        System.err.println("  document is equal to the minimum amount of tag characters required for ");
        System.err.println("  elements, attributes, and processing instructions divided by the total");
        System.err.println("  amount of characters (characters, ignorable whitespace, and tag characters)");
        System.err.println("  in the document.");
        System.err.println();
        System.err.println("  Not all features are supported by different parsers.");
    }
}

