/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.parser.vrml97;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.cybergarage.x3d.parser.vrml97.VRML97Preprocessor;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoParameter;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoParameterList;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoStream;
import org.cybergarage.x3d.parser.vrml97.VRML97ProtoTokenizer;
import org.cybergarage.x3d.util.LinkedListNode;

public class VRML97Proto
extends LinkedListNode {
    protected String mName;
    protected VRML97ProtoParameterList mParameterList = new VRML97ProtoParameterList();
    protected VRML97ProtoStream mVRML97ProtoStream = new VRML97ProtoStream();

    public VRML97Proto(String name) {
        this.setHeaderFlag(false);
        this.setName(name);
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public VRML97ProtoParameterList getParameterList() {
        return this.mParameterList;
    }

    public void addParameter(String type, String name, String defalutValue) {
        this.mParameterList.addParameter(type, name, defalutValue);
    }

    public VRML97ProtoParameter getParameters() {
        return this.mParameterList.getParameters();
    }

    public VRML97ProtoParameter getParameter(String name) {
        return this.mParameterList.getParameter(name);
    }

    public boolean hasParameter(String name) {
        return this.mParameterList.hasParameter(name);
    }

    public void addToken(String token) {
        this.mVRML97ProtoStream.addToken(token);
    }

    public void addToken(double token) {
        this.mVRML97ProtoStream.addToken(token);
    }

    public VRML97ProtoStream getTokenStream() {
        return this.mVRML97ProtoStream;
    }

    public String getParameterString(VRML97ProtoParameterList paramList, String name) {
        VRML97ProtoParameter param;
        String value = null;
        if (paramList != null && (param = paramList.getParameter(name)) != null) {
            value = param.getValue();
        }
        if (value == null && (param = this.getParameter(name)) != null) {
            value = param.getValue();
        }
        return value;
    }

    public String getString(VRML97ProtoParameterList paramList) throws IOException {
        VRML97ProtoStream protoStream = this.getTokenStream();
        protoStream.rewind();
        BufferedReader r = new BufferedReader(new InputStreamReader(protoStream));
        VRML97ProtoTokenizer stream = new VRML97ProtoTokenizer(r);
        StringBuffer protoString = new StringBuffer();
        int nToken = 0;
        while (stream.nextToken() != -1) {
            switch (stream.ttype) {
                case -2: {
                    double dvalue = stream.nval;
                    String valStr = VRML97Preprocessor.number2String(dvalue);
                    protoString.append(String.valueOf(valStr) + " ");
                    ++nToken;
                    break;
                }
                case -3: {
                    if (stream.sval.compareTo("IS") == 0) {
                        String param;
                        stream.nextToken();
                        if (stream.ttype == -3 && (param = this.getParameterString(paramList, stream.sval)) != null) {
                            protoString.append(String.valueOf(param) + " ");
                        }
                    } else {
                        protoString.append(String.valueOf(stream.sval) + " ");
                    }
                    ++nToken;
                    break;
                }
                case 10: {
                    if (nToken > 0) {
                        protoString.append("\n");
                    }
                    nToken = 0;
                }
            }
        }
        return protoString.toString();
    }

    public VRML97Proto next() {
        return (VRML97Proto)this.getNextNode();
    }

    public String toString() {
        StringBuffer protoString = new StringBuffer();
        protoString.append(String.valueOf(this.getName()) + " ");
        protoString.append("[");
        VRML97ProtoParameter param = this.getParameters();
        while (param != null) {
            protoString.append(String.valueOf(param.getType()) + " ");
            protoString.append(String.valueOf(param.getName()) + " ");
            protoString.append(String.valueOf(param.getValue()) + " ");
            param = param.next();
        }
        protoString.append("]\n");
        protoString.append("{");
        protoString.append(String.valueOf(this.getTokenStream().getTokenBuffer()) + "\n");
        protoString.append("}\n");
        return protoString.toString();
    }
}

