/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.BoundedNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;

public class ShapeNode
extends BoundedNode {
    private static final String appearanceExposedFieldName = "appearance";
    private static final String geometryExposedFieldName = "geometry";
    SFNode appField;
    SFNode geomField;

    public ShapeNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.SHAPE);
        this.appField = new SFNode();
        this.addExposedField(appearanceExposedFieldName, this.appField);
        this.geomField = new SFNode();
        this.addExposedField(geometryExposedFieldName, this.geomField);
    }

    public ShapeNode(ShapeNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFNode getAppearanceField() {
        if (!this.isInstanceNode()) {
            return this.appField;
        }
        return (SFNode)this.getExposedField(appearanceExposedFieldName);
    }

    public void updateAppearanceField() {
        this.getAppearanceField().setValue(this.getAppearanceNodes());
    }

    public SFNode getGeometryField() {
        if (!this.isInstanceNode()) {
            return this.geomField;
        }
        return (SFNode)this.getExposedField(geometryExposedFieldName);
    }

    public void updateGeometryField() {
        this.getGeometryField().setValue(this.getGeometry3DNode());
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return node.isAppearanceNode() || node.isGeometry3DNode();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateAppearanceField();
        this.updateGeometryField();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        Geometry3DNode geonode;
        AppearanceNode appearance = this.getAppearanceNodes();
        if (appearance != null) {
            if (!appearance.isInstanceNode()) {
                String nodeName = appearance.getName();
                if (nodeName != null && nodeName.length() > 0) {
                    printStream.println(String.valueOf(indentString) + "\t" + "appearance DEF " + appearance.getName() + " Appearance {");
                } else {
                    printStream.println(String.valueOf(indentString) + "\t" + "appearance Appearance {");
                }
                appearance.outputContext(printStream, String.valueOf(indentString) + "\t");
                printStream.println(String.valueOf(indentString) + "\t" + "}");
            } else {
                printStream.println(String.valueOf(indentString) + "\t" + "appearance USE " + appearance.getName());
            }
        }
        if ((geonode = this.getGeometry3DNode()) != null) {
            if (!geonode.isInstanceNode()) {
                String nodeName = geonode.getName();
                if (nodeName != null && nodeName.length() > 0) {
                    printStream.println(String.valueOf(indentString) + "\t" + "geometry DEF " + geonode.getName() + " " + geonode.getTypeString() + " {");
                } else {
                    printStream.println(String.valueOf(indentString) + "\t" + "geometry " + geonode.getTypeString() + " {");
                }
                geonode.outputContext(printStream, String.valueOf(indentString) + "\t");
                printStream.println(String.valueOf(indentString) + "\t" + "}");
            } else {
                printStream.println(String.valueOf(indentString) + "\t" + "geometry USE " + geonode.getName());
            }
        }
    }
}

