/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.BoundingBox;

public class PointSetNode
extends Geometry3DNode {
    private String colorExposedFieldName = "color";
    private String coordExposedFieldName = "coord";
    private SFNode colorField;
    private SFNode coordField;

    public PointSetNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.POINTSET);
        this.colorField = new SFNode();
        this.addExposedField(this.colorExposedFieldName, this.colorField);
        this.coordField = new SFNode();
        this.addExposedField(this.coordExposedFieldName, this.coordField);
    }

    public PointSetNode(PointSetNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFNode getColorField() {
        if (!this.isInstanceNode()) {
            return this.colorField;
        }
        return (SFNode)this.getExposedField(this.colorExposedFieldName);
    }

    public void updateColorField() {
        this.getColorField().setValue(this.getColorNodes());
    }

    public SFNode getCoordField() {
        if (!this.isInstanceNode()) {
            return this.coordField;
        }
        return (SFNode)this.getExposedField(this.coordExposedFieldName);
    }

    public void updateCoordField() {
        this.getCoordField().setValue(this.getCoordinateNodes());
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return node.isCoordinateNode() || node.isColorNode();
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.isInitialized()) {
            this.updateBoundingBox();
            this.setInitializationFlag(true);
        }
        this.updateColorField();
        this.updateCoordField();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void updateBoundingBox() {
        if (this.isInitialized()) {
            return;
        }
        CoordinateNode coordinate = this.getCoordinateNodes();
        if (coordinate == null) {
            this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
            this.setBoundingBoxSize(-1.0f, -1.0f, -1.0f);
            return;
        }
        BoundingBox bbox = new BoundingBox();
        float[] point = new float[3];
        int nCoordinatePoint = coordinate.getNPoints();
        int n = 0;
        while (n < nCoordinatePoint) {
            coordinate.getPoint(n, point);
            bbox.addPoint(point);
            ++n;
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        CoordinateNode coord;
        ColorNode color = this.getColorNodes();
        if (color != null) {
            if (!color.isInstanceNode()) {
                String nodeName = color.getName();
                if (nodeName != null && nodeName.length() > 0) {
                    printStream.println(String.valueOf(indentString) + "\t" + "color DEF " + color.getName() + " Color {");
                } else {
                    printStream.println(String.valueOf(indentString) + "\t" + "color Color {");
                }
                color.outputContext(printStream, String.valueOf(indentString) + "\t");
                printStream.println(String.valueOf(indentString) + "\t" + "}");
            } else {
                printStream.println(String.valueOf(indentString) + "\t" + "color USE " + color.getName());
            }
        }
        if ((coord = this.getCoordinateNodes()) != null) {
            if (!coord.isInstanceNode()) {
                String nodeName = coord.getName();
                if (nodeName != null && nodeName.length() > 0) {
                    printStream.println(String.valueOf(indentString) + "\t" + "coord DEF " + coord.getName() + " Coordinate {");
                } else {
                    printStream.println(String.valueOf(indentString) + "\t" + "coord Coordinate {");
                }
                coord.outputContext(printStream, String.valueOf(indentString) + "\t");
                printStream.println(String.valueOf(indentString) + "\t" + "}");
            } else {
                printStream.println(String.valueOf(indentString) + "\t" + "coord USE " + coord.getName());
            }
        }
    }
}

