/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFImage;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.node.Texture2DNode;

public class PixelTextureNode
extends Texture2DNode {
    private static final String imageExposedFieldName = "image";
    private SFImage imageField;

    public PixelTextureNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.PIXELTEXTURE);
        this.imageField = new SFImage();
        this.addExposedField(imageExposedFieldName, this.imageField);
    }

    public PixelTextureNode(PixelTextureNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFImage getImageField() {
        if (!this.isInstanceNode()) {
            return this.imageField;
        }
        return (SFImage)this.getExposedField(imageExposedFieldName);
    }

    public void addImage(int value) {
        this.getImageField().addValue(value);
    }

    public void setImages(String value) {
        this.getImageField().addValue(value);
    }

    public int getNImages() {
        return this.getImageField().getSize();
    }

    public int getImage(int index) {
        return this.getImageField().get1Value(index);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool repeatS = this.getRepeatSField();
        SFBool repeatT = this.getRepeatTField();
        SFImage image = this.getImageField();
        int imgSize = image.getSize();
        if (3 < imgSize) {
            int width = image.get1Value(0);
            int height = image.get1Value(1);
            int compSize = image.get1Value(2);
            printStream.println(String.valueOf(indentString) + "\t" + "image " + width + " " + height + " " + compSize);
            int linePixels = 0;
            int n = 3;
            while (n < imgSize) {
                if (linePixels == 0) {
                    printStream.print(String.valueOf(indentString) + "\t\t");
                }
                printStream.print("0x" + Integer.toHexString(image.get1Value(n)) + " ");
                if (16 < ++linePixels || n == imgSize - 1) {
                    printStream.println("");
                    linePixels = 0;
                }
                ++n;
            }
        }
        printStream.println(String.valueOf(indentString) + "\t" + "repeatS " + repeatS);
        printStream.println(String.valueOf(indentString) + "\t" + "repeatT " + repeatT);
    }
}

