/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.MFRotation;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.node.InterpolatorNode;
import org.cybergarage.x3d.node.Node;

public class OrientationInterpolatorNode
extends InterpolatorNode {
    private String keyValueFieldName = "keyValue";
    private MFRotation keyValueField;
    private SFRotation valueField;

    public OrientationInterpolatorNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.ORIENTATIONINTERP);
        this.keyValueField = new MFRotation();
        this.addExposedField(this.keyValueFieldName, this.keyValueField);
        this.valueField = new SFRotation(0.0f, 0.0f, 1.0f, 0.0f);
        this.addEventOut("value", this.valueField);
    }

    public OrientationInterpolatorNode(OrientationInterpolatorNode node) {
        this();
        this.setFieldValues(node);
    }

    public MFRotation getKeyValueField() {
        if (!this.isInstanceNode()) {
            return this.keyValueField;
        }
        return (MFRotation)this.getExposedField(this.keyValueFieldName);
    }

    public void addKeyValue(float[] rotation) {
        this.getKeyValueField().addValue(rotation);
    }

    public void addKeyValue(float x, float y, float z, float angle) {
        this.getKeyValueField().addValue(x, y, z, angle);
    }

    public int getNKeyValues() {
        return this.getKeyValueField().getSize();
    }

    public void setKeyValue(int index, float[] rotation) {
        this.getKeyValueField().set1Value(index, rotation);
    }

    public void setKeyValue(int index, float x, float y, float z, float angle) {
        this.getKeyValueField().set1Value(index, x, y, z, angle);
    }

    public void setKeyValues(String value) {
        this.getKeyValueField().setValues(value);
    }

    public void setKeyValues(String[] value) {
        this.getKeyValueField().setValues(value);
    }

    public void getKeyValue(int index, float[] rotation) {
        this.getKeyValueField().get1Value(index, rotation);
    }

    public float[] getKeyValue(int index) {
        float[] value = new float[4];
        this.getKeyValue(index, value);
        return value;
    }

    public void removeKeyValue(int index) {
        this.getKeyValueField().removeValue(index);
    }

    public SFRotation getValueField() {
        if (!this.isInstanceNode()) {
            return this.valueField;
        }
        return (SFRotation)this.getEventOut("value");
    }

    public void setValue(float[] rotation) {
        this.getValueField().setValue(rotation);
    }

    public void setValue(String rotation) {
        this.getValueField().setValue(rotation);
    }

    public void getValue(float[] rotation) {
        this.getValueField().getValue(rotation);
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
        float fraction = this.getFraction();
        int index = -1;
        int n = 0;
        while (n < this.getNKeys() - 1) {
            if (this.getKey(n) <= fraction && fraction <= this.getKey(n + 1)) {
                index = n;
                break;
            }
            ++n;
        }
        if (index == -1) {
            return;
        }
        float scale = (fraction - this.getKey(index)) / (this.getKey(index + 1) - this.getKey(index));
        float[] rotation1 = new float[4];
        float[] rotation2 = new float[4];
        float[] rotationOut = new float[4];
        this.getKeyValue(index, rotation1);
        this.getKeyValue(index + 1, rotation2);
        int n2 = 0;
        while (n2 < 4) {
            rotationOut[n2] = rotation1[n2] + (rotation2[n2] - rotation1[n2]) * scale;
            ++n2;
        }
        this.setValue(rotationOut);
        this.sendEvent(this.getValueField());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        printStream.println(String.valueOf(indentString) + "\tkey [");
        int n = 0;
        while (n < this.getNKeys()) {
            if (n < this.getNKeys() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + this.getKey(n));
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + this.getKey(n));
            }
            ++n;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
        float[] rotation = new float[4];
        printStream.println(String.valueOf(indentString) + "\tkeyValue [");
        int n2 = 0;
        while (n2 < this.getNKeyValues()) {
            this.getKeyValue(n2, rotation);
            if (n2 < this.getNKeyValues() - 1) {
                printStream.println(String.valueOf(indentString) + "\t\t" + rotation[0] + " " + rotation[1] + " " + rotation[2] + " " + rotation[3] + ",");
            } else {
                printStream.println(String.valueOf(indentString) + "\t\t" + rotation[0] + " " + rotation[1] + " " + rotation[2] + " " + rotation[3]);
            }
            ++n2;
        }
        printStream.println(String.valueOf(indentString) + "\t]");
    }
}

