/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.cybergarage.x3d.BaseNode;
import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.InvalidEventInException;
import org.cybergarage.x3d.InvalidEventOutException;
import org.cybergarage.x3d.InvalidExposedFieldException;
import org.cybergarage.x3d.InvalidFieldException;
import org.cybergarage.x3d.InvalidPrivateFieldException;
import org.cybergarage.x3d.MField;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.SceneGraph;
import org.cybergarage.x3d.SceneGraphObject;
import org.cybergarage.x3d.field.FieldList;
import org.cybergarage.x3d.field.MFColor;
import org.cybergarage.x3d.field.MFFloat;
import org.cybergarage.x3d.field.MFInt32;
import org.cybergarage.x3d.field.MFNode;
import org.cybergarage.x3d.field.MFRotation;
import org.cybergarage.x3d.field.MFString;
import org.cybergarage.x3d.field.MFTime;
import org.cybergarage.x3d.field.MFVec2f;
import org.cybergarage.x3d.field.MFVec3f;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFColor;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.field.SFInt32;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFNode;
import org.cybergarage.x3d.field.SFRotation;
import org.cybergarage.x3d.field.SFString;
import org.cybergarage.x3d.field.SFTime;
import org.cybergarage.x3d.field.SFVec2f;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.AnchorNode;
import org.cybergarage.x3d.node.AppearanceNode;
import org.cybergarage.x3d.node.Arc2DNode;
import org.cybergarage.x3d.node.ArcClose2DNode;
import org.cybergarage.x3d.node.AudioClipNode;
import org.cybergarage.x3d.node.BackgroundNode;
import org.cybergarage.x3d.node.BillboardNode;
import org.cybergarage.x3d.node.BindableNode;
import org.cybergarage.x3d.node.BooleanFilterNode;
import org.cybergarage.x3d.node.BooleanSequencerNode;
import org.cybergarage.x3d.node.BooleanTimeTriggerNode;
import org.cybergarage.x3d.node.BooleanToggleNode;
import org.cybergarage.x3d.node.BooleanTriggerNode;
import org.cybergarage.x3d.node.BoxNode;
import org.cybergarage.x3d.node.Circle2DNode;
import org.cybergarage.x3d.node.CollisionNode;
import org.cybergarage.x3d.node.ColorInterpolatorNode;
import org.cybergarage.x3d.node.ColorNode;
import org.cybergarage.x3d.node.ColorRGBANode;
import org.cybergarage.x3d.node.ConeNode;
import org.cybergarage.x3d.node.CoordinateInterpolator2DNode;
import org.cybergarage.x3d.node.CoordinateInterpolatorNode;
import org.cybergarage.x3d.node.CoordinateNode;
import org.cybergarage.x3d.node.CylinderNode;
import org.cybergarage.x3d.node.CylinderSensorNode;
import org.cybergarage.x3d.node.DirectionalLightNode;
import org.cybergarage.x3d.node.Disk2DNode;
import org.cybergarage.x3d.node.ElevationGridNode;
import org.cybergarage.x3d.node.ExtrusionNode;
import org.cybergarage.x3d.node.FillPropertiesNode;
import org.cybergarage.x3d.node.FogNode;
import org.cybergarage.x3d.node.FontStyleNode;
import org.cybergarage.x3d.node.Geometry2DNode;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.GeometryNode;
import org.cybergarage.x3d.node.GroupNode;
import org.cybergarage.x3d.node.GroupingNode;
import org.cybergarage.x3d.node.ImageTextureNode;
import org.cybergarage.x3d.node.IndexedFaceSetNode;
import org.cybergarage.x3d.node.IndexedLineSetNode;
import org.cybergarage.x3d.node.InlineNode;
import org.cybergarage.x3d.node.IntegerSequencerNode;
import org.cybergarage.x3d.node.IntegerTriggerNode;
import org.cybergarage.x3d.node.KeySensorNode;
import org.cybergarage.x3d.node.LODNode;
import org.cybergarage.x3d.node.LinePropertiesNode;
import org.cybergarage.x3d.node.LoadSensorNode;
import org.cybergarage.x3d.node.MaterialNode;
import org.cybergarage.x3d.node.MovieTextureNode;
import org.cybergarage.x3d.node.MultiTextureCoordinateNode;
import org.cybergarage.x3d.node.MultiTextureNode;
import org.cybergarage.x3d.node.MultiTextureTransformNode;
import org.cybergarage.x3d.node.NavigationInfoNode;
import org.cybergarage.x3d.node.NodeConstatns;
import org.cybergarage.x3d.node.NodeObject;
import org.cybergarage.x3d.node.NodeSequencerNode;
import org.cybergarage.x3d.node.NormalInterpolatorNode;
import org.cybergarage.x3d.node.NormalNode;
import org.cybergarage.x3d.node.OrientationInterpolatorNode;
import org.cybergarage.x3d.node.PixelTextureNode;
import org.cybergarage.x3d.node.PlaneSensorNode;
import org.cybergarage.x3d.node.PointLightNode;
import org.cybergarage.x3d.node.PointSetNode;
import org.cybergarage.x3d.node.Polyline2DNode;
import org.cybergarage.x3d.node.Polypoint2DNode;
import org.cybergarage.x3d.node.PositionInterpolator2DNode;
import org.cybergarage.x3d.node.PositionInterpolatorNode;
import org.cybergarage.x3d.node.ProximitySensorNode;
import org.cybergarage.x3d.node.ProxyNode;
import org.cybergarage.x3d.node.Rectangle2DNode;
import org.cybergarage.x3d.node.ScalarInterpolatorNode;
import org.cybergarage.x3d.node.ScriptNode;
import org.cybergarage.x3d.node.Shape2DNode;
import org.cybergarage.x3d.node.ShapeNode;
import org.cybergarage.x3d.node.SoundNode;
import org.cybergarage.x3d.node.SphereNode;
import org.cybergarage.x3d.node.SphereSensorNode;
import org.cybergarage.x3d.node.SpotLightNode;
import org.cybergarage.x3d.node.StaticGroupNode;
import org.cybergarage.x3d.node.StringSensorNode;
import org.cybergarage.x3d.node.SwitchNode;
import org.cybergarage.x3d.node.TextNode;
import org.cybergarage.x3d.node.TextureCoordinateGeneratorNode;
import org.cybergarage.x3d.node.TextureCoordinateNode;
import org.cybergarage.x3d.node.TextureNode;
import org.cybergarage.x3d.node.TextureTransformNode;
import org.cybergarage.x3d.node.TimeSensorNode;
import org.cybergarage.x3d.node.TimeTriggerNode;
import org.cybergarage.x3d.node.TouchSensorNode;
import org.cybergarage.x3d.node.Transform2DNode;
import org.cybergarage.x3d.node.TransformNode;
import org.cybergarage.x3d.node.TriangleFanSetNode;
import org.cybergarage.x3d.node.TriangleSet2DNode;
import org.cybergarage.x3d.node.TriangleSetNode;
import org.cybergarage.x3d.node.TriangleStripSetNode;
import org.cybergarage.x3d.node.ViewpointNode;
import org.cybergarage.x3d.node.VisibilitySensorNode;
import org.cybergarage.x3d.node.WorldInfoNode;
import org.cybergarage.x3d.route.Route;
import org.cybergarage.x3d.util.Debug;
import org.cybergarage.x3d.util.LinkedList;

public abstract class Node
extends BaseNode
implements Runnable,
NodeConstatns {
    public static final int RUNNABLE_TYPE_NONE = 0;
    public static final int RUNNABLE_TYPE_ALWAYS = 1;
    public static final int RUNNABLE_DEFAULT_INTERVAL_TIME = 100;
    private FieldList mFieldList;
    private FieldList mPrivateFieldList;
    private FieldList mExposedFieldList;
    private FieldList mEventInFieldList;
    private FieldList mEventOutFieldList;
    private boolean mInitializationFlag = false;
    private NodeObject mObject = null;
    private Thread mThreadObject = null;
    private boolean mRunnable = false;
    private int mRunnableType = 0;
    private int mRunnableIntervalTime = 100;
    private Node mParentNode = null;
    private LinkedList mChildNodes = new LinkedList();
    private SceneGraph mSceneGraph = null;
    private Object mUserData = null;
    private Node mReferenceNode = null;

    public abstract boolean isChildNodeType(Node var1);

    public abstract void update();

    public void recreateNodeObject() {
        if (!this.isRootNode()) {
            SceneGraph sg = this.getSceneGraph();
            if (sg == null) {
                return;
            }
            SceneGraphObject sgObject = sg.getObject();
            if (sgObject == null) {
                return;
            }
            NodeObject nodeObject = this.getObject();
            if (nodeObject != null) {
                sgObject.removeNode(sg, this);
            }
            nodeObject = sg.createNodeObject(this);
            this.setObject(nodeObject);
            if (nodeObject != null) {
                sgObject.addNode(sg, this);
            }
            Debug.message("Node::recreateNodeObject = " + this + ", " + nodeObject);
        }
    }

    public void initialize() {
    }

    public abstract void uninitialize();

    public Node() {
        this.setHeaderFlag(true);
        this.setParentNode(null);
        this.setSceneGraph(null);
        this.setReferenceNode(null);
        this.setObject(null);
        this.setInitializationFlag(false);
        this.setThreadObject(null);
        this.setRunnable(false);
        this.createFiledLists();
    }

    public void createFiledLists() {
        this.mFieldList = new FieldList(this);
        this.mPrivateFieldList = new FieldList(this);
        this.mExposedFieldList = new FieldList(this);
        this.mEventInFieldList = new FieldList(this);
        this.mEventOutFieldList = new FieldList(this);
    }

    public Node(NodeType nodeType, String nodeName) {
        this();
        this.setType(nodeType);
        this.setName(nodeName);
    }

    public Node(Node node) {
        this();
        this.setFieldValues(node);
    }

    public void removeChildNodes() {
        Node node = this.getChildNodes();
        while (node != null) {
            Node nextNode = node.next();
            node.remove();
            node = nextNode;
        }
    }

    public void removeChildNodesAndNullifyHeadPointer() {
        Node node = this.getChildNodes();
        while (node != null) {
            Node nextNode = node.next();
            node.remove();
            node = nextNode;
        }
        this.mChildNodes.setRootNode(null);
    }

    public void removeRoutes() {
        SceneGraph sg = this.getSceneGraph();
        if (sg != null) {
            Route route = sg.getRoutes();
            while (route != null) {
                Route nextRoute = route.next();
                if (route.getEventInNode() == this || route.getEventOutNode() == this) {
                    route.remove();
                }
                route = nextRoute;
            }
        }
    }

    public void removeSFNodes() {
        SceneGraph sg = this.getSceneGraph();
        if (sg != null) {
            ScriptNode script = sg.findScriptNode();
            while (script != null) {
                int n = 0;
                while (n < script.getNFields()) {
                    SFNode sfnode;
                    Field field = script.getField(n);
                    if (field.getType().equals(FieldType.SFNODE) && (sfnode = (SFNode)field).getValue() == this) {
                        sfnode.setValue((Node)null);
                    }
                    ++n;
                }
                script = (ScriptNode)script.nextTraversalSameType();
            }
        }
    }

    public void removeInstanceNodes() {
        SceneGraph sg = this.getSceneGraph();
        if (sg != null && !this.isInstanceNode()) {
            Node node = sg.getNodes();
            while (node != null) {
                Node nextNode = node.nextTraversal();
                if (node.isInstanceNode()) {
                    Node refNode = node.getReferenceNode();
                    while (refNode.isInstanceNode()) {
                        refNode = refNode.getReferenceNode();
                    }
                    if (refNode == this) {
                        node.removeChildNodes();
                        nextNode = node.nextTraversal();
                        node.remove();
                    }
                }
                node = nextNode;
            }
        }
    }

    public void remove(boolean postShareEvent) {
        SceneGraph sg = this.getSceneGraph();
        if (sg != null) {
            sg.removeNodeObject(this);
        }
        super.remove();
        if (!this.isInstanceNode()) {
            this.removeRoutes();
            this.removeSFNodes();
            this.removeInstanceNodes();
            if (this.isBindableNode() && sg != null) {
                sg.setBindableNode((BindableNode)this, false);
            }
        }
        if (postShareEvent && sg != null) {
            sg.postShareNodeRemoveEvent(this);
        }
        this.setParentNode(null);
        this.setSceneGraph(null);
    }

    @Override
    public void remove() {
        this.remove(true);
    }

    public Field findField(String name) {
        Field field = null;
        try {
            field = this.getField(name);
        }
        catch (InvalidFieldException invalidFieldException) {
            // empty catch block
        }
        if (field != null) {
            return field;
        }
        try {
            field = this.getExposedField(name);
        }
        catch (InvalidExposedFieldException invalidExposedFieldException) {
            // empty catch block
        }
        if (field != null) {
            return field;
        }
        try {
            field = this.getEventIn(name);
        }
        catch (InvalidEventInException invalidEventInException) {
            // empty catch block
        }
        if (field != null) {
            return field;
        }
        try {
            field = this.getEventOut(name);
        }
        catch (InvalidEventOutException invalidEventOutException) {
            // empty catch block
        }
        if (field != null) {
            return field;
        }
        try {
            field = this.getPrivateField(name);
        }
        catch (InvalidPrivateFieldException invalidPrivateFieldException) {
            // empty catch block
        }
        if (field != null) {
            return field;
        }
        return null;
    }

    public boolean hasMField() {
        Field field;
        int fieldSize = this.getNFields();
        int exposedfieldSize = this.getNExposedFields();
        int eventInSize = this.getNEventIn();
        int eventOutSize = this.getNEventOut();
        int privateFieldSize = this.getNPrivateFields();
        int n = 0;
        while (n < fieldSize) {
            field = this.getField(n);
            if (field.isMField()) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < exposedfieldSize) {
            field = this.getExposedField(n);
            if (field.isMField()) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < eventInSize) {
            field = this.getEventIn(n);
            if (field.isMField()) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < eventOutSize) {
            field = this.getEventOut(n);
            if (field.isMField()) {
                return true;
            }
            ++n;
        }
        n = 0;
        while (n < privateFieldSize) {
            field = this.getPrivateField(n);
            if (field.isMField()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public final Field getField(String fieldName) {
        if (fieldName == null) {
            throw new InvalidFieldException(String.valueOf(fieldName) + " is not found.");
        }
        int n = 0;
        while (n < this.getNFields()) {
            Field field = this.getField(n);
            if (fieldName.compareTo(field.getName()) == 0) {
                return field;
            }
            ++n;
        }
        throw new InvalidFieldException(String.valueOf(fieldName) + " is not found.");
    }

    public final int getNFields() {
        return this.mFieldList.size();
    }

    public final void addField(Field field) {
        this.mFieldList.addField(field);
    }

    public final void addField(String name, Field field) {
        field.setName(name);
        this.addField(field);
    }

    public final Field getField(int index) {
        return (Field)this.mFieldList.elementAt(index);
    }

    public final boolean removeField(Field removeField) {
        int n = 0;
        while (n < this.getNFields()) {
            Field field = this.getField(n);
            if (field == removeField) {
                this.mFieldList.removeField(field);
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean removeField(String fieldName) {
        return this.removeField(this.getField(fieldName));
    }

    public int getFieldNumber(Field field) {
        int n = 0;
        while (n < this.getNFields()) {
            if (this.getField(n) == field) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final Field getPrivateField(String fieldName) {
        if (fieldName == null) {
            throw new InvalidPrivateFieldException(String.valueOf(fieldName) + " is not found.");
        }
        int n = 0;
        while (n < this.getNPrivateFields()) {
            Field field = this.getPrivateField(n);
            if (fieldName.compareTo(field.getName()) == 0) {
                return field;
            }
            ++n;
        }
        throw new InvalidPrivateFieldException(String.valueOf(fieldName) + " is not found.");
    }

    public final int getNPrivateFields() {
        return this.mPrivateFieldList.size();
    }

    public final void addPrivateField(Field field) {
        this.mPrivateFieldList.addField(field);
    }

    public final void addPrivateField(String name, Field field) {
        field.setName(name);
        this.addPrivateField(field);
    }

    public final Field getPrivateField(int index) {
        return (Field)this.mPrivateFieldList.elementAt(index);
    }

    public final boolean removePrivateField(Field removeField) {
        int n = 0;
        while (n < this.getNPrivateFields()) {
            Field field = this.getPrivateField(n);
            if (field == removeField) {
                this.mPrivateFieldList.removeField(field);
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean removePrivateField(String fieldName) {
        return this.removePrivateField(this.getPrivateField(fieldName));
    }

    public int getPrivateFieldNumber(Field field) {
        int n = 0;
        while (n < this.getNPrivateFields()) {
            if (this.getPrivateField(n) == field) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final Field getExposedField(String fieldName) {
        if (fieldName == null) {
            throw new InvalidExposedFieldException(String.valueOf(fieldName) + " is not found.");
        }
        int n = 0;
        while (n < this.getNExposedFields()) {
            Field field = this.getExposedField(n);
            if (fieldName.compareTo(field.getName()) == 0) {
                return field;
            }
            if (fieldName.startsWith("set_") && fieldName.endsWith(field.getName())) {
                return field;
            }
            if (fieldName.endsWith("_changed") && fieldName.startsWith(field.getName())) {
                return field;
            }
            ++n;
        }
        throw new InvalidExposedFieldException(String.valueOf(fieldName) + " is not found.");
    }

    public final int getNExposedFields() {
        return this.mExposedFieldList.size();
    }

    public final void addExposedField(Field field) {
        this.mExposedFieldList.addField(field);
    }

    public final void addExposedField(String name, Field field) {
        field.setName(name);
        this.addExposedField(field);
    }

    public final Field getExposedField(int index) {
        return (Field)this.mExposedFieldList.elementAt(index);
    }

    public final boolean removeExposedField(Field removeField) {
        int n = 0;
        while (n < this.getNExposedFields()) {
            Field field = this.getExposedField(n);
            if (field == removeField) {
                this.mExposedFieldList.removeField(field);
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean removeExposedField(String fieldName) {
        return this.removeExposedField(this.getExposedField(fieldName));
    }

    public int getExposedFieldNumber(Field field) {
        int n = 0;
        while (n < this.getNExposedFields()) {
            if (this.getExposedField(n) == field) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final Field getEventIn(String fieldName) {
        if (fieldName == null) {
            throw new InvalidEventInException(String.valueOf(fieldName) + " is not found.");
        }
        int n = 0;
        while (n < this.getNEventIn()) {
            Field field = this.getEventIn(n);
            if (fieldName.compareTo(field.getName()) == 0) {
                return field;
            }
            if (fieldName.startsWith("set_") && fieldName.endsWith(field.getName())) {
                return field;
            }
            ++n;
        }
        throw new InvalidEventInException(String.valueOf(fieldName) + " is not found.");
    }

    public final int getNEventIn() {
        return this.mEventInFieldList.size();
    }

    public final void addEventIn(Field field) {
        this.mEventInFieldList.addField(field);
    }

    public final void addEventIn(String name, Field field) {
        field.setName(name);
        this.addEventIn(field);
    }

    public final Field getEventIn(int index) {
        return (Field)this.mEventInFieldList.elementAt(index);
    }

    public final boolean removeEventIn(Field removeField) {
        int n = 0;
        while (n < this.getNEventIn()) {
            Field field = this.getEventIn(n);
            if (field == removeField) {
                this.mEventInFieldList.removeField(field);
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean removeEventIn(String fieldName) {
        return this.removeEventIn(this.getEventIn(fieldName));
    }

    public int getEventInNumber(Field field) {
        int n = 0;
        while (n < this.getNEventIn()) {
            if (this.getEventIn(n) == field) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public final Field getEventOut(String fieldName) {
        if (fieldName == null) {
            throw new InvalidEventOutException(String.valueOf(fieldName) + " is not found.");
        }
        int n = 0;
        while (n < this.getNEventOut()) {
            Field field = this.getEventOut(n);
            if (fieldName.compareTo(field.getName()) == 0) {
                return field;
            }
            if (fieldName.endsWith("_changed") && fieldName.startsWith(field.getName())) {
                return field;
            }
            ++n;
        }
        throw new InvalidEventOutException(String.valueOf(fieldName) + " is not found.");
    }

    public final int getNEventOut() {
        return this.mEventOutFieldList.size();
    }

    public final void addEventOut(Field field) {
        this.mEventOutFieldList.addField(field);
    }

    public final void addEventOut(String name, Field field) {
        field.setName(name);
        this.addEventOut(field);
    }

    public final Field getEventOut(int index) {
        return (Field)this.mEventOutFieldList.elementAt(index);
    }

    public final boolean removeEventOut(Field removeField) {
        int n = 0;
        while (n < this.getNEventOut()) {
            Field field = this.getEventOut(n);
            if (field == removeField) {
                this.mEventOutFieldList.removeField(field);
                return true;
            }
            ++n;
        }
        return false;
    }

    public final boolean removeEventOut(String fieldName) {
        return this.removeEventOut(this.getEventOut(fieldName));
    }

    public int getEventOutNumber(Field field) {
        int n = 0;
        while (n < this.getNEventOut()) {
            if (this.getEventOut(n) == field) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setParentNode(Node parentNode) {
        this.mParentNode = parentNode;
    }

    public Node getParentNode() {
        return this.mParentNode;
    }

    public boolean isParentNode(Node node) {
        return this.getParentNode() == node;
    }

    public boolean isAncestorNode(Node node) {
        Node parentNode = this.getParentNode();
        while (parentNode != null) {
            if (node == parentNode) {
                return true;
            }
            parentNode = parentNode.getParentNode();
        }
        return false;
    }

    public Node nextTraversal() {
        Node nextNode = this.getChildNodes();
        if (nextNode != null) {
            return nextNode;
        }
        nextNode = this.next();
        if (nextNode == null) {
            Node parentNode = this.getParentNode();
            while (parentNode != null) {
                Node parentNextNode = parentNode.next();
                if (parentNextNode != null) {
                    return parentNextNode;
                }
                parentNode = parentNode.getParentNode();
            }
        }
        return nextNode;
    }

    public Node nextTraversalByType(NodeType type) {
        if (type == null) {
            return null;
        }
        Node node = this.nextTraversal();
        while (node != null) {
            if (node.getType() != null && type.equals(node.getType())) {
                return node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public Node nextTraversalByName(String name) {
        if (name == null) {
            return null;
        }
        Node node = this.nextTraversal();
        while (node != null) {
            if (node.getName() != null && name.compareTo(node.getName()) == 0) {
                return node;
            }
            node = node.nextTraversal();
        }
        return null;
    }

    public Node nextTraversalSameType() {
        return this.nextTraversalByType(this.getType());
    }

    public Node next() {
        return (Node)this.getNextNode();
    }

    public Node next(NodeType type) {
        Node node = this.next();
        while (node != null) {
            if (type.equals(node.getType())) {
                return node;
            }
            node = node.next();
        }
        return null;
    }

    public Node nextSameType() {
        return this.next(this.getType());
    }

    public Node getChildNodes() {
        return (Node)this.mChildNodes.getNodes();
    }

    public boolean hasChildNodes() {
        return this.getChildNodes() != null;
    }

    public Node getFirstChildNodes() {
        int numChild = this.getNChildNodes();
        if (numChild > 0) {
            return this.getChildNode(0);
        }
        return null;
    }

    public Node getLastChildNodes() {
        int numChild = this.getNChildNodes();
        if (numChild > 0) {
            return this.getChildNode(numChild - 1);
        }
        return null;
    }

    public Node getChildNodes(NodeType type) {
        Node node = this.getChildNodes();
        while (node != null) {
            if (type.equals(node.getType())) {
                return node;
            }
            node = node.next();
        }
        return null;
    }

    public Node getChildNodes(NodeType type, String name) {
        Node node = this.getChildNodes();
        while (node != null) {
            if (type.equals(node.getType())) {
                String nodeName = node.getName();
                if (name != null && nodeName.equals(name)) {
                    return node;
                }
            }
            node = node.next();
        }
        return null;
    }

    public Node getChildNode(int n) {
        return (Node)this.mChildNodes.getNode(n);
    }

    public int getNChildNodes() {
        return this.mChildNodes.getNNodes();
    }

    public void addChildNode(Node node, boolean postShareEvent) {
        this.moveChildNode(node, postShareEvent);
        node.initialize();
    }

    public void addChildNodeAtFirst(Node node, boolean postShareEvent) {
        this.moveChildNodeAtFirst(node, postShareEvent);
        node.initialize();
    }

    public void addChildNode(Node node) {
        this.addChildNode(node, true);
    }

    public void addChildNodeAtFirst(Node node) {
        this.addChildNodeAtFirst(node, true);
    }

    public void moveChildNode(Node node, boolean addAtFirst, boolean postShareEvent) {
        SceneGraph sg = this.getSceneGraph();
        if (addAtFirst) {
            this.mChildNodes.addNodeAtFirst(node);
        } else {
            this.mChildNodes.addNode(node);
        }
        node.setParentNode(this);
        node.setSceneGraph(sg);
        if (sg != null) {
            sg.removeNodeObject(this);
            sg.addNodeObject(this);
            sg.postShareNodeAddEvent(node);
        }
    }

    public void moveChildNode(Node node, boolean postShareEvent) {
        this.moveChildNode(node, false, postShareEvent);
    }

    public void moveChildNodeAtFirst(Node node, boolean postShareEvent) {
        this.moveChildNode(node, true, postShareEvent);
    }

    public void moveChildNode(Node node) {
        this.moveChildNode(node, true);
    }

    public void moveChildNodeAtFirst(Node node) {
        this.moveChildNodeAtFirst(node, true);
    }

    public boolean isChild(Node parentNode, Node node) {
        Node cnode = parentNode.getChildNodes();
        while (cnode != null) {
            if (cnode == node) {
                return true;
            }
            cnode = cnode.next();
        }
        return false;
    }

    public boolean isChild(Node node) {
        if (this.getChildNodes() != null) {
            Node cnode = this.getChildNodes();
            while (cnode != null) {
                if (cnode == node) {
                    return true;
                }
                if (this.isChild(cnode, node)) {
                    return true;
                }
                cnode = cnode.next();
            }
        }
        return false;
    }

    public void addChildren(Node[] node) {
        int n = 0;
        while (n < node.length) {
            if (!this.isChild(node[n])) {
                this.addChildNode(node[n]);
            }
            ++n;
        }
    }

    public void removeChildren(Node[] node) {
        int n = 0;
        while (n < node.length) {
            if (this.isChild(node[n])) {
                node[n].remove();
            }
            ++n;
        }
    }

    public GroupingNode getGroupingNodes() {
        Node node = this.getChildNodes();
        while (node != null) {
            if (node.isGroupingNode()) {
                return (GroupingNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public Geometry3DNode getGeometry3DNode() {
        Node node = this.getChildNodes();
        while (node != null) {
            if (node.isGeometry3DNode()) {
                return (Geometry3DNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public Geometry2DNode getGeometry2DNode() {
        return null;
    }

    public GeometryNode getGeometryNode() {
        Geometry3DNode geomNode = this.getGeometry3DNode();
        if (geomNode != null) {
            return geomNode;
        }
        return this.getGeometry2DNode();
    }

    public TextureNode getTextureNode() {
        Node node = this.getChildNodes();
        while (node != null) {
            if (node.isTextureNode()) {
                return (TextureNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public AnchorNode getAnchorNodes() {
        return (AnchorNode)this.getChildNodes(NodeType.ANCHOR);
    }

    public AppearanceNode getAppearanceNodes() {
        return (AppearanceNode)this.getChildNodes(NodeType.APPEARANCE);
    }

    public AudioClipNode getAudioClipNodes() {
        return (AudioClipNode)this.getChildNodes(NodeType.AUDIOCLIP);
    }

    public BackgroundNode getBackgroundNodes() {
        return (BackgroundNode)this.getChildNodes(NodeType.BACKGROUND);
    }

    public BillboardNode getBillboardNodes() {
        return (BillboardNode)this.getChildNodes(NodeType.BILLBOARD);
    }

    public BoxNode getBoxNodes() {
        return (BoxNode)this.getChildNodes(NodeType.BOX);
    }

    public CollisionNode getCollisionNodes() {
        return (CollisionNode)this.getChildNodes(NodeType.COLLISION);
    }

    public ColorNode getColorNodes() {
        return (ColorNode)this.getChildNodes(NodeType.COLOR);
    }

    public ColorInterpolatorNode getColorInterpolatorNodes() {
        return (ColorInterpolatorNode)this.getChildNodes(NodeType.COLORINTERP);
    }

    public ConeNode getConeNodes() {
        return (ConeNode)this.getChildNodes(NodeType.CONE);
    }

    public CoordinateNode getCoordinateNodes() {
        return (CoordinateNode)this.getChildNodes(NodeType.COORD);
    }

    public CoordinateInterpolatorNode getCoordinateInterpolatorNodes() {
        return (CoordinateInterpolatorNode)this.getChildNodes(NodeType.COORDINTERP);
    }

    public CylinderNode getCylinderNodes() {
        return (CylinderNode)this.getChildNodes(NodeType.CYLINDER);
    }

    public CylinderSensorNode getCylinderSensorNodes() {
        return (CylinderSensorNode)this.getChildNodes(NodeType.CYLINDERSENSOR);
    }

    public DirectionalLightNode getDirectionalLightNodes() {
        return (DirectionalLightNode)this.getChildNodes(NodeType.DIRLIGHT);
    }

    public ElevationGridNode getElevationGridNodes() {
        return (ElevationGridNode)this.getChildNodes(NodeType.ELEVATIONGRID);
    }

    public ExtrusionNode getExtrusionNodes() {
        return (ExtrusionNode)this.getChildNodes(NodeType.EXTRUSION);
    }

    public FogNode getFogNodes() {
        return (FogNode)this.getChildNodes(NodeType.FOG);
    }

    public FontStyleNode getFontStyleNodes() {
        return (FontStyleNode)this.getChildNodes(NodeType.FONTSTYLE);
    }

    public GroupNode getGroupNodes() {
        return (GroupNode)this.getChildNodes(NodeType.GROUP);
    }

    public ImageTextureNode getImageTextureNodes() {
        return (ImageTextureNode)this.getChildNodes(NodeType.IMAGETEXTURE);
    }

    public IndexedFaceSetNode getIndexedFaceSetNodes() {
        return (IndexedFaceSetNode)this.getChildNodes(NodeType.INDEXEDFACESET);
    }

    public IndexedLineSetNode getIndexedLineSetNodes() {
        return (IndexedLineSetNode)this.getChildNodes(NodeType.INDEXEDLINESET);
    }

    public InlineNode getInlineNodes() {
        return (InlineNode)this.getChildNodes(NodeType.INLINE);
    }

    public LODNode getLODNodes() {
        return (LODNode)this.getChildNodes(NodeType.LOD);
    }

    public MaterialNode getMaterialNodes() {
        return (MaterialNode)this.getChildNodes(NodeType.MATERIAL);
    }

    public MovieTextureNode getMovieTextureNodes() {
        return (MovieTextureNode)this.getChildNodes(NodeType.MOVIETEXTURE);
    }

    public NavigationInfoNode getNavigationInfoNodes() {
        return (NavigationInfoNode)this.getChildNodes(NodeType.NAVIGATIONINFO);
    }

    public NormalNode getNormalNodes() {
        return (NormalNode)this.getChildNodes(NodeType.NORMAL);
    }

    public NormalInterpolatorNode getNormalInterpolatorNodes() {
        return (NormalInterpolatorNode)this.getChildNodes(NodeType.NORMALINTERP);
    }

    public OrientationInterpolatorNode getOrientationInterpolatorNodes() {
        return (OrientationInterpolatorNode)this.getChildNodes(NodeType.ORIENTATIONINTERP);
    }

    public PixelTextureNode getPixelTextureNodes() {
        return (PixelTextureNode)this.getChildNodes(NodeType.PIXELTEXTURE);
    }

    public PlaneSensorNode getPlaneSensorNodes() {
        return (PlaneSensorNode)this.getChildNodes(NodeType.PLANESENSOR);
    }

    public PointLightNode getPointLightNodes() {
        return (PointLightNode)this.getChildNodes(NodeType.POINTLIGHT);
    }

    public PointSetNode getPointSetNodes() {
        return (PointSetNode)this.getChildNodes(NodeType.POINTSET);
    }

    public PositionInterpolatorNode getPositionInterpolatorNodes() {
        return (PositionInterpolatorNode)this.getChildNodes(NodeType.POSITONINTERP);
    }

    public ProximitySensorNode getProximitySensorNodes() {
        return (ProximitySensorNode)this.getChildNodes(NodeType.PROXIMITYSENSOR);
    }

    public ProxyNode getProxyNodes() {
        return (ProxyNode)this.getChildNodes(NodeType.PROXY);
    }

    public ScalarInterpolatorNode getScalarInterpolatorNodes() {
        return (ScalarInterpolatorNode)this.getChildNodes(NodeType.SCALARINTERP);
    }

    public ScriptNode getScriptNodes() {
        return (ScriptNode)this.getChildNodes(NodeType.SCRIPT);
    }

    public ShapeNode getShapeNodes() {
        return (ShapeNode)this.getChildNodes(NodeType.SHAPE);
    }

    public SoundNode getSoundNodes() {
        return (SoundNode)this.getChildNodes(NodeType.SOUND);
    }

    public SphereNode getSphereNodes() {
        return (SphereNode)this.getChildNodes(NodeType.SPHERE);
    }

    public SphereSensorNode getSphereSensorNodes() {
        return (SphereSensorNode)this.getChildNodes(NodeType.SPHERESENSOR);
    }

    public SpotLightNode getSpotLightNodes() {
        return (SpotLightNode)this.getChildNodes(NodeType.SPOTLIGHT);
    }

    public SwitchNode getSwitchNodes() {
        return (SwitchNode)this.getChildNodes(NodeType.SWITCH);
    }

    public TextNode getTextNodes() {
        return (TextNode)this.getChildNodes(NodeType.TEXT);
    }

    public TextureCoordinateNode getTextureCoordinateNodes() {
        return (TextureCoordinateNode)this.getChildNodes(NodeType.TEXTURECOORD);
    }

    public TextureTransformNode getTextureTransformNodes() {
        return (TextureTransformNode)this.getChildNodes(NodeType.TEXTURETRANSFORM);
    }

    public TimeSensorNode getTimeSensorNodes() {
        return (TimeSensorNode)this.getChildNodes(NodeType.TIMESENSOR);
    }

    public TouchSensorNode getTouchSensorNodes() {
        return (TouchSensorNode)this.getChildNodes(NodeType.TOUCHSENSOR);
    }

    public TransformNode getTransformNodes() {
        return (TransformNode)this.getChildNodes(NodeType.TRANSFORM);
    }

    public ViewpointNode getViewpointNodes() {
        return (ViewpointNode)this.getChildNodes(NodeType.VIEWPOINT);
    }

    public VisibilitySensorNode getVisibilitySensorNodes() {
        return (VisibilitySensorNode)this.getChildNodes(NodeType.VISIBILITYSENSOR);
    }

    public WorldInfoNode getWorldInfoNodes() {
        return (WorldInfoNode)this.getChildNodes(NodeType.WORLDINFO);
    }

    public LoadSensorNode getLoadSensorNodes() {
        return (LoadSensorNode)this.getChildNodes(NodeType.LOADSENSOR);
    }

    public StaticGroupNode getStaticGroupNodes() {
        return (StaticGroupNode)this.getChildNodes(NodeType.STATICGROUP);
    }

    public ColorRGBANode getColorRGBANodes() {
        return (ColorRGBANode)this.getChildNodes(NodeType.COLORRGBA);
    }

    public TriangleSetNode getTriangleSetNodes() {
        return (TriangleSetNode)this.getChildNodes(NodeType.TRIANGLESET);
    }

    public TriangleFanSetNode getTriangleFanSetNodes() {
        return (TriangleFanSetNode)this.getChildNodes(NodeType.TRIANGLEFANSET);
    }

    public TriangleStripSetNode getTriangleStripSetNodes() {
        return (TriangleStripSetNode)this.getChildNodes(NodeType.TRIANGLESTRIPSET);
    }

    public FillPropertiesNode getFillPropertiesNodes() {
        return (FillPropertiesNode)this.getChildNodes(NodeType.FILLPROPERTIES);
    }

    public LinePropertiesNode getLinePropertiesNodes() {
        return (LinePropertiesNode)this.getChildNodes(NodeType.LINEPROPERTIES);
    }

    public Arc2DNode getArc2DNodes() {
        return (Arc2DNode)this.getChildNodes(NodeType.ARC2D);
    }

    public ArcClose2DNode getArcClose2DNodes() {
        return (ArcClose2DNode)this.getChildNodes(NodeType.ARCCLOSE2D);
    }

    public Circle2DNode getCircle2DNodes() {
        return (Circle2DNode)this.getChildNodes(NodeType.CIRCLE2D);
    }

    public Disk2DNode getDisk2DNodes() {
        return (Disk2DNode)this.getChildNodes(NodeType.DISK2D);
    }

    public Polyline2DNode getPolyline2DNodes() {
        return (Polyline2DNode)this.getChildNodes(NodeType.POLYLINE2D);
    }

    public Polypoint2DNode getPolypoint2DNodes() {
        return (Polypoint2DNode)this.getChildNodes(NodeType.POLYPOINT2D);
    }

    public Rectangle2DNode getRectangle2DNodes() {
        return (Rectangle2DNode)this.getChildNodes(NodeType.RECTANGLE2D);
    }

    public TriangleSet2DNode getTriangleSet2DNodes() {
        return (TriangleSet2DNode)this.getChildNodes(NodeType.TRIANGLESET2D);
    }

    public MultiTextureNode getMultiTextureNodes() {
        return (MultiTextureNode)this.getChildNodes(NodeType.MULTITEXTURE);
    }

    public MultiTextureCoordinateNode getMultiTextureCoordinateNodes() {
        return (MultiTextureCoordinateNode)this.getChildNodes(NodeType.MULTITEXTURECOORD);
    }

    public MultiTextureTransformNode getMultiTextureTransformNodes() {
        return (MultiTextureTransformNode)this.getChildNodes(NodeType.MULTITEXTURETRANSFORM);
    }

    public TextureCoordinateGeneratorNode getTextureCoordinateGeneratorNodes() {
        return (TextureCoordinateGeneratorNode)this.getChildNodes(NodeType.TEXCOORDGEN);
    }

    public CoordinateInterpolator2DNode getCoordinateInterpolator2DNodes() {
        return (CoordinateInterpolator2DNode)this.getChildNodes(NodeType.COORDINATEINTERPOLATOR2D);
    }

    public PositionInterpolator2DNode getPositionInterpolator2DNodes() {
        return (PositionInterpolator2DNode)this.getChildNodes(NodeType.POSITIONINTERPOLATOR2D);
    }

    public KeySensorNode getKeySensorNodes() {
        return (KeySensorNode)this.getChildNodes(NodeType.KEYSENSOR);
    }

    public StringSensorNode getStringSensorNodes() {
        return (StringSensorNode)this.getChildNodes(NodeType.STRINGSENSOR);
    }

    public BooleanFilterNode getBooleanFilterNodes() {
        return (BooleanFilterNode)this.getChildNodes(NodeType.BOOLEANFILTER);
    }

    public BooleanToggleNode getBooleanToggleNodes() {
        return (BooleanToggleNode)this.getChildNodes(NodeType.BOOLEANTOGGLE);
    }

    public BooleanTriggerNode getBooleanTriggerNodes() {
        return (BooleanTriggerNode)this.getChildNodes(NodeType.BOOLEANTRIGGER);
    }

    public BooleanSequencerNode getBooleanSequencerNodes() {
        return (BooleanSequencerNode)this.getChildNodes(NodeType.BOOLEANSEQUENCER);
    }

    public IntegerTriggerNode getIntegerTriggerNodes() {
        return (IntegerTriggerNode)this.getChildNodes(NodeType.INTEGERTRIGGER);
    }

    public IntegerSequencerNode getIntegerSequencerNodes() {
        return (IntegerSequencerNode)this.getChildNodes(NodeType.INTEGERSEQUENCER);
    }

    public TimeTriggerNode getTimeTriggerNodes() {
        return (TimeTriggerNode)this.getChildNodes(NodeType.TIMETRIGGER);
    }

    public NodeSequencerNode getNodeSequencerNodes() {
        return (NodeSequencerNode)this.getChildNodes(NodeType.NODESEQUENCER);
    }

    public Shape2DNode getShape2DNodes() {
        return (Shape2DNode)this.getChildNodes(NodeType.SHAPE2D);
    }

    public BooleanTimeTriggerNode getBooleanTimeTriggerNodes() {
        return (BooleanTimeTriggerNode)this.getChildNodes(NodeType.BOOLEANTIMETRIGGER);
    }

    public Transform2DNode getTransform2DNodes() {
        return (Transform2DNode)this.getChildNodes(NodeType.TRANSFORM2D);
    }

    public GroupingNode getGroupingNode(String name) {
        Node node = this.getChildNodes();
        while (node != null) {
            String nodeName;
            if (node.isGroupingNode() && (nodeName = node.getName()) != null && nodeName.equals(name)) {
                return (GroupingNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public Geometry3DNode getGeometry3DNode(String name) {
        Node node = this.getChildNodes();
        while (node != null) {
            String nodeName;
            if (node.isGeometry3DNode() && (nodeName = node.getName()) != null && nodeName.equals(name)) {
                return (Geometry3DNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public TextureNode getTextureNode(String name) {
        Node node = this.getChildNodes();
        while (node != null) {
            String nodeName;
            if (node.isTextureNode() && (nodeName = node.getName()) != null && nodeName.equals(name)) {
                return (TextureNode)node;
            }
            node = node.next();
        }
        return null;
    }

    public AnchorNode getAnchorNode(String name) {
        return (AnchorNode)this.getChildNodes(NodeType.ANCHOR, name);
    }

    public AppearanceNode getAppearanceNode(String name) {
        return (AppearanceNode)this.getChildNodes(NodeType.APPEARANCE, name);
    }

    public AudioClipNode getAudioClipNode(String name) {
        return (AudioClipNode)this.getChildNodes(NodeType.AUDIOCLIP, name);
    }

    public BackgroundNode getBackgroundNode(String name) {
        return (BackgroundNode)this.getChildNodes(NodeType.BACKGROUND, name);
    }

    public BillboardNode getBillboardNode(String name) {
        return (BillboardNode)this.getChildNodes(NodeType.BILLBOARD, name);
    }

    public BoxNode getBoxNode(String name) {
        return (BoxNode)this.getChildNodes(NodeType.BOX, name);
    }

    public CollisionNode getCollisionNode(String name) {
        return (CollisionNode)this.getChildNodes(NodeType.COLLISION, name);
    }

    public ColorNode getColorNode(String name) {
        return (ColorNode)this.getChildNodes(NodeType.COLOR, name);
    }

    public ColorInterpolatorNode getColorInterpolatorNode(String name) {
        return (ColorInterpolatorNode)this.getChildNodes(NodeType.COLORINTERP, name);
    }

    public ConeNode getConeNode(String name) {
        return (ConeNode)this.getChildNodes(NodeType.CONE, name);
    }

    public CoordinateNode getCoordinateNode(String name) {
        return (CoordinateNode)this.getChildNodes(NodeType.COORD, name);
    }

    public CoordinateInterpolatorNode getCoordinateInterpolatorNode(String name) {
        return (CoordinateInterpolatorNode)this.getChildNodes(NodeType.COORDINTERP, name);
    }

    public CylinderNode getCylinderNode(String name) {
        return (CylinderNode)this.getChildNodes(NodeType.CYLINDER, name);
    }

    public CylinderSensorNode getCylinderSensorNode(String name) {
        return (CylinderSensorNode)this.getChildNodes(NodeType.CYLINDERSENSOR, name);
    }

    public DirectionalLightNode getDirectionalLightNode(String name) {
        return (DirectionalLightNode)this.getChildNodes(NodeType.DIRLIGHT, name);
    }

    public ElevationGridNode getElevationGridNode(String name) {
        return (ElevationGridNode)this.getChildNodes(NodeType.ELEVATIONGRID, name);
    }

    public ExtrusionNode getExtrusionNode(String name) {
        return (ExtrusionNode)this.getChildNodes(NodeType.EXTRUSION, name);
    }

    public FogNode getFogNode(String name) {
        return (FogNode)this.getChildNodes(NodeType.FOG, name);
    }

    public FontStyleNode getFontStyleNode(String name) {
        return (FontStyleNode)this.getChildNodes(NodeType.FONTSTYLE, name);
    }

    public GroupNode getGroupNode(String name) {
        return (GroupNode)this.getChildNodes(NodeType.GROUP, name);
    }

    public ImageTextureNode getImageTextureNode(String name) {
        return (ImageTextureNode)this.getChildNodes(NodeType.IMAGETEXTURE, name);
    }

    public IndexedFaceSetNode getIndexedFaceSetNode(String name) {
        return (IndexedFaceSetNode)this.getChildNodes(NodeType.INDEXEDFACESET, name);
    }

    public IndexedLineSetNode getIndexedLineSetNode(String name) {
        return (IndexedLineSetNode)this.getChildNodes(NodeType.INDEXEDLINESET, name);
    }

    public InlineNode getInlineNode(String name) {
        return (InlineNode)this.getChildNodes(NodeType.INLINE, name);
    }

    public LODNode getLODNode(String name) {
        return (LODNode)this.getChildNodes(NodeType.LOD, name);
    }

    public MaterialNode getMaterialNode(String name) {
        return (MaterialNode)this.getChildNodes(NodeType.MATERIAL, name);
    }

    public MovieTextureNode getMovieTextureNode(String name) {
        return (MovieTextureNode)this.getChildNodes(NodeType.MOVIETEXTURE, name);
    }

    public NavigationInfoNode getNavigationInfoNode(String name) {
        return (NavigationInfoNode)this.getChildNodes(NodeType.NAVIGATIONINFO, name);
    }

    public NormalNode getNormalNode(String name) {
        return (NormalNode)this.getChildNodes(NodeType.NORMAL, name);
    }

    public NormalInterpolatorNode getNormalInterpolatorNode(String name) {
        return (NormalInterpolatorNode)this.getChildNodes(NodeType.NORMALINTERP, name);
    }

    public OrientationInterpolatorNode getOrientationInterpolatorNode(String name) {
        return (OrientationInterpolatorNode)this.getChildNodes(NodeType.ORIENTATIONINTERP, name);
    }

    public PixelTextureNode getPixelTextureNode(String name) {
        return (PixelTextureNode)this.getChildNodes(NodeType.PIXELTEXTURE, name);
    }

    public PlaneSensorNode getPlaneSensorNode(String name) {
        return (PlaneSensorNode)this.getChildNodes(NodeType.PLANESENSOR, name);
    }

    public PointLightNode getPointLightNode(String name) {
        return (PointLightNode)this.getChildNodes(NodeType.POINTLIGHT, name);
    }

    public PointSetNode getPointSetNode(String name) {
        return (PointSetNode)this.getChildNodes(NodeType.POINTSET, name);
    }

    public PositionInterpolatorNode getPositionInterpolatorNode(String name) {
        return (PositionInterpolatorNode)this.getChildNodes(NodeType.POSITONINTERP, name);
    }

    public ProximitySensorNode getProximitySensorNode(String name) {
        return (ProximitySensorNode)this.getChildNodes(NodeType.PROXIMITYSENSOR, name);
    }

    public ProxyNode getProxyNode(String name) {
        return (ProxyNode)this.getChildNodes(NodeType.PROXY, name);
    }

    public ScalarInterpolatorNode getScalarInterpolatorNode(String name) {
        return (ScalarInterpolatorNode)this.getChildNodes(NodeType.SCALARINTERP, name);
    }

    public ScriptNode getScriptNode(String name) {
        return (ScriptNode)this.getChildNodes(NodeType.SCRIPT, name);
    }

    public ShapeNode getShapeNode(String name) {
        return (ShapeNode)this.getChildNodes(NodeType.SHAPE, name);
    }

    public SoundNode getSoundNode(String name) {
        return (SoundNode)this.getChildNodes(NodeType.SOUND, name);
    }

    public SphereNode getSphereNode(String name) {
        return (SphereNode)this.getChildNodes(NodeType.SPHERE, name);
    }

    public SphereSensorNode getSphereSensorNode(String name) {
        return (SphereSensorNode)this.getChildNodes(NodeType.SPHERESENSOR, name);
    }

    public SpotLightNode getSpotLightNode(String name) {
        return (SpotLightNode)this.getChildNodes(NodeType.SPOTLIGHT, name);
    }

    public SwitchNode getSwitchNode(String name) {
        return (SwitchNode)this.getChildNodes(NodeType.SWITCH, name);
    }

    public TextNode getTextNode(String name) {
        return (TextNode)this.getChildNodes(NodeType.TEXT, name);
    }

    public TextureCoordinateNode getTextureCoordinateNode(String name) {
        return (TextureCoordinateNode)this.getChildNodes(NodeType.TEXTURECOORD, name);
    }

    public TextureTransformNode getTextureTransformNode(String name) {
        return (TextureTransformNode)this.getChildNodes(NodeType.TEXTURETRANSFORM, name);
    }

    public TimeSensorNode getTimeSensorNode(String name) {
        return (TimeSensorNode)this.getChildNodes(NodeType.TIMESENSOR, name);
    }

    public TouchSensorNode getTouchSensorNode(String name) {
        return (TouchSensorNode)this.getChildNodes(NodeType.TOUCHSENSOR, name);
    }

    public TransformNode getTransformNode(String name) {
        return (TransformNode)this.getChildNodes(NodeType.TRANSFORM, name);
    }

    public ViewpointNode getViewpointNode(String name) {
        return (ViewpointNode)this.getChildNodes(NodeType.VIEWPOINT, name);
    }

    public VisibilitySensorNode getVisibilitySensorNode(String name) {
        return (VisibilitySensorNode)this.getChildNodes(NodeType.VISIBILITYSENSOR, name);
    }

    public WorldInfoNode getWorldInfoNode(String name) {
        return (WorldInfoNode)this.getChildNodes(NodeType.WORLDINFO, name);
    }

    public LoadSensorNode getLoadSensorNode(String name) {
        return (LoadSensorNode)this.getChildNodes(NodeType.LOADSENSOR, name);
    }

    public StaticGroupNode getStaticGroupNode(String name) {
        return (StaticGroupNode)this.getChildNodes(NodeType.STATICGROUP, name);
    }

    public ColorRGBANode getColorRGBANode(String name) {
        return (ColorRGBANode)this.getChildNodes(NodeType.COLORRGBA, name);
    }

    public TriangleSetNode getTriangleSetNode(String name) {
        return (TriangleSetNode)this.getChildNodes(NodeType.TRIANGLESET, name);
    }

    public TriangleFanSetNode getTriangleFanSetNode(String name) {
        return (TriangleFanSetNode)this.getChildNodes(NodeType.TRIANGLEFANSET, name);
    }

    public TriangleStripSetNode getTriangleStripSetNode(String name) {
        return (TriangleStripSetNode)this.getChildNodes(NodeType.TRIANGLESTRIPSET, name);
    }

    public FillPropertiesNode getFillPropertiesNode(String name) {
        return (FillPropertiesNode)this.getChildNodes(NodeType.FILLPROPERTIES, name);
    }

    public LinePropertiesNode getLinePropertiesNode(String name) {
        return (LinePropertiesNode)this.getChildNodes(NodeType.LINEPROPERTIES, name);
    }

    public Arc2DNode getArc2DNode(String name) {
        return (Arc2DNode)this.getChildNodes(NodeType.ARC2D, name);
    }

    public ArcClose2DNode getArcClose2DNode(String name) {
        return (ArcClose2DNode)this.getChildNodes(NodeType.ARCCLOSE2D, name);
    }

    public Circle2DNode getCircle2DNode(String name) {
        return (Circle2DNode)this.getChildNodes(NodeType.CIRCLE2D, name);
    }

    public Disk2DNode getDisk2DNode(String name) {
        return (Disk2DNode)this.getChildNodes(NodeType.DISK2D, name);
    }

    public Polyline2DNode getPolyline2DNode(String name) {
        return (Polyline2DNode)this.getChildNodes(NodeType.POLYLINE2D, name);
    }

    public Polypoint2DNode getPolypoint2DNode(String name) {
        return (Polypoint2DNode)this.getChildNodes(NodeType.POLYPOINT2D, name);
    }

    public Rectangle2DNode getRectangle2DNode(String name) {
        return (Rectangle2DNode)this.getChildNodes(NodeType.RECTANGLE2D, name);
    }

    public TriangleSet2DNode getTriangleSet2DNode(String name) {
        return (TriangleSet2DNode)this.getChildNodes(NodeType.TRIANGLESET2D, name);
    }

    public MultiTextureNode getMultiTextureNode(String name) {
        return (MultiTextureNode)this.getChildNodes(NodeType.MULTITEXTURE, name);
    }

    public MultiTextureCoordinateNode getMultiTextureCoordinateNode(String name) {
        return (MultiTextureCoordinateNode)this.getChildNodes(NodeType.MULTITEXTURECOORD, name);
    }

    public MultiTextureTransformNode getMultiTextureTransformNode(String name) {
        return (MultiTextureTransformNode)this.getChildNodes(NodeType.MULTITEXTURETRANSFORM, name);
    }

    public TextureCoordinateGeneratorNode getTextureCoordinateGeneratorNode(String name) {
        return (TextureCoordinateGeneratorNode)this.getChildNodes(NodeType.TEXCOORDGEN, name);
    }

    public CoordinateInterpolator2DNode getCoordinateInterpolator2DNode(String name) {
        return (CoordinateInterpolator2DNode)this.getChildNodes(NodeType.COORDINATEINTERPOLATOR2D, name);
    }

    public PositionInterpolator2DNode getPositionInterpolator2DNode(String name) {
        return (PositionInterpolator2DNode)this.getChildNodes(NodeType.POSITIONINTERPOLATOR2D, name);
    }

    public KeySensorNode getKeySensorNode(String name) {
        return (KeySensorNode)this.getChildNodes(NodeType.KEYSENSOR, name);
    }

    public StringSensorNode getStringSensorNode(String name) {
        return (StringSensorNode)this.getChildNodes(NodeType.STRINGSENSOR, name);
    }

    public BooleanFilterNode getBooleanFilterNode(String name) {
        return (BooleanFilterNode)this.getChildNodes(NodeType.BOOLEANFILTER, name);
    }

    public BooleanToggleNode getBooleanToggleNode(String name) {
        return (BooleanToggleNode)this.getChildNodes(NodeType.BOOLEANTOGGLE, name);
    }

    public BooleanTriggerNode getBooleanTriggerNode(String name) {
        return (BooleanTriggerNode)this.getChildNodes(NodeType.BOOLEANTRIGGER, name);
    }

    public BooleanSequencerNode getBooleanSequencerNode(String name) {
        return (BooleanSequencerNode)this.getChildNodes(NodeType.BOOLEANSEQUENCER, name);
    }

    public IntegerTriggerNode getIntegerTriggerNode(String name) {
        return (IntegerTriggerNode)this.getChildNodes(NodeType.INTEGERTRIGGER, name);
    }

    public IntegerSequencerNode getIntegerSequencerNode(String name) {
        return (IntegerSequencerNode)this.getChildNodes(NodeType.INTEGERSEQUENCER, name);
    }

    public TimeTriggerNode getTimeTriggerNode(String name) {
        return (TimeTriggerNode)this.getChildNodes(NodeType.TIMETRIGGER, name);
    }

    public NodeSequencerNode getNodeSequencerNode(String name) {
        return (NodeSequencerNode)this.getChildNodes(NodeType.NODESEQUENCER, name);
    }

    public Shape2DNode getShape2DNode(String name) {
        return (Shape2DNode)this.getChildNodes(NodeType.SHAPE2D, name);
    }

    public BooleanTimeTriggerNode getBooleanTimeTriggerNode(String name) {
        return (BooleanTimeTriggerNode)this.getChildNodes(NodeType.BOOLEANTIMETRIGGER, name);
    }

    public Transform2DNode getTransform2DNode(String name) {
        return (Transform2DNode)this.getChildNodes(NodeType.TRANSFORM2D, name);
    }

    public boolean hasGroupingNodes() {
        Node node = this.getChildNodes();
        while (node != null) {
            if (node.isGroupingNode()) {
                return true;
            }
            node = node.next();
        }
        return false;
    }

    public boolean hasGeometry3DNode() {
        Node node = this.getChildNodes();
        while (node != null) {
            if (node.isGeometry3DNode()) {
                return true;
            }
            node = node.next();
        }
        return false;
    }

    public boolean hasTextureNode() {
        Node node = this.getChildNodes();
        while (node != null) {
            if (node.isTextureNode()) {
                return true;
            }
            node = node.next();
        }
        return false;
    }

    public boolean hasAnchorNodes() {
        return this.getChildNodes(NodeType.ANCHOR) != null;
    }

    public boolean hasAppearanceNodes() {
        return this.getChildNodes(NodeType.APPEARANCE) != null;
    }

    public boolean hasAudioClipNodes() {
        return this.getChildNodes(NodeType.AUDIOCLIP) != null;
    }

    public boolean hasBackgroundNodes() {
        return this.getChildNodes(NodeType.BACKGROUND) != null;
    }

    public boolean hasBillboardNodes() {
        return this.getChildNodes(NodeType.BILLBOARD) != null;
    }

    public boolean hasBoxNodes() {
        return this.getChildNodes(NodeType.BOX) != null;
    }

    public boolean hasCollisionNodes() {
        return this.getChildNodes(NodeType.COLLISION) != null;
    }

    public boolean hasColorNodes() {
        return this.getChildNodes(NodeType.COLOR) != null;
    }

    public boolean hasColorInterpolatorNodes() {
        return this.getChildNodes(NodeType.COLORINTERP) != null;
    }

    public boolean hasConeNodes() {
        return this.getChildNodes(NodeType.CONE) != null;
    }

    public boolean hasCoordinateNodes() {
        return this.getChildNodes(NodeType.COORD) != null;
    }

    public boolean hasCoordinateInterpolatorNodes() {
        return this.getChildNodes(NodeType.COORDINTERP) != null;
    }

    public boolean hasCylinderNodes() {
        return this.getChildNodes(NodeType.CYLINDER) != null;
    }

    public boolean hasCylinderSensorNodes() {
        return this.getChildNodes(NodeType.CYLINDERSENSOR) != null;
    }

    public boolean hasDirectionalLightNodes() {
        return this.getChildNodes(NodeType.DIRLIGHT) != null;
    }

    public boolean hasElevationGridNodes() {
        return this.getChildNodes(NodeType.ELEVATIONGRID) != null;
    }

    public boolean hasExtrusionNodes() {
        return this.getChildNodes(NodeType.EXTRUSION) != null;
    }

    public boolean hasFogNodes() {
        return this.getChildNodes(NodeType.FOG) != null;
    }

    public boolean hasFontStyleNodes() {
        return this.getChildNodes(NodeType.FONTSTYLE) != null;
    }

    public boolean hasGroupNodes() {
        return this.getChildNodes(NodeType.GROUP) != null;
    }

    public boolean hasImageTextureNodes() {
        return this.getChildNodes(NodeType.IMAGETEXTURE) != null;
    }

    public boolean hasIndexedFaceSetNodes() {
        return this.getChildNodes(NodeType.INDEXEDFACESET) != null;
    }

    public boolean hasIndexedLineSetNodes() {
        return this.getChildNodes(NodeType.INDEXEDLINESET) != null;
    }

    public boolean hasInlineNodes() {
        return this.getChildNodes(NodeType.INLINE) != null;
    }

    public boolean hasLODNodes() {
        return this.getChildNodes(NodeType.LOD) != null;
    }

    public boolean hasMaterialNodes() {
        return this.getChildNodes(NodeType.MATERIAL) != null;
    }

    public boolean hasMovieTextureNodes() {
        return this.getChildNodes(NodeType.MOVIETEXTURE) != null;
    }

    public boolean hasNavigationInfoNodes() {
        return this.getChildNodes(NodeType.NAVIGATIONINFO) != null;
    }

    public boolean hasNormalNodes() {
        return this.getChildNodes(NodeType.NORMAL) != null;
    }

    public boolean hasNormalInterpolatorNodes() {
        return this.getChildNodes(NodeType.NORMALINTERP) != null;
    }

    public boolean hasOrientationInterpolatorNodes() {
        return this.getChildNodes(NodeType.ORIENTATIONINTERP) != null;
    }

    public boolean hasPixelTextureNodes() {
        return this.getChildNodes(NodeType.PIXELTEXTURE) != null;
    }

    public boolean hasPlaneSensorNodes() {
        return this.getChildNodes(NodeType.PLANESENSOR) != null;
    }

    public boolean hasPointLightNodes() {
        return this.getChildNodes(NodeType.POINTLIGHT) != null;
    }

    public boolean hasPointSetNodes() {
        return this.getChildNodes(NodeType.POINTSET) != null;
    }

    public boolean hasPositionInterpolatorNodes() {
        return this.getChildNodes(NodeType.POSITONINTERP) != null;
    }

    public boolean hasProximitySensorNodes() {
        return this.getChildNodes(NodeType.PROXIMITYSENSOR) != null;
    }

    public boolean hasProxyNodes() {
        return this.getChildNodes(NodeType.PROXY) != null;
    }

    public boolean hasScalarInterpolatorNodes() {
        return this.getChildNodes(NodeType.SCALARINTERP) != null;
    }

    public boolean hasScriptNodes() {
        return this.getChildNodes(NodeType.SCRIPT) != null;
    }

    public boolean hasShapeNodes() {
        return this.getChildNodes(NodeType.SHAPE) != null;
    }

    public boolean hasSoundNodes() {
        return this.getChildNodes(NodeType.SOUND) != null;
    }

    public boolean hasSphereNodes() {
        return this.getChildNodes(NodeType.SPHERE) != null;
    }

    public boolean hasSphereSensorNodes() {
        return this.getChildNodes(NodeType.SPHERESENSOR) != null;
    }

    public boolean hasSpotLightNodes() {
        return this.getChildNodes(NodeType.SPOTLIGHT) != null;
    }

    public boolean hasSwitchNodes() {
        return this.getChildNodes(NodeType.SWITCH) != null;
    }

    public boolean hasTextNodes() {
        return this.getChildNodes(NodeType.TEXT) != null;
    }

    public boolean hasTextureCoordinateNodes() {
        return this.getChildNodes(NodeType.TEXTURECOORD) != null;
    }

    public boolean hasTextureTransformNodes() {
        return this.getChildNodes(NodeType.TEXTURETRANSFORM) != null;
    }

    public boolean hasTimeSensorNodes() {
        return this.getChildNodes(NodeType.TIMESENSOR) != null;
    }

    public boolean hasTouchSensorNodes() {
        return this.getChildNodes(NodeType.TOUCHSENSOR) != null;
    }

    public boolean hasTransformNodes() {
        return this.getChildNodes(NodeType.TRANSFORM) != null;
    }

    public boolean hasViewpointNodes() {
        return this.getChildNodes(NodeType.VIEWPOINT) != null;
    }

    public boolean hasVisibilitySensorNodes() {
        return this.getChildNodes(NodeType.VISIBILITYSENSOR) != null;
    }

    public boolean hasWorldInfoNodes() {
        return this.getChildNodes(NodeType.WORLDINFO) != null;
    }

    public boolean hasLoadSensorNode() {
        return this.getChildNodes(NodeType.LOADSENSOR) != null;
    }

    public boolean hasStaticGroupNode() {
        return this.getChildNodes(NodeType.STATICGROUP) != null;
    }

    public boolean hasColorRGBANode() {
        return this.getChildNodes(NodeType.COLORRGBA) != null;
    }

    public boolean hasTriangleSetNode() {
        return this.getChildNodes(NodeType.TRIANGLESET) != null;
    }

    public boolean hasTriangleFanSetNode() {
        return this.getChildNodes(NodeType.TRIANGLEFANSET) != null;
    }

    public boolean hasTriangleStripSetNode() {
        return this.getChildNodes(NodeType.TRIANGLESTRIPSET) != null;
    }

    public boolean hasFillPropertiesNode() {
        return this.getChildNodes(NodeType.FILLPROPERTIES) != null;
    }

    public boolean hasLinePropertiesNode() {
        return this.getChildNodes(NodeType.LINEPROPERTIES) != null;
    }

    public boolean hasArc2DNode() {
        return this.getChildNodes(NodeType.ARC2D) != null;
    }

    public boolean hasArcClose2DNode() {
        return this.getChildNodes(NodeType.ARCCLOSE2D) != null;
    }

    public boolean hasCircle2DNode() {
        return this.getChildNodes(NodeType.CIRCLE2D) != null;
    }

    public boolean hasDisk2DNode() {
        return this.getChildNodes(NodeType.DISK2D) != null;
    }

    public boolean hasPolyline2DNode() {
        return this.getChildNodes(NodeType.POLYLINE2D) != null;
    }

    public boolean hasPolypoint2DNode() {
        return this.getChildNodes(NodeType.POLYPOINT2D) != null;
    }

    public boolean hasRectangle2DNode() {
        return this.getChildNodes(NodeType.RECTANGLE2D) != null;
    }

    public boolean hasTriangleSet2DNode() {
        return this.getChildNodes(NodeType.TRIANGLESET2D) != null;
    }

    public boolean hasMultiTextureNode() {
        return this.getChildNodes(NodeType.MULTITEXTURE) != null;
    }

    public boolean hasMultiTextureCoordinateNode() {
        return this.getChildNodes(NodeType.MULTITEXTURECOORD) != null;
    }

    public boolean hasMultiTextureTransformNode() {
        return this.getChildNodes(NodeType.MULTITEXTURETRANSFORM) != null;
    }

    public boolean hasTextureCoordinateGeneratorNode() {
        return this.getChildNodes(NodeType.TEXCOORDGEN) != null;
    }

    public boolean hasCoordinateInterpolator2DNode() {
        return this.getChildNodes(NodeType.COORDINATEINTERPOLATOR2D) != null;
    }

    public boolean hasPositionInterpolator2DNode() {
        return this.getChildNodes(NodeType.POSITIONINTERPOLATOR2D) != null;
    }

    public boolean hasKeySensorNode() {
        return this.getChildNodes(NodeType.KEYSENSOR) != null;
    }

    public boolean hasStringSensorNode() {
        return this.getChildNodes(NodeType.STRINGSENSOR) != null;
    }

    public boolean hasBooleanFilterNode() {
        return this.getChildNodes(NodeType.BOOLEANFILTER) != null;
    }

    public boolean hasBooleanToggleNode() {
        return this.getChildNodes(NodeType.BOOLEANTOGGLE) != null;
    }

    public boolean hasBooleanTriggerNode() {
        return this.getChildNodes(NodeType.BOOLEANTRIGGER) != null;
    }

    public boolean hasBooleanSequencerNode() {
        return this.getChildNodes(NodeType.BOOLEANSEQUENCER) != null;
    }

    public boolean hasIntegerTriggerNode() {
        return this.getChildNodes(NodeType.INTEGERTRIGGER) != null;
    }

    public boolean hasIntegerSequencerNode() {
        return this.getChildNodes(NodeType.INTEGERSEQUENCER) != null;
    }

    public boolean hasTimeTriggerNode() {
        return this.getChildNodes(NodeType.TIMETRIGGER) != null;
    }

    public boolean hasNodeSequencerNode() {
        return this.getChildNodes(NodeType.NODESEQUENCER) != null;
    }

    public boolean hasShape2DNode() {
        return this.getChildNodes(NodeType.SHAPE2D) != null;
    }

    public boolean hasBooleanTimeTriggerNode() {
        return this.getChildNodes(NodeType.BOOLEANTIMETRIGGER) != null;
    }

    public boolean hasTransform2DNode() {
        return this.getChildNodes(NodeType.TRANSFORM2D) != null;
    }

    public boolean isXMLNode() {
        return this.isNode(NodeType.XML);
    }

    public boolean isVRML97Node() {
        return !this.isXMLNode();
    }

    public boolean isX3DNode() {
        return !this.isXMLNode();
    }

    public boolean isNode(NodeType type) {
        NodeType nodeType = this.getType();
        return nodeType.equals(type);
    }

    public boolean isGroupingNode() {
        return this.isAnchorNode() || this.isBillboardNode() || this.isCollisionNode() || this.isGroupNode() || this.isTransformNode() || this.isInlineNode() || this.isSwitchNode();
    }

    public boolean isSpecialGroupNode() {
        return this.isInlineNode() || this.isLODNode() || this.isSwitchNode();
    }

    public boolean isCommonNode() {
        return this.isLightNode() || this.isAudioClipNode() || this.isScriptNode() || this.isShapeNode() || this.isSoundNode() || this.isWorldInfoNode();
    }

    public boolean isLightNode() {
        return this.isDirectionalLightNode() || this.isSpotLightNode() || this.isPointLightNode();
    }

    public boolean isGeometry3DNode() {
        return this.isBoxNode() || this.isConeNode() || this.isCylinderNode() || this.isElevationGridNode() || this.isExtrusionNode() || this.isIndexedFaceSetNode() || this.isIndexedLineSetNode() || this.isPointSetNode() || this.isSphereNode() || this.isTextNode();
    }

    public boolean isGeometryPropertyNode() {
        return this.isColorNode() || this.isCoordinateNode() || this.isNormalNode() || this.isTextureCoordinateNode();
    }

    public boolean isTextureNode() {
        return this.isMovieTextureNode() || this.isPixelTextureNode() || this.isImageTextureNode();
    }

    public boolean isSensorNode() {
        return this.isCylinderSensorNode() || this.isPlaneSensorNode() || this.isSphereSensorNode() || this.isProximitySensorNode() || this.isTimeSensorNode() || this.isTouchSensorNode() || this.isVisibilitySensorNode();
    }

    public boolean isInterpolatorNode() {
        return this.isColorInterpolatorNode() || this.isCoordinateInterpolatorNode() || this.isNormalInterpolatorNode() || this.isOrientationInterpolatorNode() || this.isPositionInterpolatorNode() || this.isScalarInterpolatorNode();
    }

    public boolean isAppearancePropertyNode() {
        return this.isMaterialNode() || this.isTextureTransformNode() || this.isTextureNode();
    }

    public boolean isAppearanceInfoNode() {
        return this.isAppearanceNode() || this.isFontStyleNode() || this.isMaterialNode() || this.isTextureTransformNode() || this.isTextureNode();
    }

    public boolean isBindableNode() {
        return this.isBackgroundNode() || this.isFogNode() || this.isNavigationInfoNode() || this.isViewpointNode();
    }

    public boolean isRootNode() {
        return this.isNode(NodeType.ROOT);
    }

    public boolean isAnchorNode() {
        return this.isNode(NodeType.ANCHOR);
    }

    public boolean isAppearanceNode() {
        return this.isNode(NodeType.APPEARANCE);
    }

    public boolean isAudioClipNode() {
        return this.isNode(NodeType.AUDIOCLIP);
    }

    public boolean isBackgroundNode() {
        return this.isNode(NodeType.BACKGROUND);
    }

    public boolean isBillboardNode() {
        return this.isNode(NodeType.BILLBOARD);
    }

    public boolean isBoxNode() {
        return this.isNode(NodeType.BOX);
    }

    public boolean isCollisionNode() {
        return this.isNode(NodeType.COLLISION);
    }

    public boolean isColorNode() {
        return this.isNode(NodeType.COLOR);
    }

    public boolean isColorInterpolatorNode() {
        return this.isNode(NodeType.COLORINTERP);
    }

    public boolean isConeNode() {
        return this.isNode(NodeType.CONE);
    }

    public boolean isCoordinateNode() {
        return this.isNode(NodeType.COORD);
    }

    public boolean isCoordinateInterpolatorNode() {
        return this.isNode(NodeType.COORDINTERP);
    }

    public boolean isCylinderNode() {
        return this.isNode(NodeType.CYLINDER);
    }

    public boolean isCylinderSensorNode() {
        return this.isNode(NodeType.CYLINDERSENSOR);
    }

    public boolean isDirectionalLightNode() {
        return this.isNode(NodeType.DIRLIGHT);
    }

    public boolean isElevationGridNode() {
        return this.isNode(NodeType.ELEVATIONGRID);
    }

    public boolean isExtrusionNode() {
        return this.isNode(NodeType.EXTRUSION);
    }

    public boolean isFogNode() {
        return this.isNode(NodeType.FOG);
    }

    public boolean isFontStyleNode() {
        return this.isNode(NodeType.FONTSTYLE);
    }

    public boolean isGroupNode() {
        return this.isNode(NodeType.GROUP);
    }

    public boolean isImageTextureNode() {
        return this.isNode(NodeType.IMAGETEXTURE);
    }

    public boolean isIndexedFaceSetNode() {
        return this.isNode(NodeType.INDEXEDFACESET);
    }

    public boolean isIndexedLineSetNode() {
        return this.isNode(NodeType.INDEXEDLINESET);
    }

    public boolean isInlineNode() {
        return this.isNode(NodeType.INLINE);
    }

    public boolean isLODNode() {
        return this.isNode(NodeType.LOD);
    }

    public boolean isMaterialNode() {
        return this.isNode(NodeType.MATERIAL);
    }

    public boolean isMovieTextureNode() {
        return this.isNode(NodeType.MOVIETEXTURE);
    }

    public boolean isNavigationInfoNode() {
        return this.isNode(NodeType.NAVIGATIONINFO);
    }

    public boolean isNormalNode() {
        return this.isNode(NodeType.NORMAL);
    }

    public boolean isNormalInterpolatorNode() {
        return this.isNode(NodeType.NORMALINTERP);
    }

    public boolean isOrientationInterpolatorNode() {
        return this.isNode(NodeType.ORIENTATIONINTERP);
    }

    public boolean isPixelTextureNode() {
        return this.isNode(NodeType.PIXELTEXTURE);
    }

    public boolean isPlaneSensorNode() {
        return this.isNode(NodeType.PLANESENSOR);
    }

    public boolean isPointLightNode() {
        return this.isNode(NodeType.POINTLIGHT);
    }

    public boolean isPointSetNode() {
        return this.isNode(NodeType.POINTSET);
    }

    public boolean isPositionInterpolatorNode() {
        return this.isNode(NodeType.POSITONINTERP);
    }

    public boolean isProximitySensorNode() {
        return this.isNode(NodeType.PROXIMITYSENSOR);
    }

    public boolean isProxyNode() {
        return this.isNode(NodeType.PROXY);
    }

    public boolean isScalarInterpolatorNode() {
        return this.isNode(NodeType.SCALARINTERP);
    }

    public boolean isScriptNode() {
        return this.isNode(NodeType.SCRIPT);
    }

    public boolean isShapeNode() {
        return this.isNode(NodeType.SHAPE);
    }

    public boolean isSoundNode() {
        return this.isNode(NodeType.SOUND);
    }

    public boolean isSphereNode() {
        return this.isNode(NodeType.SPHERE);
    }

    public boolean isSphereSensorNode() {
        return this.isNode(NodeType.SPHERESENSOR);
    }

    public boolean isSpotLightNode() {
        return this.isNode(NodeType.SPOTLIGHT);
    }

    public boolean isSwitchNode() {
        return this.isNode(NodeType.SWITCH);
    }

    public boolean isTextNode() {
        return this.isNode(NodeType.TEXT);
    }

    public boolean isTextureCoordinateNode() {
        return this.isNode(NodeType.TEXTURECOORD);
    }

    public boolean isTextureTransformNode() {
        return this.isNode(NodeType.TEXTURETRANSFORM);
    }

    public boolean isTimeSensorNode() {
        return this.isNode(NodeType.TIMESENSOR);
    }

    public boolean isTouchSensorNode() {
        return this.isNode(NodeType.TOUCHSENSOR);
    }

    public boolean isTransformNode() {
        return this.isNode(NodeType.TRANSFORM);
    }

    public boolean isViewpointNode() {
        return this.isNode(NodeType.VIEWPOINT);
    }

    public boolean isVisibilitySensorNode() {
        return this.isNode(NodeType.VISIBILITYSENSOR);
    }

    public boolean isWorldInfoNode() {
        return this.isNode(NodeType.WORLDINFO);
    }

    public boolean isLoadSensorNode() {
        return this.isNode(NodeType.LOADSENSOR);
    }

    public boolean isStaticGroupNode() {
        return this.isNode(NodeType.STATICGROUP);
    }

    public boolean isColorRGBANode() {
        return this.isNode(NodeType.COLORRGBA);
    }

    public boolean isTriangleSetNode() {
        return this.isNode(NodeType.TRIANGLESET);
    }

    public boolean isTriangleFanSetNode() {
        return this.isNode(NodeType.TRIANGLEFANSET);
    }

    public boolean isTriangleStripSetNode() {
        return this.isNode(NodeType.TRIANGLESTRIPSET);
    }

    public boolean isFillPropertiesNode() {
        return this.isNode(NodeType.FILLPROPERTIES);
    }

    public boolean isLinePropertiesNode() {
        return this.isNode(NodeType.LINEPROPERTIES);
    }

    public boolean isArc2DNode() {
        return this.isNode(NodeType.ARC2D);
    }

    public boolean isArcClose2DNode() {
        return this.isNode(NodeType.ARCCLOSE2D);
    }

    public boolean isCircle2DNode() {
        return this.isNode(NodeType.CIRCLE2D);
    }

    public boolean isDisk2DNode() {
        return this.isNode(NodeType.DISK2D);
    }

    public boolean isPolyline2DNode() {
        return this.isNode(NodeType.POLYLINE2D);
    }

    public boolean isPolypoint2DNode() {
        return this.isNode(NodeType.POLYPOINT2D);
    }

    public boolean isRectangle2DNode() {
        return this.isNode(NodeType.RECTANGLE2D);
    }

    public boolean isTriangleSet2DNode() {
        return this.isNode(NodeType.TRIANGLESET2D);
    }

    public boolean isMultiTextureNode() {
        return this.isNode(NodeType.MULTITEXTURE);
    }

    public boolean isMultiTextureCoordinateNode() {
        return this.isNode(NodeType.MULTITEXTURECOORD);
    }

    public boolean isMultiTextureTransformNode() {
        return this.isNode(NodeType.MULTITEXTURETRANSFORM);
    }

    public boolean isTextureCoordinateGeneratorNode() {
        return this.isNode(NodeType.TEXCOORDGEN);
    }

    public boolean isCoordinateInterpolator2DNode() {
        return this.isNode(NodeType.COORDINATEINTERPOLATOR2D);
    }

    public boolean isPositionInterpolator2DNode() {
        return this.isNode(NodeType.POSITIONINTERPOLATOR2D);
    }

    public boolean isKeySensorNode() {
        return this.isNode(NodeType.KEYSENSOR);
    }

    public boolean isStringSensorNode() {
        return this.isNode(NodeType.STRINGSENSOR);
    }

    public boolean isBooleanFilterNode() {
        return this.isNode(NodeType.BOOLEANFILTER);
    }

    public boolean isBooleanToggleNode() {
        return this.isNode(NodeType.BOOLEANTOGGLE);
    }

    public boolean isBooleanTriggerNode() {
        return this.isNode(NodeType.BOOLEANTRIGGER);
    }

    public boolean isBooleanSequencerNode() {
        return this.isNode(NodeType.BOOLEANSEQUENCER);
    }

    public boolean isIntegerTriggerNode() {
        return this.isNode(NodeType.INTEGERTRIGGER);
    }

    public boolean isIntegerSequencerNode() {
        return this.isNode(NodeType.INTEGERSEQUENCER);
    }

    public boolean isTimeTriggerNode() {
        return this.isNode(NodeType.TIMETRIGGER);
    }

    public boolean isNodeSequencerNode() {
        return this.isNode(NodeType.NODESEQUENCER);
    }

    public boolean isShape2DNode() {
        return this.isNode(NodeType.SHAPE2D);
    }

    public boolean isBooleanTimeTriggerNode() {
        return this.isNode(NodeType.BOOLEANTIMETRIGGER);
    }

    public boolean isTransform2DNode() {
        return this.isNode(NodeType.TRANSFORM2D);
    }

    public boolean isRouteNode() {
        return this.isNode(NodeType.ROUTE);
    }

    public String getSpaceString(int nSpaces) {
        StringBuffer str = new StringBuffer();
        int n = 0;
        while (n < nSpaces) {
            str.append(' ');
            ++n;
        }
        return str.toString();
    }

    public String getIndentLevelString(int nIndentLevel) {
        char[] indentString = new char[nIndentLevel];
        int n = 0;
        while (n < nIndentLevel) {
            indentString[n] = 9;
            ++n;
        }
        return new String(indentString);
    }

    public void outputHead(PrintWriter ps, String indentString) {
        String nodeName = this.getName();
        if (nodeName != null && nodeName.length() > 0) {
            ps.println(String.valueOf(indentString) + "DEF " + nodeName + " " + this.getType() + " {");
        } else {
            ps.println(String.valueOf(indentString) + this.getType() + " {");
        }
    }

    public void outputTail(PrintWriter ps, String indentString) {
        ps.println(String.valueOf(indentString) + "}");
    }

    public abstract void outputContext(PrintWriter var1, String var2);

    public void output(PrintWriter ps, int indentLevel) {
        String indentString = this.getIndentLevelString(indentLevel);
        if (!this.isInstanceNode()) {
            this.outputHead(ps, indentString);
            this.outputContext(ps, indentString);
            if (!(this.isElevationGridNode() || this.isShapeNode() || this.isSoundNode() || this.isPointSetNode() || this.isIndexedFaceSetNode() || this.isIndexedLineSetNode() || this.isTextNode() || this.isAppearanceNode() || this.isScriptNode() || this.getChildNodes() == null)) {
                if (this.isLODNode()) {
                    ps.println(String.valueOf(indentString) + "\tlevel [");
                } else if (this.isSwitchNode()) {
                    ps.println(String.valueOf(indentString) + "\tchoice [");
                } else {
                    ps.println(String.valueOf(indentString) + "\tchildren [");
                }
                Node cnode = this.getChildNodes();
                while (cnode != null) {
                    cnode.output(ps, indentLevel + 2);
                    cnode = cnode.next();
                }
                ps.println(String.valueOf(indentString) + "\t]");
            }
            this.outputTail(ps, indentString);
        } else {
            ps.println(String.valueOf(indentString) + "USE " + this.getName());
        }
    }

    public void save(FileOutputStream outputStream) {
        PrintWriter pr = new PrintWriter(outputStream);
        this.output(pr, 0);
        pr.close();
    }

    public void save(String filename) {
        try {
            FileOutputStream outputStream = new FileOutputStream(filename);
            this.save(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            System.out.println("Couldn't open the file (" + filename + ")");
        }
    }

    public void print() {
        PrintWriter pr = new PrintWriter(System.out);
        this.output(pr, 0);
        pr.close();
    }

    private boolean hasString(String str) {
        if (str == null) {
            return false;
        }
        return str.length() > 0;
    }

    private boolean hasOutputXMLField(Field field) {
        MField mfield;
        int fieldSize;
        if (field instanceof SFNode || field instanceof MFNode) {
            return false;
        }
        return !(field instanceof MField) || (fieldSize = (mfield = (MField)field).getSize()) != 0;
    }

    private boolean isOutputXMLFieldInSingleLine() {
        if (this.getType() == NodeType.XML) {
            return true;
        }
        return !this.hasMField();
    }

    public void outputXMLField(PrintWriter ps, Field field, int indentLevel, boolean isSingleLine) {
        String indentString = this.getIndentLevelString(indentLevel + 1);
        String fieldName = field.getName();
        String spaceString = String.valueOf(indentString) + this.getSpaceString(fieldName.length() + 2);
        if (!this.hasOutputXMLField(field)) {
            return;
        }
        if (isSingleLine) {
            ps.print(" ");
        } else {
            ps.println("");
        }
        if (field.isSField()) {
            if (!isSingleLine) {
                ps.print(indentString);
            }
            ps.print(String.valueOf(fieldName) + "=\"" + field.toXMLString() + "\"");
            return;
        }
        if (field.isMField()) {
            MField mfield = (MField)field;
            int fieldSize = mfield.getSize();
            if (fieldSize == 0) {
                ps.print(String.valueOf(indentString) + fieldName + "=\"" + "\"");
                return;
            }
            if (fieldSize == 1) {
                Field eleField = (Field)mfield.get(0);
                String eleString = eleField.toXMLString();
                ps.print(String.valueOf(indentString) + fieldName + "=\"" + eleString + "\"");
                return;
            }
            int n = 0;
            while (n < fieldSize) {
                if (n == 0) {
                    ps.print(String.valueOf(indentString) + fieldName + "=\"\n");
                }
                ps.print(String.valueOf(indentString) + spaceString);
                Field eleField = (Field)mfield.get(n);
                String eleString = eleField.toXMLString();
                ps.print(eleString);
                if (n < fieldSize - 1) {
                    ps.println("");
                } else {
                    ps.print("\"");
                }
                ++n;
            }
            return;
        }
    }

    public void outputXML(PrintWriter ps, int indentLevel) {
        String tagName;
        String indentString = this.getIndentLevelString(indentLevel);
        if (this.isInstanceNode()) {
            String typeName = this.getTypeString();
            String nodeName = this.getName();
            ps.println(String.valueOf(indentString) + "<" + typeName + " USE=\"" + nodeName + "\"/>");
            return;
        }
        if (this.isVRML97Node()) {
            tagName = this.getTypeString();
            String nodeName = this.getName();
            if (this.hasString(nodeName)) {
                ps.print(String.valueOf(indentString) + "<" + tagName + " DEF=\"" + nodeName + "\"");
            } else {
                ps.print(String.valueOf(indentString) + "<" + tagName);
            }
        } else {
            tagName = this.getName();
            ps.print(String.valueOf(indentString) + "<" + tagName);
        }
        boolean isSingleLine = this.isOutputXMLFieldInSingleLine();
        int fieldSize = this.getNFields();
        int exposedfieldSize = this.getNExposedFields();
        int eventInSize = this.getNEventIn();
        int eventOutSize = this.getNEventOut();
        int n = 0;
        while (n < fieldSize) {
            this.outputXMLField(ps, this.getField(n), indentLevel, isSingleLine);
            ++n;
        }
        n = 0;
        while (n < exposedfieldSize) {
            this.outputXMLField(ps, this.getExposedField(n), indentLevel, isSingleLine);
            ++n;
        }
        n = 0;
        while (n < eventInSize) {
            this.outputXMLField(ps, this.getEventIn(n), indentLevel, isSingleLine);
            ++n;
        }
        n = 0;
        while (n < eventOutSize) {
            this.outputXMLField(ps, this.getEventOut(n), indentLevel, isSingleLine);
            ++n;
        }
        if (!this.hasChildNodes()) {
            ps.println("/>");
            return;
        }
        ps.println(">");
        Node cnode = this.getChildNodes();
        while (cnode != null) {
            cnode.outputXML(ps, indentLevel + 1);
            cnode = cnode.next();
        }
        ps.println(String.valueOf(indentString) + "</" + tagName + ">");
    }

    public void saveXML(FileOutputStream outputStream) {
        PrintWriter pr = new PrintWriter(outputStream);
        this.outputXML(pr, 0);
        pr.close();
    }

    public void saveXML(String filename) {
        try {
            FileOutputStream outputStream = new FileOutputStream(filename);
            this.save(outputStream);
            outputStream.close();
        }
        catch (IOException e) {
            System.out.println("Couldn't open the file (" + filename + ")");
        }
    }

    public void printXML() {
        PrintWriter pr = new PrintWriter(System.out);
        this.outputXML(pr, 0);
        pr.close();
    }

    public void getTransformMatrix(SFMatrix mxOut) {
        mxOut.init();
        Node node = this;
        while (node != null) {
            if (node.isTransformNode()) {
                SFMatrix mxTransform = ((TransformNode)node).getSFMatrix();
                mxTransform.add(mxOut);
                mxOut.setValue(mxTransform);
            } else if (node.isBillboardNode()) {
                SFMatrix mxBillboard = ((BillboardNode)node).getSFMatrix();
                mxBillboard.add(mxOut);
                mxOut.setValue(mxBillboard);
            }
            node = node.getParentNode();
        }
    }

    public SFMatrix getTransformMatrix() {
        SFMatrix mx = new SFMatrix();
        this.getTransformMatrix(mx);
        return mx;
    }

    public void getTransformMatrix(float[][] value) {
        SFMatrix mx = new SFMatrix();
        this.getTransformMatrix(mx);
        mx.getValue(value);
    }

    public void setSceneGraph(SceneGraph sceneGraph) {
        this.mSceneGraph = sceneGraph;
        Node node = this.getChildNodes();
        while (node != null) {
            node.setSceneGraph(sceneGraph);
            node = node.next();
        }
    }

    public SceneGraph getSceneGraph() {
        return this.mSceneGraph;
    }

    public void sendEvent(Field eventOutField) {
        SceneGraph sg = this.getSceneGraph();
        if (sg != null) {
            sg.updateRoute(this, eventOutField);
        }
    }

    public void setInitializationFlag(boolean flag) {
        this.mInitializationFlag = flag;
    }

    public boolean isInitialized() {
        return this.mInitializationFlag;
    }

    public void setData(Object data) {
        this.mUserData = data;
    }

    public Object getData() {
        return this.mUserData;
    }

    public boolean isInstanceNode() {
        return this.getReferenceNode() != null;
    }

    public void setReferenceNodeMember(Node node) {
        if (node == null) {
            return;
        }
        this.mName = node.mName;
        this.mFieldList = node.mFieldList;
        this.mPrivateFieldList = node.mPrivateFieldList;
        this.mExposedFieldList = node.mExposedFieldList;
        this.mEventInFieldList = node.mEventInFieldList;
        this.mEventOutFieldList = node.mEventOutFieldList;
        this.mInitializationFlag = node.mInitializationFlag;
        this.mObject = node.mObject;
        this.mThreadObject = node.mThreadObject;
    }

    public void setReferenceNode(Node node) {
        this.mReferenceNode = node;
    }

    public Node getReferenceNode() {
        return this.mReferenceNode;
    }

    public void setAsInstanceNode(Node node) {
        this.setReferenceNode(node);
        this.setReferenceNodeMember(node);
    }

    public Node createInstanceNode() {
        Node instanceNode = null;
        if (this.isAnchorNode()) {
            instanceNode = new AnchorNode();
        } else if (this.isAppearanceNode()) {
            instanceNode = new AppearanceNode();
        } else if (this.isAudioClipNode()) {
            instanceNode = new AudioClipNode();
        } else if (this.isBackgroundNode()) {
            instanceNode = new BackgroundNode();
        } else if (this.isBillboardNode()) {
            instanceNode = new BillboardNode();
        } else if (this.isBoxNode()) {
            instanceNode = new BoxNode();
        } else if (this.isCollisionNode()) {
            instanceNode = new CollisionNode();
        } else if (this.isColorNode()) {
            instanceNode = new ColorNode();
        } else if (this.isColorInterpolatorNode()) {
            instanceNode = new ColorInterpolatorNode();
        } else if (this.isConeNode()) {
            instanceNode = new ConeNode();
        } else if (this.isCoordinateNode()) {
            instanceNode = new CoordinateNode();
        } else if (this.isCoordinateInterpolatorNode()) {
            instanceNode = new CoordinateInterpolatorNode();
        } else if (this.isCylinderNode()) {
            instanceNode = new CylinderNode();
        } else if (this.isCylinderSensorNode()) {
            instanceNode = new CylinderSensorNode();
        } else if (this.isDirectionalLightNode()) {
            instanceNode = new DirectionalLightNode();
        } else if (this.isElevationGridNode()) {
            instanceNode = new ElevationGridNode();
        } else if (this.isExtrusionNode()) {
            instanceNode = new ExtrusionNode();
        } else if (this.isFogNode()) {
            instanceNode = new FogNode();
        } else if (this.isFontStyleNode()) {
            instanceNode = new FontStyleNode();
        } else if (this.isGroupNode()) {
            instanceNode = new GroupNode();
        } else if (this.isImageTextureNode()) {
            instanceNode = new ImageTextureNode();
        } else if (this.isIndexedFaceSetNode()) {
            instanceNode = new IndexedFaceSetNode();
        } else if (this.isIndexedLineSetNode()) {
            instanceNode = new IndexedLineSetNode();
        } else if (this.isInlineNode()) {
            instanceNode = new InlineNode();
        } else if (this.isLODNode()) {
            instanceNode = new LODNode();
        } else if (this.isMaterialNode()) {
            instanceNode = new MaterialNode();
        } else if (this.isMovieTextureNode()) {
            instanceNode = new MovieTextureNode();
        } else if (this.isNavigationInfoNode()) {
            instanceNode = new NavigationInfoNode();
        } else if (this.isNormalNode()) {
            instanceNode = new NormalNode();
        } else if (this.isNormalInterpolatorNode()) {
            instanceNode = new NormalInterpolatorNode();
        } else if (this.isOrientationInterpolatorNode()) {
            instanceNode = new OrientationInterpolatorNode();
        } else if (this.isPixelTextureNode()) {
            instanceNode = new PixelTextureNode();
        } else if (this.isPlaneSensorNode()) {
            instanceNode = new PlaneSensorNode();
        } else if (this.isPointLightNode()) {
            instanceNode = new PointLightNode();
        } else if (this.isPointSetNode()) {
            instanceNode = new PointSetNode();
        } else if (this.isPositionInterpolatorNode()) {
            instanceNode = new PositionInterpolatorNode();
        } else if (this.isProximitySensorNode()) {
            instanceNode = new ProximitySensorNode();
        } else if (this.isProxyNode()) {
            instanceNode = new ProxyNode();
        } else if (this.isScalarInterpolatorNode()) {
            instanceNode = new ScalarInterpolatorNode();
        } else if (this.isScriptNode()) {
            instanceNode = new ScriptNode();
        } else if (this.isShapeNode()) {
            instanceNode = new ShapeNode();
        } else if (this.isSoundNode()) {
            instanceNode = new SoundNode();
        } else if (this.isSphereNode()) {
            instanceNode = new SphereNode();
        } else if (this.isSphereSensorNode()) {
            instanceNode = new SphereSensorNode();
        } else if (this.isSpotLightNode()) {
            instanceNode = new SpotLightNode();
        } else if (this.isSwitchNode()) {
            instanceNode = new SwitchNode();
        } else if (this.isTextNode()) {
            instanceNode = new TextNode();
        } else if (this.isTextureCoordinateNode()) {
            instanceNode = new TextureCoordinateNode();
        } else if (this.isTextureTransformNode()) {
            instanceNode = new TextureTransformNode();
        } else if (this.isTimeSensorNode()) {
            instanceNode = new TimeSensorNode();
        } else if (this.isTouchSensorNode()) {
            instanceNode = new TouchSensorNode();
        } else if (this.isTransformNode()) {
            instanceNode = new TransformNode();
        } else if (this.isViewpointNode()) {
            instanceNode = new ViewpointNode();
        } else if (this.isVisibilitySensorNode()) {
            instanceNode = new VisibilitySensorNode();
        } else if (this.isWorldInfoNode()) {
            instanceNode = new WorldInfoNode();
        }
        if (instanceNode != null) {
            instanceNode.setAsInstanceNode(this);
            Node cnode = this.getChildNodes();
            while (cnode != null) {
                Node childInstanceNode = cnode.createInstanceNode();
                instanceNode.addChildNode(childInstanceNode);
                cnode = cnode.next();
            }
        } else {
            System.out.println("Node::createInstanceNode : this = " + this + ", instanceNode = null");
        }
        return instanceNode;
    }

    public void setObject(NodeObject object) {
        this.mObject = object;
    }

    public NodeObject getObject() {
        return this.mObject;
    }

    public boolean hasObject() {
        return this.mObject != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean initializeObject() {
        if (this.hasObject()) {
            boolean ret;
            NodeObject nodeObject = this.mObject;
            synchronized (nodeObject) {
                ret = this.mObject.initialize(this);
            }
            return ret;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uninitializeObject() {
        if (this.hasObject()) {
            boolean ret;
            NodeObject nodeObject = this.mObject;
            synchronized (nodeObject) {
                ret = this.mObject.uninitialize(this);
            }
            return ret;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateObject() {
        if (this.hasObject()) {
            boolean ret;
            NodeObject nodeObject = this.mObject;
            synchronized (nodeObject) {
                ret = this.mObject.update(this);
            }
            return ret;
        }
        return false;
    }

    public boolean addObject() {
        Debug.message("Node::addObject = " + this + ", " + this.mObject);
        if (this.isRootNode()) {
            Debug.warning("\tThis node is a root node !!");
            return false;
        }
        if (this.hasObject()) {
            return this.mObject.add(this);
        }
        return false;
    }

    public boolean removeObject() {
        Debug.message("Node::addObject = " + this + ", " + this.mObject);
        if (this.isRootNode()) {
            Debug.warning("\tThis node is a root node !!");
            return false;
        }
        if (this.hasObject()) {
            return this.mObject.remove(this);
        }
        return false;
    }

    public void setRunnable(boolean value) {
        this.mRunnable = value;
    }

    public boolean isRunnable() {
        if (this.isInstanceNode()) {
            return false;
        }
        return this.mRunnable;
    }

    public void setRunnableType(int type) {
        this.mRunnableType = type;
    }

    public int getRunnableType() {
        return this.mRunnableType;
    }

    public void setRunnableIntervalTime(int time) {
        this.mRunnableIntervalTime = time;
    }

    public int getRunnableIntervalTime() {
        return this.mRunnableIntervalTime;
    }

    public void setThreadObject(Thread obj) {
        this.mThreadObject = obj;
    }

    public Thread getThreadObject() {
        return this.mThreadObject;
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        while (thisThread == this.getThreadObject()) {
            this.update();
            this.updateObject();
            Thread threadObject = this.getThreadObject();
            if (threadObject == null) continue;
            try {
                Thread.sleep(this.getRunnableIntervalTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void start() {
        Thread threadObject = this.getThreadObject();
        if (threadObject == null) {
            threadObject = new Thread(this);
            this.setThreadObject(threadObject);
            threadObject.start();
        }
    }

    public void stop() {
        Thread threadObject = this.getThreadObject();
        if (threadObject != null) {
            this.setThreadObject(null);
        }
    }

    protected void setFieldValues(Node node) {
        Field thisField;
        Field nodeField;
        int nNodeFields = node.getNFields();
        int n = 0;
        while (n < nNodeFields) {
            nodeField = node.getField(n);
            thisField = this.getField(nodeField.getName());
            if (thisField != null) {
                thisField.setValue(nodeField);
            }
            ++n;
        }
        int nNodePrivateFields = node.getNPrivateFields();
        int n2 = 0;
        while (n2 < nNodePrivateFields) {
            nodeField = node.getPrivateField(n2);
            thisField = this.getPrivateField(nodeField.getName());
            if (thisField != null) {
                thisField.setValue(nodeField);
            }
            ++n2;
        }
        int nNodeExposedFields = node.getNExposedFields();
        int n3 = 0;
        while (n3 < nNodeExposedFields) {
            nodeField = node.getExposedField(n3);
            thisField = this.getExposedField(nodeField.getName());
            if (thisField != null) {
                thisField.setValue(nodeField);
            }
            ++n3;
        }
        int nNodeEventIn = node.getNEventIn();
        int n4 = 0;
        while (n4 < nNodeEventIn) {
            nodeField = node.getEventIn(n4);
            thisField = this.getEventIn(nodeField.getName());
            if (thisField != null) {
                thisField.setValue(nodeField);
            }
            ++n4;
        }
        int nNodeEventOut = node.getNEventOut();
        int n5 = 0;
        while (n5 < nNodeEventOut) {
            nodeField = node.getEventOut(n5);
            thisField = this.getEventOut(nodeField.getName());
            if (thisField != null) {
                thisField.setValue(nodeField);
            }
            ++n5;
        }
    }

    private Field createCopyField(Field field) {
        FieldType fieldType = field.getType();
        if (fieldType.equals(FieldType.SFBOOL)) {
            return new SFBool((SFBool)field);
        }
        if (fieldType.equals(FieldType.SFCOLOR)) {
            return new SFColor((SFColor)field);
        }
        if (fieldType.equals(FieldType.SFFLOAT)) {
            return new SFFloat((SFFloat)field);
        }
        if (fieldType.equals(FieldType.SFINT32)) {
            return new SFInt32((SFInt32)field);
        }
        if (fieldType.equals(FieldType.SFROTATION)) {
            return new SFRotation((SFRotation)field);
        }
        if (fieldType.equals(FieldType.SFSTRING)) {
            return new SFString((SFString)field);
        }
        if (fieldType.equals(FieldType.SFTIME)) {
            return new SFTime((SFTime)field);
        }
        if (fieldType.equals(FieldType.SFVEC2F)) {
            return new SFVec2f((SFVec2f)field);
        }
        if (fieldType.equals(FieldType.SFVEC3F)) {
            return new SFVec3f((SFVec3f)field);
        }
        if (fieldType.equals(FieldType.SFNODE)) {
            return new SFNode((SFNode)field);
        }
        if (fieldType.equals(FieldType.MFCOLOR)) {
            return new MFColor((MFColor)field);
        }
        if (fieldType.equals(FieldType.MFFLOAT)) {
            return new MFFloat((MFFloat)field);
        }
        if (fieldType.equals(FieldType.MFINT32)) {
            return new MFInt32((MFInt32)field);
        }
        if (fieldType.equals(FieldType.MFROTATION)) {
            return new MFRotation((MFRotation)field);
        }
        if (fieldType.equals(FieldType.MFSTRING)) {
            return new MFString((MFString)field);
        }
        if (fieldType.equals(FieldType.MFTIME)) {
            return new MFTime((MFTime)field);
        }
        if (fieldType.equals(FieldType.MFVEC2F)) {
            return new MFVec2f((MFVec2f)field);
        }
        if (fieldType.equals(FieldType.MFVEC3F)) {
            return new MFVec3f((MFVec3f)field);
        }
        if (fieldType.equals(FieldType.MFNODE)) {
            return new MFNode((MFNode)field);
        }
        Debug.warning("Node.createCopyField");
        Debug.warning("\tCouldn't create a copy field of " + field);
        return null;
    }

    public Field createFieldFromString(String fieldType) {
        if (fieldType.compareTo("SFBool") == 0) {
            return new SFBool(true);
        }
        if (fieldType.compareTo("SFColor") == 0) {
            return new SFColor(0.0f, 0.0f, 0.0f);
        }
        if (fieldType.compareTo("SFFloat") == 0) {
            return new SFFloat(0.0f);
        }
        if (fieldType.compareTo("SFInt32") == 0) {
            return new SFInt32(0);
        }
        if (fieldType.compareTo("SFRotation") == 0) {
            return new SFRotation(0.0f, 0.0f, 1.0f, 0.0f);
        }
        if (fieldType.compareTo("SFString") == 0) {
            return new SFString();
        }
        if (fieldType.compareTo("SFTime") == 0) {
            return new SFTime(0.0);
        }
        if (fieldType.compareTo("SFVec2f") == 0) {
            return new SFVec2f(0.0f, 0.0f);
        }
        if (fieldType.compareTo("SFVec3f") == 0) {
            return new SFVec3f(0.0f, 0.0f, 0.0f);
        }
        if (fieldType.compareTo("MFColor") == 0) {
            return new MFColor();
        }
        if (fieldType.compareTo("MFFloat") == 0) {
            return new MFFloat();
        }
        if (fieldType.compareTo("MFInt32") == 0) {
            return new MFInt32();
        }
        if (fieldType.compareTo("MFRotation") == 0) {
            return new MFRotation();
        }
        if (fieldType.compareTo("MFString") == 0) {
            return new MFString();
        }
        if (fieldType.compareTo("MFTime") == 0) {
            return new MFTime();
        }
        if (fieldType.compareTo("MFVec2f") == 0) {
            return new MFVec2f();
        }
        if (fieldType.compareTo("MFVec3f") == 0) {
            return new MFVec3f();
        }
        return null;
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String type = this.getTypeString();
        String name = this.getName();
        if (name != null) {
            if (name.length() > 0) {
                pw.println("DEF " + name + " " + this.getType());
            } else {
                pw.println(type);
            }
        } else {
            pw.println(type);
        }
        pw.println(" {");
        this.outputContext(pw, "");
        pw.println("}");
        return sw.toString();
    }
}

