/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import org.cybergarage.x3d.field.SFTime;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.SensorNode;

public abstract class EnvironmentalSensorNode
extends SensorNode {
    private static final String centerFieldName = "center";
    private static final String sizeFieldName = "size";
    private static final String enterTimeEventOutName = "enterTime";
    private static final String exitTimeEventOutName = "exitTime";
    private SFVec3f centerField = new SFVec3f(0.0f, 0.0f, 0.0f);
    private SFVec3f sizeField;
    private SFTime enterTimeField;
    private SFTime exitTimeField;
    private boolean mInRegion = false;

    public EnvironmentalSensorNode() {
        this.addExposedField(centerFieldName, this.centerField);
        this.sizeField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.addExposedField(sizeFieldName, this.sizeField);
        this.enterTimeField = new SFTime(0.0);
        this.addEventOut(enterTimeEventOutName, this.enterTimeField);
        this.exitTimeField = new SFTime(0.0);
        this.addEventOut(exitTimeEventOutName, this.exitTimeField);
    }

    public SFVec3f getCenterField() {
        if (!this.isInstanceNode()) {
            return this.centerField;
        }
        return (SFVec3f)this.getExposedField(centerFieldName);
    }

    public void setCenter(float[] value) {
        this.getCenterField().setValue(value);
    }

    public void setCenter(float x, float y, float z) {
        this.getCenterField().setValue(x, y, z);
    }

    public void setCenter(String value) {
        this.getCenterField().setValue(value);
    }

    public void getCenter(float[] value) {
        this.getCenterField().getValue();
    }

    public SFVec3f getSizeField() {
        if (!this.isInstanceNode()) {
            return this.sizeField;
        }
        return (SFVec3f)this.getExposedField(sizeFieldName);
    }

    public void setSize(float[] value) {
        this.getSizeField().setValue(value);
    }

    public void setSize(float x, float y, float z) {
        this.getSizeField().setValue(x, y, z);
    }

    public void setSize(String value) {
        this.getSizeField().setValue(value);
    }

    public void getSize(float[] value) {
        this.getSizeField().getValue();
    }

    public SFTime getEnterTimeField() {
        if (!this.isInstanceNode()) {
            return this.enterTimeField;
        }
        return (SFTime)this.getEventOut(enterTimeEventOutName);
    }

    public void setEnterTime(double value) {
        this.getEnterTimeField().setValue(value);
    }

    public void setEnterTime(String value) {
        this.getEnterTimeField().setValue(value);
    }

    public double getEnterTime() {
        return this.getEnterTimeField().getValue();
    }

    public SFTime getExitTimeField() {
        if (!this.isInstanceNode()) {
            return this.exitTimeField;
        }
        return (SFTime)this.getEventOut(exitTimeEventOutName);
    }

    public void setExitTime(double value) {
        this.getExitTimeField().setValue(value);
    }

    public void setExitTime(String value) {
        this.getExitTimeField().setValue(value);
    }

    public double getExitTime() {
        return this.getExitTimeField().getValue();
    }

    public void setInRegion(boolean value) {
        this.mInRegion = value;
    }

    public boolean inRegion() {
        return this.mInRegion;
    }

    public boolean isRegion(float[] vpos, float[] center, float[] size) {
        int n = 0;
        while (n < 3) {
            if (vpos[n] < center[n] - size[n] / 2.0f) {
                return false;
            }
            if (center[n] + size[n] / 2.0f < vpos[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }
}

