/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import java.io.PrintWriter;
import org.cybergarage.x3d.NodeType;
import org.cybergarage.x3d.field.SFBool;
import org.cybergarage.x3d.field.SFFloat;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;

public class CylinderNode
extends Geometry3DNode {
    private static final String radiusFieldName = "radius";
    private static final String heightFieldName = "height";
    private static final String topFieldName = "top";
    private static final String sideFieldName = "side";
    private static final String bottomFieldName = "bottom";
    private SFFloat radiusField;
    private SFFloat heightField;
    private SFBool topField;
    private SFBool sideField;
    private SFBool bottomField;

    public CylinderNode() {
        this.setHeaderFlag(false);
        this.setType(NodeType.CYLINDER);
        this.radiusField = new SFFloat(1.0f);
        this.addExposedField(radiusFieldName, this.radiusField);
        this.heightField = new SFFloat(2.0f);
        this.addExposedField(heightFieldName, this.heightField);
        this.topField = new SFBool(true);
        this.addExposedField(topFieldName, this.topField);
        this.sideField = new SFBool(true);
        this.addExposedField(sideFieldName, this.sideField);
        this.bottomField = new SFBool(true);
        this.addExposedField(bottomFieldName, this.bottomField);
    }

    public CylinderNode(CylinderNode node) {
        this();
        this.setFieldValues(node);
    }

    public SFFloat getRadiusField() {
        if (!this.isInstanceNode()) {
            return this.radiusField;
        }
        return (SFFloat)this.getExposedField(radiusFieldName);
    }

    public void setRadius(float value) {
        this.getRadiusField().setValue(value);
    }

    public void setRadius(String value) {
        this.getRadiusField().setValue(value);
    }

    public float getRadius() {
        return this.getRadiusField().getValue();
    }

    public SFFloat getHeightField() {
        if (!this.isInstanceNode()) {
            return this.heightField;
        }
        return (SFFloat)this.getExposedField(heightFieldName);
    }

    public void setHeight(float value) {
        this.getHeightField().setValue(value);
    }

    public void setHeight(String value) {
        this.getHeightField().setValue(value);
    }

    public float getHeight() {
        return this.getHeightField().getValue();
    }

    public SFBool getTopField() {
        if (!this.isInstanceNode()) {
            return this.topField;
        }
        return (SFBool)this.getExposedField(topFieldName);
    }

    public void setTop(boolean value) {
        this.getTopField().setValue(value);
    }

    public void setTop(String value) {
        this.getTopField().setValue(value);
    }

    public boolean getTop() {
        return this.getTopField().getValue();
    }

    public SFBool getSideField() {
        if (!this.isInstanceNode()) {
            return this.sideField;
        }
        return (SFBool)this.getExposedField(sideFieldName);
    }

    public void setSide(boolean value) {
        this.getSideField().setValue(value);
    }

    public void setSide(String value) {
        this.getSideField().setValue(value);
    }

    public boolean getSide() {
        return this.getSideField().getValue();
    }

    public SFBool getBottomField() {
        if (!this.isInstanceNode()) {
            return this.bottomField;
        }
        return (SFBool)this.getExposedField(bottomFieldName);
    }

    public void setBottom(boolean value) {
        this.getBottomField().setValue(value);
    }

    public void setBottom(String value) {
        this.getBottomField().setValue(value);
    }

    public boolean getBottom() {
        return this.getBottomField().getValue();
    }

    @Override
    public boolean isChildNodeType(Node node) {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.updateBoundingBox();
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void update() {
    }

    @Override
    public void updateBoundingBox() {
        this.setBoundingBoxCenter(0.0f, 0.0f, 0.0f);
        this.setBoundingBoxSize(this.getRadius(), this.getHeight() / 2.0f, this.getRadius());
    }

    @Override
    public void outputContext(PrintWriter printStream, String indentString) {
        SFBool top = this.getTopField();
        SFBool side = this.getSideField();
        SFBool bottom = this.getBottomField();
        printStream.println(String.valueOf(indentString) + "\t" + "radius " + this.getRadius());
        printStream.println(String.valueOf(indentString) + "\t" + "height " + this.getHeight());
        printStream.println(String.valueOf(indentString) + "\t" + "side " + side);
        printStream.println(String.valueOf(indentString) + "\t" + "top " + top);
        printStream.println(String.valueOf(indentString) + "\t" + "bottom " + bottom);
    }
}

