/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.node.BoundedObject;
import org.cybergarage.x3d.node.Geometry3DNode;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.BoundingBox;

public abstract class BoundedNode
extends Node
implements BoundedObject {
    private static final String bboxCenterFieldName = "bboxCenter";
    private static final String bboxSizeFieldName = "bboxSize";
    private SFVec3f bboxCenterField;
    private SFVec3f bboxSizeField;

    public BoundedNode(boolean bAddBBoxField) {
        this.setHeaderFlag(false);
        this.bboxCenterField = new SFVec3f(0.0f, 0.0f, 0.0f);
        this.bboxCenterField.setName(bboxCenterFieldName);
        this.addField(this.bboxCenterField);
        this.bboxSizeField = new SFVec3f(-1.0f, -1.0f, -1.0f);
        this.bboxSizeField.setName(bboxSizeFieldName);
        this.addField(this.bboxSizeField);
    }

    public BoundedNode() {
    }

    @Override
    public SFVec3f getBoundingBoxSizeField() {
        if (!this.isInstanceNode()) {
            return this.bboxSizeField;
        }
        return (SFVec3f)this.getField(bboxSizeFieldName);
    }

    @Override
    public void setBoundingBoxSize(float[] value) {
        this.getBoundingBoxSizeField().setValue(value);
    }

    @Override
    public void setBoundingBoxSize(float x, float y, float z) {
        this.getBoundingBoxSizeField().setValue(x, y, z);
    }

    @Override
    public void setBoundingBoxSize(String value) {
        this.getBoundingBoxSizeField().setValue(value);
    }

    @Override
    public void getBoundingBoxSize(float[] value) {
        this.getBoundingBoxSizeField().getValue(value);
    }

    @Override
    public float[] getBoundingBoxSize() {
        float[] size = new float[3];
        this.getBoundingBoxSize(size);
        return size;
    }

    @Override
    public SFVec3f getBoundingBoxCenterField() {
        if (!this.isInstanceNode()) {
            return this.bboxCenterField;
        }
        return (SFVec3f)this.getField(bboxCenterFieldName);
    }

    @Override
    public void setBoundingBoxCenter(float[] value) {
        this.getBoundingBoxCenterField().setValue(value);
    }

    @Override
    public void setBoundingBoxCenter(float x, float y, float z) {
        this.getBoundingBoxCenterField().setValue(x, y, z);
    }

    @Override
    public void setBoundingBoxCenter(String value) {
        this.getBoundingBoxCenterField().setValue(value);
    }

    @Override
    public void getBoundingBoxCenter(float[] value) {
        this.getBoundingBoxCenterField().getValue(value);
    }

    @Override
    public float[] getBoundingBoxCenter() {
        float[] center = new float[3];
        this.getBoundingBoxCenter(center);
        return center;
    }

    public static final void updateBoundingBox(Node node, BoundingBox bbox) {
        if (node.isGeometry3DNode()) {
            Geometry3DNode gnode = (Geometry3DNode)node;
            gnode.updateBoundingBox();
            float[] bboxCenter = new float[3];
            float[] bboxSize = new float[3];
            float[] point = new float[3];
            gnode.getBoundingBoxCenter(bboxCenter);
            gnode.getBoundingBoxSize(bboxSize);
            if (bboxSize[0] >= 0.0f && bboxSize[1] >= 0.0f && bboxSize[2] >= 0.0f) {
                SFMatrix mx = gnode.getTransformMatrix();
                int n = 0;
                while (n < 8) {
                    point[0] = n < 4 ? bboxCenter[0] - bboxSize[0] : bboxCenter[0] + bboxSize[0];
                    point[1] = n % 2 != 0 ? bboxCenter[1] - bboxSize[1] : bboxCenter[1] + bboxSize[1];
                    point[2] = n % 4 < 2 ? bboxCenter[2] - bboxSize[2] : bboxCenter[2] + bboxSize[2];
                    mx.multi(point);
                    bbox.addPoint(point);
                    ++n;
                }
            }
        }
        Node cnode = node.getChildNodes();
        while (cnode != null) {
            BoundedNode.updateBoundingBox(cnode, bbox);
            cnode = cnode.next();
        }
    }

    @Override
    public void updateBoundingBox() {
        BoundingBox bbox = new BoundingBox();
        Node node = this.getChildNodes();
        while (node != null) {
            BoundedNode.updateBoundingBox(node, bbox);
            node = node.next();
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }
}

