/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.node;

import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFVec2f;
import org.cybergarage.x3d.node.Bounded2DObject;
import org.cybergarage.x3d.node.Node;
import org.cybergarage.x3d.util.BoundingBox2D;

public abstract class Bounded2DNode
extends Node
implements Bounded2DObject {
    private static final String bboxCenterFieldName = "bboxCenter";
    private static final String bboxSizeFieldName = "bboxSize";
    private SFVec2f bboxCenterField = new SFVec2f(0.0f, 0.0f);
    private SFVec2f bboxSizeField;

    public Bounded2DNode() {
        this.bboxCenterField.setName(bboxCenterFieldName);
        this.addField(this.bboxCenterField);
        this.bboxSizeField = new SFVec2f(-1.0f, -1.0f);
        this.bboxSizeField.setName(bboxSizeFieldName);
        this.addField(this.bboxSizeField);
    }

    @Override
    public SFVec2f getBoundingBoxSizeField() {
        if (!this.isInstanceNode()) {
            return this.bboxSizeField;
        }
        return (SFVec2f)this.getField(bboxSizeFieldName);
    }

    @Override
    public void setBoundingBoxSize(float[] value) {
        this.getBoundingBoxSizeField().setValue(value);
    }

    @Override
    public void setBoundingBoxSize(float x, float y) {
        this.getBoundingBoxSizeField().setValue(x, y);
    }

    @Override
    public void setBoundingBoxSize(String value) {
        this.getBoundingBoxSizeField().setValue(value);
    }

    @Override
    public void getBoundingBoxSize(float[] value) {
        this.getBoundingBoxSizeField().getValue(value);
    }

    @Override
    public float[] getBoundingBoxSize() {
        float[] size = new float[2];
        this.getBoundingBoxSize(size);
        return size;
    }

    @Override
    public SFVec2f getBoundingBoxCenterField() {
        if (!this.isInstanceNode()) {
            return this.bboxCenterField;
        }
        return (SFVec2f)this.getField(bboxCenterFieldName);
    }

    @Override
    public void setBoundingBoxCenter(float[] value) {
        this.getBoundingBoxCenterField().setValue(value);
    }

    @Override
    public void setBoundingBoxCenter(float x, float y) {
        this.getBoundingBoxCenterField().setValue(x, y);
    }

    @Override
    public void setBoundingBoxCenter(String value) {
        this.getBoundingBoxCenterField().setValue(value);
    }

    @Override
    public void getBoundingBoxCenter(float[] value) {
        this.getBoundingBoxCenterField().getValue(value);
    }

    @Override
    public float[] getBoundingBoxCenter() {
        float[] center = new float[2];
        this.getBoundingBoxCenter(center);
        return center;
    }

    public static final void updateBoundingBox(Node node, BoundingBox2D bbox) {
        if (node instanceof Bounded2DNode) {
            Bounded2DNode b2dNode = (Bounded2DNode)node;
            b2dNode.updateBoundingBox();
            float[] bboxCenter = new float[2];
            float[] bboxSize = new float[2];
            float[] point = new float[2];
            b2dNode.getBoundingBoxCenter(bboxCenter);
            b2dNode.getBoundingBoxSize(bboxSize);
            if (bboxSize[0] >= 0.0f && bboxSize[1] >= 0.0f) {
                SFMatrix mx = b2dNode.getTransformMatrix();
                int n = 0;
                while (n < 4) {
                    point[0] = n < 4 ? bboxCenter[0] - bboxSize[0] : bboxCenter[0] + bboxSize[0];
                    point[1] = n % 2 != 0 ? bboxCenter[1] - bboxSize[1] : bboxCenter[1] + bboxSize[1];
                    mx.multi(point);
                    bbox.addPoint(point);
                    ++n;
                }
            }
        }
        Node cnode = node.getChildNodes();
        while (cnode != null) {
            Bounded2DNode.updateBoundingBox(cnode, bbox);
            cnode = cnode.next();
        }
    }

    @Override
    public void updateBoundingBox() {
        BoundingBox2D bbox = new BoundingBox2D();
        Node node = this.getChildNodes();
        while (node != null) {
            Bounded2DNode.updateBoundingBox(node, bbox);
            node = node.next();
        }
        this.setBoundingBoxCenter(bbox.getCenter());
        this.setBoundingBoxSize(bbox.getSize());
    }
}

