/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.Vec3fValue;

public class SFVec3f
extends Field {
    private Vec3fValue mVector = new Vec3fValue();

    public SFVec3f() {
        this.setType(FieldType.SFVEC3F);
        this.setValue(0.0f, 0.0f, 0.0f);
    }

    public SFVec3f(SFVec3f vector) {
        this();
        this.setValue(vector);
    }

    public SFVec3f(float x, float y, float z) {
        this();
        this.setValue(x, y, z);
    }

    public SFVec3f(float[] value) {
        this();
        this.setValue(value);
    }

    public SFVec3f(String value) {
        this();
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        Vec3fValue vec3fValue = this.mVector;
        synchronized (vec3fValue) {
            this.mVector = (Vec3fValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        Vec3fValue object;
        Vec3fValue vec3fValue = this.mVector;
        synchronized (vec3fValue) {
            object = this.mVector;
        }
        return object;
    }

    public void getValue(float[] value) {
        this.mVector.getValue(value);
    }

    public float[] getValue() {
        return this.mVector.getValue();
    }

    public float getX() {
        return this.mVector.getX();
    }

    public float getY() {
        return this.mVector.getY();
    }

    public float getZ() {
        return this.mVector.getZ();
    }

    @Override
    public int getValueCount() {
        return 3;
    }

    public void setValue(float x, float y, float z, boolean doShare) {
        this.mVector.setValue(x, y, z);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(float x, float y, float z) {
        this.setValue(x, y, z, true);
    }

    public void setValue(float[] value) {
        if (value.length < 3) {
            return;
        }
        this.setValue(value[0], value[1], value[2]);
    }

    public void setValue(SFVec3f vector, boolean doShare) {
        this.setValue(vector.getX(), vector.getY(), vector.getZ(), doShare);
    }

    public void setValue(SFVec3f vector) {
        this.setValue(vector, true);
    }

    @Override
    public void setValue(String string) {
        this.mVector.setValue(string);
    }

    @Override
    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFVec3f) {
            this.setValue((SFVec3f)field, doShare);
        }
    }

    @Override
    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void setX(float x) {
        this.setValue(x, this.getY(), this.getZ());
    }

    public void setY(float y) {
        this.setValue(this.getX(), y, this.getZ());
    }

    public void setZ(float z) {
        this.setValue(this.getX(), this.getY(), z);
    }

    public void add(float x, float y, float z) {
        this.mVector.add(x, y, z);
    }

    public void add(float[] value) {
        this.mVector.add(value);
    }

    public void add(SFVec3f value) {
        this.add(value.getValue());
    }

    public void sub(float x, float y, float z) {
        this.mVector.sub(x, y, z);
    }

    public void sub(float[] value) {
        this.mVector.sub(value);
    }

    public void sub(SFVec3f value) {
        this.sub(value.getValue());
    }

    public void scale(float scale) {
        this.mVector.scale(scale);
    }

    public void invert() {
        this.mVector.invert();
    }

    public float getScalar() {
        return this.mVector.getScalar();
    }

    public void normalize() {
        this.mVector.normalize();
    }

    @Override
    public String toString() {
        return String.valueOf(this.getX()) + " " + this.getY() + " " + this.getZ();
    }
}

