/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.RotationValue;
import org.cybergarage.x3d.field.SFMatrix;
import org.cybergarage.x3d.field.SFVec3f;
import org.cybergarage.x3d.field.StringValue;

public class SFRotation
extends Field {
    private RotationValue mValue = new RotationValue();

    public SFRotation() {
        this.setType(FieldType.SFROTATION);
        this.setValue(0.0f, 0.0f, 1.0f, 0.0f);
    }

    public SFRotation(SFRotation rotation) {
        this.setType(FieldType.SFROTATION);
        this.setValue(rotation);
    }

    public SFRotation(float x, float y, float z, float rot) {
        this.setType(FieldType.SFROTATION);
        this.setValue(x, y, z, rot);
    }

    public SFRotation(double x, double y, double z, double rot) {
        this.setType(FieldType.SFROTATION);
        this.setValue(x, y, z, rot);
    }

    public SFRotation(float[] value) {
        this.setType(FieldType.SFROTATION);
        this.setValue(value);
    }

    public SFRotation(double[] value) {
        this.setType(FieldType.SFROTATION);
        this.setValue(value);
    }

    public SFRotation(float[] vector, float angle) {
        this.setType(FieldType.SFROTATION);
        this.setValue(vector, angle);
    }

    public SFRotation(double[] vector, double angle) {
        this.setType(FieldType.SFROTATION);
        this.setValue(vector[0], vector[1], vector[2], angle);
    }

    public SFRotation(String value) {
        this.setType(FieldType.SFROTATION);
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        RotationValue rotationValue = this.mValue;
        synchronized (rotationValue) {
            this.mValue = (RotationValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        RotationValue object;
        RotationValue rotationValue = this.mValue;
        synchronized (rotationValue) {
            object = this.mValue;
        }
        return object;
    }

    public void setValue(float x, float y, float z, float rot, boolean doShare) {
        this.mValue.setValue(x, y, z, rot);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(float x, float y, float z, float rot) {
        this.setValue(x, y, z, rot, true);
    }

    public void setValue(double x, double y, double z, double rot) {
        this.setValue((float)x, (float)y, (float)z, (float)rot);
    }

    public void setValue(double[] value) {
        if (value.length != 4) {
            return;
        }
        this.setValue(value[0], value[1], value[2], value[3]);
    }

    public void setValue(float[] value) {
        if (value.length != 4) {
            return;
        }
        this.setValue(value[0], value[1], value[2], value[3]);
    }

    public void setValue(float[] vector, float angle) {
        this.setValue(vector[0], vector[1], vector[2], angle);
    }

    public void setValue(double[] vector, float angle) {
        this.setValue(vector[0], vector[1], vector[2], (double)angle);
    }

    public void setValue(SFRotation rotation, boolean doShare) {
        this.setValue(rotation.getX(), rotation.getY(), rotation.getZ(), rotation.getAngle(), doShare);
    }

    public void setValue(SFRotation rotation) {
        this.setValue(rotation, true);
    }

    @Override
    public void setValue(String string) {
        StringValue value = new StringValue(string);
        String[] token = value.getTokens();
        if (token != null && token.length == 4) {
            try {
                Float x = new Float(token[0]);
                Float y = new Float(token[1]);
                Float z = new Float(token[2]);
                Float a = new Float(token[3]);
                this.setValue(x.floatValue(), y.floatValue(), z.floatValue(), a.floatValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Override
    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFRotation) {
            this.setValue((SFRotation)field, doShare);
        }
    }

    @Override
    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void getValue(float[] value) {
        this.mValue.getValue(value);
    }

    public float[] getValue() {
        float[] value = new float[4];
        this.getValue(value);
        return value;
    }

    public void getVector(float[] vector) {
        this.mValue.getVector(vector);
    }

    public float[] getVector() {
        float[] vector = new float[3];
        this.getVector(vector);
        return vector;
    }

    public float getX() {
        return this.mValue.getX();
    }

    public float getY() {
        return this.mValue.getY();
    }

    public float getZ() {
        return this.mValue.getZ();
    }

    public float getAngle() {
        return this.mValue.getAngle();
    }

    @Override
    public int getValueCount() {
        return 4;
    }

    public void add(SFRotation rot) {
        SFMatrix m1 = new SFMatrix();
        this.getSFMatrix(m1);
        SFMatrix m2 = new SFMatrix();
        rot.getSFMatrix(m2);
        m1.add(m2);
        SFRotation newRotation = new SFRotation();
        m1.getSFRotation(newRotation);
        this.setValue(newRotation);
    }

    public void add(float[] rotationValue) {
        SFRotation rotation = new SFRotation(rotationValue);
        this.add(rotation);
    }

    public void add(float x, float y, float z, float rot) {
        SFRotation rotation = new SFRotation(x, y, z, rot);
        this.add(rotation);
    }

    public void multi(float[] vector) {
        SFMatrix m = new SFMatrix();
        this.getSFMatrix(m);
        m.multi(vector);
    }

    public void multi(double[] vector) {
        SFMatrix m = new SFMatrix();
        this.getSFMatrix(m);
        m.multi(vector);
    }

    public void multi(SFVec3f vector) {
        SFMatrix m = new SFMatrix();
        this.getSFMatrix(m);
        m.multi(vector);
    }

    public void getSFMatrix(SFMatrix matrix) {
        float[] vector = this.getVector();
        float rotation = this.getAngle();
        double k = 1.0 - Math.cos(rotation);
        double s = Math.sin(rotation);
        double c = Math.cos(rotation);
        double ax = vector[0];
        double ay = vector[1];
        double az = vector[2];
        double ax2 = ax * ax;
        double ay2 = ay * ay;
        double az2 = az * az;
        double[][] ma = new double[4][4];
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                ma[i][j] = 0.0;
                ++j;
            }
            ++i;
        }
        ma[0][0] = k * ax2 + c;
        ma[0][1] = k * ax * ay + s * az;
        ma[0][2] = k * ax * az - s * ay;
        ma[1][0] = k * ax * ay - s * az;
        ma[1][1] = k * ay2 + c;
        ma[1][2] = k * ay * az + s * ax;
        ma[2][0] = k * ax * az + s * ay;
        ma[2][1] = k * ay * az - s * ax;
        ma[2][2] = k * az2 + c;
        ma[3][3] = 1.0;
        matrix.setValue(ma);
    }

    public void invert() {
        this.mValue.setAngle(-this.mValue.getAngle());
    }

    @Override
    public String toString() {
        float[] vector = new float[3];
        this.getVector(vector);
        return String.valueOf(vector[0]) + " " + vector[1] + " " + vector[2] + " " + this.getAngle();
    }
}

