/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.ColorRGBAValue;
import org.cybergarage.x3d.field.SFColor;

public class SFColorRGBA
extends Field {
    private ColorRGBAValue mValue = new ColorRGBAValue();

    public SFColorRGBA() {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public SFColorRGBA(SFColor color) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(color);
    }

    public SFColorRGBA(float r, float g, float b, float a) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(r, g, b, a);
    }

    public SFColorRGBA(float[] value) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(value);
    }

    public SFColorRGBA(String value) {
        this.setType(FieldType.SFCOLORRGBA);
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        ColorRGBAValue colorRGBAValue = this.mValue;
        synchronized (colorRGBAValue) {
            this.mValue = (ColorRGBAValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        ColorRGBAValue object;
        ColorRGBAValue colorRGBAValue = this.mValue;
        synchronized (colorRGBAValue) {
            object = this.mValue;
        }
        return object;
    }

    public void getValue(float[] value) {
        this.mValue.getValue(value);
    }

    public float[] getValue() {
        return this.mValue.getValue();
    }

    public float getRed() {
        return this.mValue.getRed();
    }

    public float getGreen() {
        return this.mValue.getGreen();
    }

    public float getBlue() {
        return this.mValue.getBlue();
    }

    public float getAlpha() {
        return this.mValue.getAlpha();
    }

    @Override
    public int getValueCount() {
        return 4;
    }

    public void setValue(float r, float g, float b, float a, boolean doShare) {
        this.mValue.setValue(r, g, b, a);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(float r, float g, float b, float a) {
        this.setValue(r, g, b, a, true);
    }

    public void setValue(float[] value) {
        if (value.length < 4) {
            return;
        }
        this.setValue(value[0], value[1], value[2], value[3]);
    }

    public void setValue(SFColorRGBA color, boolean doShare) {
        this.setValue(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha(), doShare);
    }

    public void setValue(SFColorRGBA color) {
        this.setValue(color, true);
    }

    @Override
    public void setValue(String string) {
        this.mValue.setValue(string);
    }

    @Override
    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFColorRGBA) {
            this.setValue((SFColorRGBA)field, doShare);
        }
    }

    @Override
    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void add(float r, float g, float b, float a) {
        this.mValue.add(r, g, b, a);
    }

    public void add(float[] value) {
        this.mValue.add(value);
    }

    public void add(SFColorRGBA value) {
        this.add(value.getValue());
    }

    public void sub(float r, float g, float b, float a) {
        this.mValue.sub(r, g, b, a);
    }

    public void sub(float[] value) {
        this.mValue.sub(value);
    }

    public void sub(SFColorRGBA value) {
        this.sub(value.getValue());
    }

    public void scale(float scale) {
        this.mValue.scale(scale);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRed()) + " " + this.getGreen() + " " + this.getBlue() + " " + this.getAlpha();
    }
}

