/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.x3d.field;

import org.cybergarage.x3d.Field;
import org.cybergarage.x3d.FieldType;
import org.cybergarage.x3d.field.ColorValue;

public class SFColor
extends Field {
    private ColorValue mValue = new ColorValue();

    public SFColor() {
        this.setType(FieldType.SFCOLOR);
        this.setValue(1.0f, 1.0f, 1.0f);
    }

    public SFColor(SFColor color) {
        this.setType(FieldType.SFCOLOR);
        this.setValue(color);
    }

    public SFColor(float r, float g, float b) {
        this.setType(FieldType.SFCOLOR);
        this.setValue(r, g, b);
    }

    public SFColor(float[] value) {
        this.setType(FieldType.SFCOLOR);
        this.setValue(value);
    }

    public SFColor(String value) {
        this.setType(FieldType.SFCOLOR);
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(Object object) {
        ColorValue colorValue = this.mValue;
        synchronized (colorValue) {
            this.mValue = (ColorValue)object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() {
        ColorValue object;
        ColorValue colorValue = this.mValue;
        synchronized (colorValue) {
            object = this.mValue;
        }
        return object;
    }

    public void getValue(float[] value) {
        this.mValue.getValue(value);
    }

    public float[] getValue() {
        return this.mValue.getValue();
    }

    public float getRed() {
        return this.mValue.getRed();
    }

    public float getGreen() {
        return this.mValue.getGreen();
    }

    public float getBlue() {
        return this.mValue.getBlue();
    }

    @Override
    public int getValueCount() {
        return 3;
    }

    public void setValue(float r, float g, float b, boolean doShare) {
        this.mValue.setValue(r, g, b);
        if (doShare) {
            this.postShareField(this);
        }
    }

    public void setValue(float r, float g, float b) {
        this.setValue(r, g, b, true);
    }

    public void setValue(float[] value) {
        if (value.length < 3) {
            return;
        }
        this.setValue(value[0], value[1], value[2]);
    }

    public void setValue(SFColor color, boolean doShare) {
        this.setValue(color.getRed(), color.getGreen(), color.getBlue(), doShare);
    }

    public void setValue(SFColor color) {
        this.setValue(color, true);
    }

    @Override
    public void setValue(String string) {
        this.mValue.setValue(string);
    }

    @Override
    public void setValue(Field field, boolean doShare) {
        if (field instanceof SFColor) {
            this.setValue((SFColor)field, doShare);
        }
    }

    @Override
    public void setValue(Field field) {
        this.setValue(field, true);
    }

    public void add(float r, float g, float b) {
        this.mValue.add(r, g, b);
    }

    public void add(float[] value) {
        this.mValue.add(value);
    }

    public void add(SFColor value) {
        this.add(value.getValue());
    }

    public void sub(float r, float g, float b) {
        this.mValue.sub(r, g, b);
    }

    public void sub(float[] value) {
        this.mValue.sub(value);
    }

    public void sub(SFColor value) {
        this.sub(value.getValue());
    }

    public void scale(float scale) {
        this.mValue.scale(scale);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getRed()) + " " + this.getGreen() + " " + this.getBlue();
    }
}

