/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

class Sftp
implements Runnable {
    InputStream in;
    OutputStream out;
    ChannelSftp c;
    private byte[] lf = new byte[]{10, 13};
    private byte[] del = new byte[]{8, 32, 8};
    private Thread thread = null;
    private static String[] help = new String[]{"      Available commands:", "      * means unimplemented command.", "cd path                       Change remote directory to 'path'", "lcd path                      Change local directory to 'path'", "chgrp grp path                Change group of file 'path' to 'grp'", "chmod mode path               Change permissions of file 'path' to 'mode'", "chown own path                Change owner of file 'path' to 'own'", "help                          Display this help text", "get remote-path [local-path]  Download file", "*lls [ls-options [path]]      Display local directory listing", "ln oldpath newpath            Symlink remote file", "*lmkdir path                  Create local directory", "lpwd                          Print local working directory", "ls [path]                     Display remote directory listing", "*lumask umask                 Set local umask to 'umask'", "mkdir path                    Create remote directory", "put local-path [remote-path]  Upload file", "pwd                           Display remote working directory", "stat path                     Display info about path\nexit                          Quit sftp", "quit                          Quit sftp", "rename oldpath newpath        Rename remote file", "rmdir path                    Remove remote directory", "rm path                       Delete remote file", "symlink oldpath newpath       Symlink remote file", "version                       Show SFTP version", "?                             Synonym for help"};

    Sftp(ChannelSftp c, InputStream in, OutputStream out) {
        this.c = c;
        this.in = in;
        this.out = out;
    }

    @Override
    public void run() {
        try {
            Vector<String> cmds = new Vector<String>();
            byte[] buf = new byte[1024];
            StringBuffer sb = new StringBuffer();
            while (true) {
                int i;
                this.out.write("sftp> ".getBytes());
                cmds.removeAllElements();
                sb.setLength(0);
                block23: while ((i = this.in.read(buf, 0, 1024)) > 0) {
                    if (i != 1) continue;
                    if (buf[0] == 8) {
                        if (sb.length() <= 0) continue;
                        sb.setLength(sb.length() - 1);
                        this.out.write(this.del, 0, this.del.length);
                        this.out.flush();
                        continue;
                    }
                    if (buf[0] == 13) {
                        this.out.write(this.lf, 0, this.lf.length);
                    } else {
                        if (buf[0] < 32 || (buf[0] & 0x80) != 0) continue;
                        this.out.write(buf, 0, i);
                    }
                    this.out.flush();
                    int j = 0;
                    while (j < i) {
                        sb.append((char)buf[j]);
                        if (buf[j] == 13) {
                            System.arraycopy(sb.toString().getBytes(), 0, buf, 0, sb.length());
                            i = sb.length();
                            break block23;
                        }
                        ++j;
                    }
                }
                if (i <= 0) break;
                if (--i > 0 && buf[i - 1] == 13) {
                    --i;
                }
                int s = 0;
                int ii = 0;
                while (ii < i) {
                    if (buf[ii] == 32) {
                        if (ii - s > 0) {
                            cmds.addElement(new String(buf, s, ii - s));
                        }
                        while (ii < i) {
                            if (buf[ii] != 32) break;
                            ++ii;
                        }
                        s = ii;
                    }
                    ++ii;
                }
                if (s < i) {
                    cmds.addElement(new String(buf, s, i - s));
                }
                if (cmds.size() == 0) continue;
                String cmd = (String)cmds.elementAt(0);
                if (cmd.equals("quit")) {
                    this.c.quit();
                    break;
                }
                if (cmd.equals("exit")) {
                    this.c.exit();
                    break;
                }
                if (cmd.equals("cd") || cmd.equals("lcd")) {
                    if (cmds.size() < 2) continue;
                    String path = (String)cmds.elementAt(1);
                    try {
                        if (cmd.equals("cd")) {
                            this.c.cd(path);
                            continue;
                        }
                        this.c.lcd(path);
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (cmd.equals("rm") || cmd.equals("rmdir") || cmd.equals("mkdir")) {
                    if (cmds.size() < 2) continue;
                    String path = (String)cmds.elementAt(1);
                    try {
                        if (cmd.equals("rm")) {
                            this.c.rm(path);
                            continue;
                        }
                        if (cmd.equals("rmdir")) {
                            this.c.rmdir(path);
                            continue;
                        }
                        this.c.mkdir(path);
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (cmd.equals("chgrp") || cmd.equals("chown") || cmd.equals("chmod")) {
                    if (cmds.size() != 3) continue;
                    String path = (String)cmds.elementAt(2);
                    int foo = 0;
                    if (cmd.equals("chmod")) {
                        byte[] bar = ((String)cmds.elementAt(1)).getBytes();
                        int j = 0;
                        while (j < bar.length) {
                            byte k = bar[j];
                            if (k < 48 || k > 55) {
                                foo = -1;
                                break;
                            }
                            foo <<= 3;
                            foo |= k - 48;
                            ++j;
                        }
                        if (foo == -1) {
                            continue;
                        }
                    } else {
                        try {
                            foo = Integer.parseInt((String)cmds.elementAt(1));
                        }
                        catch (Exception e) {
                            continue;
                        }
                    }
                    try {
                        if (cmd.equals("chgrp")) {
                            this.c.chgrp(foo, path);
                            continue;
                        }
                        if (cmd.equals("chown")) {
                            this.c.chown(foo, path);
                            continue;
                        }
                        if (!cmd.equals("chmod")) continue;
                        this.c.chmod(foo, path);
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (cmd.equals("pwd") || cmd.equals("lpwd")) {
                    String str = cmd.equals("pwd") ? "Remote" : "Local";
                    str = String.valueOf(str) + " working directory: ";
                    str = cmd.equals("pwd") ? String.valueOf(str) + this.c.pwd() : String.valueOf(str) + this.c.lpwd();
                    this.out.write(str.getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (cmd.equals("ls") || cmd.equals("dir")) {
                    String path = ".";
                    if (cmds.size() == 2) {
                        path = (String)cmds.elementAt(1);
                    }
                    try {
                        Vector vv = this.c.ls(path);
                        if (vv == null) continue;
                        int ii2 = 0;
                        while (ii2 < vv.size()) {
                            this.out.write(((String)vv.elementAt(ii2)).getBytes());
                            this.out.write(this.lf);
                            ++ii2;
                        }
                        this.out.flush();
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (cmd.equals("get") || cmd.equals("put")) {
                    if (cmds.size() != 2 && cmds.size() != 3) continue;
                    String p1 = (String)cmds.elementAt(1);
                    String p2 = ".";
                    if (cmds.size() == 3) {
                        p2 = (String)cmds.elementAt(2);
                    }
                    try {
                        MyProgressMonitor monitor = new MyProgressMonitor(this.out);
                        if (cmd.equals("get")) {
                            this.c.get(p1, p2, (SftpProgressMonitor)monitor);
                            continue;
                        }
                        this.c.put(p1, p2, (SftpProgressMonitor)monitor);
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (cmd.equals("ln") || cmd.equals("symlink") || cmd.equals("rename")) {
                    if (cmds.size() != 3) continue;
                    String p1 = (String)cmds.elementAt(1);
                    String p2 = (String)cmds.elementAt(2);
                    try {
                        if (cmd.equals("rename")) {
                            this.c.rename(p1, p2);
                            continue;
                        }
                        this.c.symlink(p1, p2);
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (cmd.equals("stat") || cmd.equals("lstat")) {
                    if (cmds.size() != 2) continue;
                    String p1 = (String)cmds.elementAt(1);
                    SftpATTRS attrs = null;
                    try {
                        attrs = cmd.equals("stat") ? this.c.stat(p1) : this.c.lstat(p1);
                    }
                    catch (SftpException e) {
                        this.out.write(e.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    if (attrs == null) continue;
                    this.out.write(attrs.toString().getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (cmd.equals("version")) {
                    this.out.write(("SFTP protocol version " + this.c.version()).getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (cmd.equals("help") || cmd.equals("help")) {
                    int j = 0;
                    while (j < help.length) {
                        this.out.write(help[j].getBytes());
                        this.out.write(this.lf);
                        ++j;
                    }
                    this.out.flush();
                    continue;
                }
                this.out.write(("unimplemented command: " + cmd).getBytes());
                this.out.write(this.lf);
                this.out.flush();
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    void kick() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        OutputStream out;
        long count = 0L;
        long max = 0L;
        String src;
        int percent = 0;

        MyProgressMonitor(OutputStream out) {
            this.out = out;
        }

        public void init(int op, String src, String dest, long max) {
            this.max = max;
            this.src = src;
            this.count = 0L;
            this.percent = 0;
            this.status();
        }

        public boolean count(long count) {
            this.count += count;
            this.percent = (int)((double)((float)this.count / (float)this.max) * 100.0);
            this.status();
            return true;
        }

        public void end() {
            this.percent = (int)((double)((float)this.count / (float)this.max) * 100.0);
            this.status();
            try {
                this.out.write(13);
                this.out.write(10);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void status() {
            try {
                this.out.write(13);
                this.out.write(27);
                this.out.write(91);
                this.out.write(75);
                this.out.write((String.valueOf(this.src) + ": " + this.percent + "% " + this.count + "/" + this.max).getBytes());
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

