/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import ciss.phase_viewer.ssh.hosts.HostSelector;
import java.io.Serializable;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class HostSelectorCombo
extends JComboBox
implements HostSelector,
Serializable {
    private static Logger logger = Logger.getLogger((String)HostSelectorCombo.class.getName());
    private String FS = System.getProperty("file.separator");
    private HostList list;

    public HostSelectorCombo() {
        this.init();
    }

    private void init() {
        this.list = HostList.getHostList();
        int numHosts = this.list.size();
        int i = 0;
        while (i < numHosts) {
            HostInfo info = this.list.getHostInfo(i);
            this.addItem(info.getName());
            ++i;
        }
        HostInfo def = this.list.getDefaultHost();
        logger.debug((Object)("default host: " + def.getName()));
        this.setSelectedItem(def.getName());
    }

    @Override
    public HostInfo getSelectedHost() {
        return this.list.getHostInfo(this.getSelectedIndex());
    }

    @Override
    public HostList getListofHosts() {
        return this.list;
    }

    public void debug() {
        this.list.debug();
    }

    @Override
    public int getSelectedIndex() {
        return super.getSelectedIndex();
    }

    public void recreate() {
    }

    @Override
    public void addHost(HostInfo hostInfo) {
        this.list.addLast(hostInfo);
        this.addItem(hostInfo.getName());
    }

    @Override
    public void deleteSelectedHost() {
        HostInfo hi = this.list.getHostInfo(this.getSelectedIndex());
        this.list.remove(hi);
        this.removeItem(hi);
    }
}

