/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh.hosts;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class CheckBoxJList
extends JList
implements ListSelectionListener,
MouseMotionListener {
    static Color listForeground;
    static Color listBackground;
    static Color listSelectionForeground;
    static Color listSelectionBackground;
    HashSet selectionCache = new HashSet();
    int toggleIndex = -1;
    boolean toggleWasSelected;
    private int currx = 0;
    private int curry = 0;

    static {
        UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
        listForeground = uid.getColor("List.foreground");
        listBackground = uid.getColor("List.background");
        listSelectionForeground = uid.getColor("List.selectionForeground");
        listSelectionBackground = uid.getColor("List.selectionBackground");
    }

    public CheckBoxJList() {
        this.addMouseMotionListener(this);
        this.setCellRenderer(new CheckBoxListCellRenderer());
        this.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (!lse.getValueIsAdjusting()) {
            this.removeListSelectionListener(this);
            HashSet<Integer> newSelections = new HashSet<Integer>();
            int size = this.getModel().getSize();
            int i = 0;
            while (i < size) {
                if (this.getSelectionModel().isSelectedIndex(i)) {
                    newSelections.add(new Integer(i));
                }
                ++i;
            }
            Iterator it = this.selectionCache.iterator();
            while (it.hasNext()) {
                int index = (Integer)it.next();
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            for (Integer nextInt : newSelections) {
                int index = nextInt;
                if (this.selectionCache.contains(nextInt)) {
                    this.getSelectionModel().removeSelectionInterval(index, index);
                    continue;
                }
                this.getSelectionModel().addSelectionInterval(index, index);
            }
            this.selectionCache.clear();
            int i2 = 0;
            while (i2 < size) {
                if (this.getSelectionModel().isSelectedIndex(i2)) {
                    this.selectionCache.add(new Integer(i2));
                }
                ++i2;
            }
            this.addListSelectionListener(this);
        }
    }

    public static void main(String[] args) {
        CheckBoxJList list = new CheckBoxJList();
        DefaultListModel<String> defModel = new DefaultListModel<String>();
        list.setModel(defModel);
        String[] listItems = new String[]{"Chris", "Joshua", "Daniel", "Michael", "Don", "Kimi", "Kelly", "Keagan"};
        Iterator<String> it = Arrays.asList(listItems).iterator();
        while (it.hasNext()) {
            defModel.addElement(it.next());
        }
        JScrollPane scroller = new JScrollPane(list, 22, 31);
        JFrame frame = new JFrame("Checkbox JList");
        frame.getContentPane().add(scroller);
        frame.pack();
        frame.setVisible(true);
    }

    private boolean checkCheckBox(int offx) {
        System.out.println("size: " + offx + ",currx: " + this.currx);
        return this.currx > 0 && this.currx < offx;
    }

    @Override
    public void mouseDragged(MouseEvent arg0) {
        this.currx = arg0.getPoint().x;
        this.curry = arg0.getPoint().y;
    }

    @Override
    public void mouseMoved(MouseEvent arg0) {
        this.currx = arg0.getPoint().x;
        this.curry = arg0.getPoint().y;
    }

    class CheckBoxListCellRenderer
    extends JComponent
    implements ListCellRenderer {
        DefaultListCellRenderer defaultComp;
        JCheckBox checkbox;

        public CheckBoxListCellRenderer() {
            this.setLayout(new BorderLayout());
            this.defaultComp = new DefaultListCellRenderer();
            this.checkbox = new JCheckBox();
            this.add((Component)this.checkbox, "West");
            this.add((Component)this.defaultComp, "Center");
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.defaultComp.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            try {
                int cx = this.getLocation().x;
                int cy = this.getLocation().y;
                int offx = (int)this.checkbox.getSize().getWidth();
                int offy = (int)this.checkbox.getSize().getHeight();
                if (CheckBoxJList.this.checkCheckBox(offx)) {
                    this.checkbox.setSelected(isSelected);
                }
            }
            catch (Exception exc) {
                exc.printStackTrace();
            }
            Component[] comps = this.getComponents();
            int i = 0;
            while (i < comps.length) {
                comps[i].setForeground(listForeground);
                comps[i].setBackground(listBackground);
                ++i;
            }
            return this;
        }
    }
}

