/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.ssh;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class Execute
implements Runnable {
    private static Logger logger = Logger.getLogger((String)Execute.class.getName());
    private Session session;
    private String command;
    private boolean verbose = true;

    public Execute(Session session) {
        this.session = session;
    }

    public void isVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Execute(Session session, String command) {
        this.session = session;
        this.command = command;
        this.verbose = false;
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String command(String command) {
        if (!this.session.isConnected()) {
            logger.error((Object)"not connected.");
            try {
                this.session.connect();
            }
            catch (JSchException e) {
                e.printStackTrace();
            }
        }
        logger.debug((Object)("executing command: " + command));
        String ret = "";
        Channel channel = null;
        try {
            channel = this.session.openChannel("exec");
        }
        catch (Exception exc) {
            logger.error((Object)"failed to open channel.");
            return null;
        }
        ((ChannelExec)channel).setCommand(command);
        InputStream in = null;
        try {
            in = channel.getInputStream();
        }
        catch (IOException ioe) {
            logger.error((Object)"failed to get inputstream.");
            return null;
        }
        try {
            channel.connect();
        }
        catch (JSchException jse) {
            logger.error((Object)"failed connection.");
        }
        if (this.verbose) {
            byte[] tmp = new byte[1024];
            while (true) {
                try {
                    while (!channel.isEOF() || in.available() > 0) {
                        int i;
                        while (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                            ret = String.valueOf(ret) + new String(tmp, 0, i);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"failed to obtain result... return val is incomplete.");
                    continue;
                }
                break;
            }
        }
        channel.disconnect();
        return ret;
    }

    @Override
    public void run() {
        this.command(this.command);
    }
}

