/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.settings;

import ciss.phase_viewer.common.ChaseFileChooser;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class PropertyPanel
extends InternalFrameChase {
    private Container cont;
    private final int FILE = 0;
    private final int DIRECTORY = 1;
    private GlobalProperties pm = PropertiesManager.getGlobalProperties(0);
    private JTabbedPane tp;
    private JTextField tfeditor = new JTextField(20);
    private JTextField tfgs = new JTextField(20);
    private JTextField tfemacs = new JTextField(20);
    private JTextField tfmpi = new JTextField(20);
    private JTextField tfperl = new JTextField(20);
    private JTextField tfbrowser = new JTextField(20);
    private JTextField tfBSV = new JTextField(20);
    private JTextField tfchasedir = new JTextField(20);
    private JTextField tfphasedir = new JTextField(20);
    private JButton btneditor = new JButton("choose...");
    private JButton btngs = new JButton("choose...");
    private JButton btnemacs = new JButton("choose...");
    private JButton btnmpi = new JButton("choose...");
    private JButton btnperl = new JButton("choose...");
    private JButton btnbrowser = new JButton("choose...");
    private JButton btnBSV = new JButton("chooser...");
    private JButton btnchasedir = new JButton("choose...");
    private JButton btnphasedir = new JButton("choose...");
    private JButton btnsave;
    private JButton btnsaveclose;
    private JButton btnclose;

    public PropertyPanel() {
        super("edit properties", true, true, true, true, new Dimension(360, 320));
        this.pm = PropertiesManager.getGlobalProperties(0);
        this.tp = new JTabbedPane();
        this.tp.addTab("external program path", this.createPanelExternal());
        this.cont = this.getContentPane();
        this.cont.setLayout(new FlowLayout());
        this.cont.add(this.tp);
        this.cont.add(this.createButtonPanel());
        this.setTextFromPM();
        this.addListenersAll();
        this.revalidate();
    }

    public void selectTab(int tab) {
        this.tp.setSelectedIndex(tab);
    }

    public JPanel getPanelExternal() {
        return this.createPanelExternal();
    }

    public JPanel getPanelPHASEViewer() {
        return this.createPanelPHASEViewer();
    }

    private JPanel createPanelExternal() {
        JPanel pext = new JPanel();
        pext.setLayout(new BoxLayout(pext, 1));
        pext.add(this.createTF(this.tfeditor, this.btneditor, "editor"));
        pext.add(this.createTF(this.tfgs, this.btngs, "gs"));
        pext.add(this.createTF(this.tfmpi, this.btnmpi, "mpirun"));
        if (this.pm == null) {
            this.pm = PropertiesManager.getGlobalProperties(0);
        }
        boolean mpiEnable = Boolean.valueOf(this.pm.getProperty("mpienable"));
        this.tfmpi.setEnabled(mpiEnable);
        this.btnmpi.setEnabled(mpiEnable);
        pext.add(this.createTF(this.tfbrowser, this.btnbrowser, "browser"));
        return pext;
    }

    private JPanel createPanelPHASEViewer() {
        JPanel pchase = new JPanel();
        pchase.setLayout(new BoxLayout(pchase, 1));
        pchase.add(this.createTF(this.tfchasedir, this.btnchasedir, "chase directory"));
        pchase.add(this.createTF(this.tfphasedir, this.btnphasedir, "phase directory"));
        pchase.add(Box.createVerticalStrut(180));
        this.btnchasedir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfchasedir, 1);
            }
        });
        this.btnphasedir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfphasedir, 1);
            }
        });
        return pchase;
    }

    private JPanel createButtonPanel() {
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new FlowLayout());
        this.btnsave = new JButton("save");
        this.btnsaveclose = new JButton("save & close");
        this.btnclose = new JButton("close");
        pbtn.add(this.btnsave);
        pbtn.add(this.btnsaveclose);
        pbtn.add(this.btnclose);
        return pbtn;
    }

    public JPanel createTF(JTextField tf, JButton btn, String title) {
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder(title));
        p.setLayout(new BoxLayout(p, 0));
        p.add(tf);
        p.add(btn);
        tf.setEditable(true);
        tf.setBackground(Color.lightGray.brighter());
        return p;
    }

    public JPanel createTFonly(JTextField tf, String title) {
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder(title));
        p.setLayout(new BoxLayout(p, 0));
        p.add(tf);
        tf.setEditable(true);
        tf.setBackground(Color.lightGray.brighter());
        return p;
    }

    private void addListenersAll() {
        this.btnclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.dispose();
            }
        });
        this.btnsaveclose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.saveProperties();
                PropertyPanel.this.dispose();
            }
        });
        this.btnsave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.saveProperties();
                PropertyPanel.this.dispose();
            }
        });
        this.btneditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfeditor, 0);
            }
        });
        this.btngs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfgs, 0);
            }
        });
        this.btnmpi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfmpi, 0);
            }
        });
        this.btnbrowser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfbrowser, 0);
            }
        });
        this.btnBSV.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertyPanel.this.bootFileChooser(PropertyPanel.this.tfBSV, 0);
            }
        });
    }

    private void setTextFromPM() {
        this.tfeditor.setText(this.pm.getProperty("editor"));
        this.tfgs.setText(this.pm.getProperty("gs"));
        this.tfmpi.setText(this.pm.getProperty("mpirunpath"));
        this.tfperl.setText(this.pm.getProperty("perl"));
        this.tfbrowser.setText(this.pm.getProperty("browser"));
        this.tfphasedir.setText(this.pm.getProperty("phasedir"));
        this.tfchasedir.setText(System.getProperty("pviewer.home"));
        this.tfBSV.setText(this.pm.getProperty("BioStationViewer"));
    }

    private void saveProperties() {
        this.pm.setProperty("editor", this.tfeditor.getText());
        this.pm.setProperty("gs", this.tfgs.getText());
        this.pm.setProperty("mpirunpath", this.tfmpi.getText());
        this.pm.setProperty("perl", this.tfperl.getText());
        this.pm.setProperty("browser", this.tfbrowser.getText());
        this.pm.setProperty("phasedir", this.tfphasedir.getText());
        this.pm.setProperty("chasedir", this.tfchasedir.getText());
        this.pm.setProperty("BioStationViewer", this.tfBSV.getText());
        this.pm.storeProperty();
    }

    private void bootFileChooser(JTextField tf, int mode) {
        ChaseFileChooser fdlg = new ChaseFileChooser("path");
        fdlg.setDialogType(2);
        fdlg.setDialogTitle("choose");
        if (mode == 0) {
            fdlg.setFileSelectionMode(0);
        } else if (mode == 1) {
            fdlg.setFileSelectionMode(1);
        } else {
            System.out.println("wrong specification of mode");
            return;
        }
        if (fdlg.showDialog(this.cont, "Select") != 0) {
            return;
        }
        tf.setText(fdlg.getSelectedFile().getAbsolutePath());
    }
}

