/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting.scriptexecscripts;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.scripting.scriptexecscripts.ScriptExecScript;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BshExecScript
implements ScriptExecScript {
    private Logger logger = Logger.getLogger((String)BshExecScript.class.getName());
    private GlobalProperties props = PropertiesManager.getGlobalProperties(0);

    @Override
    public String getScriptExecScriptName(HostInfo hostInfo) {
        if (hostInfo.isLocalHost() && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return "script_exec.bat";
        }
        return "script_exec.sh";
    }

    @Override
    public String createScriptExecScript(String[] execScripts, HostInfo hostInfo) {
        if (execScripts == null || execScripts.length == 0) {
            return "";
        }
        if (hostInfo.isLocalHost() && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return this.getBat(execScripts);
        }
        return this.getSh(execScripts);
    }

    private String getBat(String[] execScripts) {
        Object[] tmpscripts = new String[execScripts.length];
        int i = 0;
        while (i < tmpscripts.length) {
            tmpscripts[i] = "__" + execScripts[i];
            ++i;
        }
        String ret = "cd __TARGETDIR__" + System.getProperty("line.separator");
        ret = String.valueOf(ret) + "\"__JAVA__\" -Dpviewer.home=\"__CHASEDIR__\" -jar \"__CHASEJAR__\" interpreter_mode ";
        int i2 = 0;
        while (i2 < tmpscripts.length) {
            ret = String.valueOf(ret) + " " + tmpscripts[i2];
            ++i2;
        }
        ret = String.valueOf(ret) + System.getProperty("line.separator");
        String remove = this.props.getProperty("scripting_remove_tmpfiles");
        boolean rem = new Boolean(remove);
        if (rem) {
            Vector unique = Utils.removeDupli(tmpscripts);
            if (unique != null) {
                int i3 = 0;
                while (i3 < unique.size()) {
                    ret = String.valueOf(ret) + "del " + (String)unique.get(i3) + System.getProperty("line.separator");
                    ++i3;
                }
            }
            ret = String.valueOf(ret) + "del script_exec.bat" + System.getProperty("line.separator");
        }
        return ret;
    }

    private String getSh(String[] execScripts) {
        Object[] tmpscripts = new String[execScripts.length];
        int i = 0;
        while (i < tmpscripts.length) {
            tmpscripts[i] = "__" + execScripts[i];
            ++i;
        }
        String ret = "#!/bin/sh\n";
        ret = String.valueOf(ret) + "cd __TARGETDIR__\n";
        ret = String.valueOf(ret) + "\"__JAVA__\" -Dpviewer.home=\"__CHASEDIR__\" -jar \"__CHASEJAR__\" interpreter_mode ";
        int i2 = 0;
        while (i2 < tmpscripts.length) {
            ret = String.valueOf(ret) + " " + tmpscripts[i2];
            ++i2;
        }
        ret = String.valueOf(ret) + "\n";
        String remove = this.props.getProperty("scripting_remove_tmpfiles");
        boolean rem = new Boolean(remove);
        if (rem) {
            Vector unique = Utils.removeDupli(tmpscripts);
            if (unique != null) {
                int i3 = 0;
                while (i3 < unique.size()) {
                    ret = String.valueOf(ret) + "rm -f ./" + (String)unique.get(i3) + "\n";
                    ++i3;
                }
            }
            ret = String.valueOf(ret) + "rm -f ./script_exec.sh\n";
        }
        return ret;
    }

    @Override
    public String getScriptExecScriptExecString(String scriptExecScript, HostInfo hostInfo) {
        if (hostInfo.isLocalHost() && System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            return "\"" + scriptExecScript + "\">Log";
        }
        return scriptExecScript;
    }
}

