/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.scripting;

import ciss.phase_viewer.scripting.ScriptUtils;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class ScriptDescriptionPanel
extends JPanel {
    private Logger logger = Logger.getLogger((String)ScriptDescriptionPanel.class.getName());
    private JTextPane textPane;

    public ScriptDescriptionPanel(String scriptFile) {
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(new TitledBorder("description"));
        this.textPane = new JTextPane();
        this.textPane.setContentType("text;charset=Shift_JIS");
        this.textPane.setEditable(false);
        this.textPane.setText(ScriptUtils.getDescriptionFrom(scriptFile));
        JScrollPane scr = new JScrollPane(this.textPane);
        scr.setPreferredSize(new Dimension(500, 300));
        this.add(scr);
        this.textPane.setCaretPosition(0);
        this.revalidate();
    }

    public ScriptDescriptionPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder("description"));
        this.textPane = new JTextPane();
        this.textPane.setContentType("text;charset=Shift_JIS");
        this.textPane.setEditable(false);
        JScrollPane scr = new JScrollPane(this.textPane);
        this.add(scr);
    }

    public void setEditable(boolean editable) {
        this.textPane.setEditable(editable);
    }

    public void setScriptFile(String scriptFile) {
        this.textPane.setText(ScriptUtils.getDescriptionFrom(scriptFile));
        this.textPane.setCaretPosition(0);
        this.revalidate();
    }

    public String getScriptDescriptionText() {
        return this.textPane.getText();
    }
}

