/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectstatemanipulator;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeEvent;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChangeListener;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateChanger;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectStateGUI;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.SubProjectCreatorPanel;
import ciss.phase_viewer.ssh.hosts.HostInfo;
import ciss.phase_viewer.ssh.hosts.HostList;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;

public class NewProjectCreator
extends InternalFrameChase
implements ProjectStateChanger,
ProjectStateGUI {
    private static Logger logger = Logger.getLogger((String)NewProjectCreator.class.getName());
    private ProjectDirBrowserNode parentNode;
    private SubProjectCreatorPanel subpanel;
    private JCheckBox subedit;
    private JTextField name;
    private JTextField path;
    private Vector listeners = new Vector();
    private ProjectDirBrowser dirBrowser;
    private File[] files;
    private File parentDir;
    private JButton ok;

    @Override
    public JButton getOKButton() {
        return this.ok;
    }

    public NewProjectCreator(ProjectDirBrowserNode parentNode, ProjectDirBrowser dirBrowser) {
        super("new project", true, true, true, true, new Dimension(500, 300));
        this.parentNode = parentNode;
        this.dirBrowser = dirBrowser;
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel p = new JPanel();
        p.setBorder(new TitledBorder("edit project info"));
        p.setLayout(new BoxLayout(p, 0));
        HostInfo info = HostList.getHostList().getHostInfo("localhost");
        String baseDir = info.getProperty("basedir");
        File f = new File(baseDir);
        if (!f.exists() && !f.mkdirs()) {
            logger.error((Object)("failed to create " + baseDir));
            this.dispose();
            return;
        }
        this.name = new JTextField(this.getDefaultName(), 10);
        JPanel pname = new JPanel();
        pname.add(this.name);
        pname.setBorder(new TitledBorder("project name"));
        String defaultDir = this.parentNode.getProjectInfo().getProjectDirectory();
        this.path = new JTextField(defaultDir, 30);
        this.path.setEditable(false);
        this.files = new File(defaultDir).listFiles();
        this.parentDir = new File(defaultDir);
        JPanel ppath = new JPanel();
        ppath.add(this.path);
        ppath.setBorder(new TitledBorder("parent directory"));
        p.add(pname);
        p.add(ppath);
        JPanel ptmp = new JPanel();
        ptmp.setLayout(new BoxLayout(ptmp, 1));
        ptmp.add(p);
        this.getContentPane().add(ptmp);
        JPanel psub = new JPanel();
        psub.setBorder(new TitledBorder("initial sub project"));
        psub.setLayout(new BoxLayout(psub, 1));
        this.subedit = new JCheckBox("create initial sub project");
        JPanel psubedit = new JPanel();
        psubedit.setLayout(new BoxLayout(psubedit, 0));
        psub.add(this.subedit);
        this.subpanel = new SubProjectCreatorPanel(this.parentNode, this.dirBrowser, this);
        psub.add(this.subpanel);
        this.getContentPane().add(psub);
        this.subedit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewProjectCreator.this.subpanel.setEnabled(NewProjectCreator.this.subedit.isSelected());
            }
        });
        JPanel pbtn = new JPanel();
        pbtn.setLayout(new GridLayout(1, 2));
        this.ok = new JButton("ok");
        JButton cancel = new JButton("cancel");
        pbtn.add(this.ok);
        pbtn.add(cancel);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewProjectCreator.this.dispose();
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewProjectCreator.this.dispose();
                NewProjectCreator.this.manipulateProjectState();
            }
        });
        this.name.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                boolean ch = Utils.isCreatable(NewProjectCreator.this.parentDir, NewProjectCreator.this.name.getText());
                NewProjectCreator.this.ok.setEnabled(ch);
            }
        });
        this.name.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (NewProjectCreator.this.ok.isEnabled()) {
                    NewProjectCreator.this.ok.doClick();
                }
            }
        });
        this.getContentPane().add(pbtn);
        this.subpanel.setEnabled(false);
    }

    public void addProjectStateChangeListener(ProjectStateChangeListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public void manipulateProjectState() {
        String nam = this.name.getText();
        if (nam == null || nam.trim().length() == 0) {
            logger.error((Object)"enter a valid directory name.");
            return;
        }
        String projdir = String.valueOf(this.path.getText()) + System.getProperty("file.separator") + nam.trim();
        File f = new File(projdir);
        if (f.exists()) {
            logger.error((Object)("directory " + projdir + " exists!"));
            return;
        }
        if (!f.mkdirs()) {
            logger.error((Object)("failed to create " + projdir));
            this.dispose();
            return;
        }
        Element element = new Element("project");
        element.setAttribute(new Attribute("display", "true"));
        element.setAttribute(new Attribute("hassub", "true"));
        element.setAttribute(new Attribute("subident", "subproject"));
        Element elemname = new Element("name");
        elemname.setText(MyElement.encode(this.name.getText()));
        element.addContent((Content)elemname);
        Element elemdate = new Element("date");
        Calendar calendar = Calendar.getInstance();
        elemdate.setText(MyElement.encode(calendar.getTime().toString()));
        element.addContent((Content)elemdate);
        Element elemtype = new Element("type");
        elemtype.setText("chase project");
        element.addContent((Content)elemtype);
        Element elemdir = new Element("directory");
        elemdir.setText(MyElement.encode(String.valueOf(this.path.getText()) + System.getProperty("file.separator") + this.name.getText()));
        element.addContent((Content)elemdir);
        ProjectDirBrowserNode nd = new ProjectDirBrowserNode(element, this.dirBrowser, true);
        nd.addProjectDirBrowserNodeChangeListener(this.dirBrowser);
        this.dirBrowser.addObject(nd);
        if (this.subedit.isSelected()) {
            this.subpanel.setParentNode(nd);
            this.subpanel.createElement();
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        int i = 0;
        while (i < this.listeners.size()) {
            ProjectStateChangeListener listener = (ProjectStateChangeListener)this.listeners.elementAt(i);
            listener.projectStateChanged(new ProjectStateChangeEvent(this, this.name.getText()));
            ++i;
        }
    }

    private String getDefaultName() {
        boolean proj = false;
        Enumeration<TreeNode> enumeration = this.parentNode.children();
        String defaultName = "project";
        Vector<String> vec = new Vector<String>();
        while (enumeration.hasMoreElements()) {
            String name;
            ProjectDirBrowserNode node = (ProjectDirBrowserNode)enumeration.nextElement();
            ProjectInfo info = node.getProjectInfo();
            if (info.getInfoType() != 1 || !(name = info.getProjectName().toLowerCase()).startsWith(defaultName)) continue;
            vec.addElement(name);
        }
        if (vec.size() == 0) {
            return defaultName;
        }
        return NewProjectCreator.getNonDupliString(defaultName, vec);
    }

    protected static String getNonDupliString(String string, Vector comp) {
        boolean foundDupli;
        String compstring = string;
        int max = 500;
        int co = 0;
        do {
            foundDupli = false;
            int i = 0;
            while (i < comp.size()) {
                if (compstring.equals((String)comp.elementAt(i))) {
                    foundDupli = true;
                    compstring = String.valueOf(string) + String.valueOf(co);
                    ++co;
                }
                ++i;
            }
        } while (foundDupli && co < max);
        return compstring;
    }
}

