/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserObject;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.log4j.Logger;

public class ProjectDirBrowserRenderer
extends DefaultTreeCellRenderer {
    private static Logger logger = Logger.getLogger((String)ProjectDirBrowserRenderer.class.getName());
    private Color foregroundColor = this.getForeground();
    private Color backgroundColor = this.getBackground();

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        ProjectDirBrowserNode node = (ProjectDirBrowserNode)value;
        Object obj = node.getUserObject();
        if (obj instanceof ProjectDirBrowserObject) {
            ProjectDirBrowserObject pdbobject = (ProjectDirBrowserObject)obj;
            this.setText(pdbobject.getText());
            Icon closeIcon = pdbobject.getIcon();
            Icon openIcon = pdbobject.getOpenIcon();
            if (closeIcon != null) {
                this.setIcon(closeIcon);
                this.leafIcon = closeIcon;
                this.closedIcon = closeIcon;
            }
            if (openIcon != null) {
                this.openIcon = openIcon;
            }
            this.setOpaque(true);
            if (isSelected) {
                this.setForeground(Color.red);
                this.setBackground(Color.cyan);
            } else {
                this.setForeground(this.foregroundColor);
                this.setBackground(this.backgroundColor);
            }
            return this;
        }
        Component comp = super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, hasFocus);
        if (isSelected) {
            comp.setForeground(Color.red);
            comp.setBackground(Color.cyan);
        } else {
            comp.setForeground(Color.black);
            comp.setBackground(Color.white);
        }
        return comp;
    }
}

