/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser.projectdirbrowser;

import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.main.PluginLoader;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;

public class ProjectDirBrowserObject {
    private Logger logger = Logger.getLogger((String)ProjectDirBrowserObject.class.getName());
    private String text;
    private Icon icon;
    private Icon icon_open;
    private ProjectInfo proj;

    public ProjectDirBrowserObject(ProjectInfo proj) {
        this.proj = proj;
        this.init();
    }

    private void init() {
        String type = this.proj.getProjectType();
        URL projurl = ProjectDirBrowserObject.class.getResource(ProjectManipulator.PROJECT_MANIPULATOR_XML_PATH);
        Document doc = XMLUtils.getDocumentFromURL(projurl);
        try {
            Element elem = doc.getRootElement();
            if (!elem.getName().equals("root")) {
                this.logger.error((Object)"invalid ProjectSpecification file.");
            }
            List list = elem.getChildren("project");
            String iconpath = null;
            String iconpath_open = null;
            int i = 0;
            while (i < list.size()) {
                Element element = (Element)list.get(i);
                String name = MyElement.decode(element.getChildTextTrim("name"));
                if (name.equals(type)) {
                    iconpath = MyElement.decode(element.getChildTextTrim("iconpath"));
                    iconpath_open = MyElement.decode(element.getChildTextTrim("iconpath_open"));
                    break;
                }
                ++i;
            }
            this.logger.debug((Object)("iconpath: " + iconpath + " iconpath_open: " + iconpath_open));
            this.text = this.proj.getProjectName();
            PluginLoader loader = new PluginLoader();
            URL res = null;
            URL res_open = null;
            try {
                res = loader.getResource(iconpath);
                res_open = loader.getResource(iconpath_open);
            }
            catch (Exception ex) {
                this.logger.error((Object)"failed to resolve icon path.");
            }
            this.icon = new ImageIcon(res);
            this.icon_open = new ImageIcon(res_open);
        }
        catch (Exception ex) {
            this.logger.error((Object)"error in loading plugin.");
        }
    }

    public void recreate() {
        this.init();
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Icon getOpenIcon() {
        return this.icon_open;
    }

    public String toString() {
        return this.text;
    }
}

