/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.projectbrowser;

import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.common.ExternalProgramExecuter;
import ciss.phase_viewer.common.MyThread;
import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.jdom.MyElement;
import ciss.phase_viewer.jdom.XMLUtils;
import ciss.phase_viewer.projectbrowser.ProjectBrowser;
import ciss.phase_viewer.projectbrowser.ProjectInfo;
import ciss.phase_viewer.projectbrowser.ProjectManipulator;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowser;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserNode;
import ciss.phase_viewer.projectbrowser.projectdirbrowser.ProjectDirBrowserObject;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.ProjectState;
import ciss.phase_viewer.projectbrowser.projectstatemanipulator.SubProjectCreatorPanel;
import ciss.phase_viewer.settings.PropertiesManager;
import ciss.phase_viewer.textviewer.HyperLink;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ProjectBrowserUtils {
    private static final Logger logger = Logger.getLogger((String)ProjectBrowserUtils.class.getName());

    public static void setHtmlToEditorPane(JEditorPane pane, URL url) {
        pane.setContentType("text/html; charset=Shift_JIS");
        pane.setEditable(false);
        pane.addHyperlinkListener(new HyperLink(pane, url));
        try {
            pane.setPage(url);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void bootTextViewer(String textfile) {
        File file = new File(textfile);
        if (file.exists()) {
            String editor = PropertiesManager.getGlobalProperties(0).getProperty("editor");
            if (editor == null) {
                logger.error((Object)"specify editor");
                return;
            }
            MyThread myThread = new MyThread(String.valueOf(Utils.getPathDQ(editor)) + " " + Utils.getPathDQ(textfile));
        } else {
            logger.error((Object)"file non-existent");
        }
    }

    public static void bootTextViewer(String textfile, String filter, boolean ignoreCase) {
        if (ignoreCase) {
            filter = filter.toLowerCase();
        }
        String compString = "";
        String readString = "";
        String writeString = "";
        try {
            BufferedReader br = new BufferedReader(new FileReader(textfile));
            while ((readString = br.readLine()) != null) {
                compString = ignoreCase ? readString.toLowerCase() : readString;
                if (compString.indexOf(filter) == -1) continue;
                writeString = String.valueOf(writeString) + readString + System.getProperty("line.separator");
            }
            br.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.out.println("failed to read " + textfile);
        }
        File file = new File(String.valueOf(textfile) + "_" + filter);
        file.deleteOnExit();
        try {
            FileWriter fwriter = new FileWriter(file);
            BufferedWriter bwriter = new BufferedWriter(fwriter);
            bwriter.write(writeString, 0, writeString.length());
            bwriter.flush();
            fwriter.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.out.println("failed to write " + file);
        }
        ProjectBrowserUtils.bootTextViewer(file.getAbsolutePath());
    }

    public static void bootBioStationViewer(String input) {
        String bsviewer = String.valueOf(System.getProperty("pviewer.home")) + System.getProperty("file.separator") + PropertiesManager.getGlobalProperties(0).getProperty("BioStationViewer");
        if (bsviewer == null) {
            logger.error((Object)"could not find BioStationViewer");
            return;
        }
        if (!new File(bsviewer).exists()) {
            logger.error((Object)"could not find BioStationViewer");
            return;
        }
        String fileOption = "";
        if (input != null && input.length() != 0) {
            fileOption = " -f " + Utils.getPathDQ(input);
        }
        String bsvexe = String.valueOf(Utils.getPathDQ(ConstParameters.getJavaPath())) + " -jar " + Utils.getPathDQ(bsviewer) + fileOption;
        MyThread mt = new MyThread(bsvexe);
    }

    public static boolean changeProjectState(ProjectDirBrowser dirBrowser, ProjectState state) {
        int projState = state.getProjectState();
        ProjectDirBrowserNode origNode = state.getNode();
        ProjectDirBrowserObject origObj = (ProjectDirBrowserObject)origNode.getUserObject();
        ProjectDirBrowserNode origParentNode = state.getParentNode();
        ProjectDirBrowserNode nd = dirBrowser.getSelectedNode();
        if (nd == null) {
            logger.error((Object)"node not selected.");
            return false;
        }
        ProjectDirBrowserObject obj = (ProjectDirBrowserObject)nd.getUserObject();
        if (projState == ProjectState.PROJECT_RENAME) {
            Element element = origNode.getProjectElement();
            ProjectInfo info = origNode.getProjectInfo();
            String projDir = info.getProjectDirectory();
            String origName = obj.getText();
            File origFile = new File(String.valueOf(new File(projDir).getParent()) + System.getProperty("file.separator") + origName);
            File newFile = new File(projDir);
            logger.debug((Object)("renaming " + origFile.getAbsolutePath() + " to " + newFile.getAbsolutePath()));
            ProjectBrowser brow = null;
            if (origFile.equals(newFile) || !origFile.renameTo(newFile)) {
                info.setProjectName(origName);
                info.setProjectDirectory(String.valueOf(new File(info.getProjectDirectory()).getParent()) + System.getProperty("file.separator") + origName);
                logger.error((Object)("failed to rename " + origFile.getName() + " to " + newFile.getName()));
                return false;
            }
            ProjectDirBrowser.saveMyProjectsDocument();
            origObj.recreate();
            dirBrowser.updateTree(nd);
            brow = origNode.getProjectBrowser();
            if (brow != null) {
                brow.recreate();
            }
        } else if (projState == ProjectState.PROJECT_CUT) {
            String origDir = origNode.getProjectInfo().getProjectDirectory();
            Element ele = origNode.getProjectElement();
            String newDir = String.valueOf(nd.getProjectInfo().getProjectDirectory()) + System.getProperty("file.separator") + new File(origDir).getName();
            logger.debug((Object)("pasting to node: " + nd));
            String newname = new File(newDir).getName();
            if (!new File(origDir).equals(new File(newDir))) {
                newname = ProjectBrowserUtils.getUniqueName(state, new File(newDir).getParentFile());
            }
            newDir = String.valueOf(new File(newDir).getParent()) + System.getProperty("file.separator") + newname;
            logger.debug((Object)("newDir: " + newDir));
            if (ExternalProgramExecuter.move(origDir, newDir)) {
                origNode.getProjectInfo().setProjectDirectory(newDir);
                origObj.recreate();
                dirBrowser.updateTree(origNode);
                dirBrowser.addObject(nd, origNode, true);
                ele.detach();
                nd.getProjectElement().addContent((Content)ele);
                ProjectDirBrowser.saveMyProjectsDocument();
                ProjectBrowser brow = origNode.getProjectBrowser();
                if (brow != null) {
                    brow.recreate();
                }
            } else {
                logger.error((Object)"couldn't move file ... restoring original project configuration");
                dirBrowser.addObject(origParentNode, origNode, true);
                dirBrowser.updateTree(origNode);
                return false;
            }
            dirBrowser.updateTree(origNode);
        } else if (projState == ProjectState.PROJECT_COPY) {
            String origDir = origNode.getProjectInfo().getProjectDirectory();
            Element ele = origNode.getProjectElement();
            String newDir = nd.getProjectInfo().getProjectDirectory();
            String newname = ProjectBrowserUtils.getUniqueName(state, new File(newDir));
            logger.debug((Object)("origDir: " + origDir + ", newDir: " + newDir));
            if (Utils.copyDir(new File(origDir), new File(newDir), newname)) {
                ProjectDirBrowserNode newNode = (ProjectDirBrowserNode)origNode.clone();
                newNode.getProjectInfo().setProjectDirectory(String.valueOf(new File(newDir).getParent()) + System.getProperty("file.separator") + newname);
                ((ProjectDirBrowserObject)newNode.getUserObject()).recreate();
                dirBrowser.updateTree(newNode);
                dirBrowser.addObject(nd, newNode, true);
                Element newElem = newNode.getProjectElement();
                Element date = newElem.getChild("date");
                if (date == null) {
                    date = new Element("date").setText(MyElement.encode(Calendar.getInstance().getTime().toString()));
                    newElem.addContent((Content)date);
                } else {
                    date.setText(MyElement.encode(Calendar.getInstance().getTime().toString()));
                }
                ProjectDirBrowser.saveMyProjectsDocument();
                dirBrowser.recreate();
            } else {
                return false;
            }
        }
        return true;
    }

    public static Vector<String> getSupportedSubProjectTypes() {
        Element elem = ProjectBrowserUtils.getProjSpecElement();
        List list = elem.getChildren("project");
        Vector<String> retvec = new Vector<String>();
        int i = 0;
        while (i < list.size()) {
            Element pro = (Element)list.get(i);
            String type = MyElement.decode(pro.getChildTextTrim("type"));
            if (type.equals("sub")) {
                retvec.addElement(MyElement.decode(pro.getChildTextTrim("name")));
            }
            ++i;
        }
        return retvec;
    }

    private static Element getProjSpecElement() {
        Document doc = null;
        SAXBuilder builder = new SAXBuilder();
        URL projurl = null;
        projurl = SubProjectCreatorPanel.class.getResource(ProjectManipulator.PROJECT_MANIPULATOR_XML_PATH);
        try {
            doc = builder.build(projurl);
        }
        catch (JDOMException jde) {
            logger.error((Object)("failed to parse " + projurl));
            logger.error((Object)"unrecoverable error.");
        }
        catch (IOException ioe) {
            logger.error((Object)("failed to parse " + projurl));
            logger.error((Object)"unrecoverable error.");
        }
        Element elem = doc.getRootElement();
        if (!elem.getName().equals("root")) {
            logger.error((Object)"invalid ProjectSpecification file.");
        }
        return elem;
    }

    private static String getUniqueName(ProjectState state, File toDir) {
        String dir = state.getNode().getProjectInfo().getProjectDirectory();
        File[] files = toDir.listFiles();
        if (files == null || files.length == 0) {
            return new File(dir).getName();
        }
        String[] names = new String[files.length];
        int i = 0;
        while (i < names.length) {
            names[i] = files[i].getName();
            ++i;
        }
        String key = new File(dir).getName();
        while (true) {
            boolean equ = false;
            int i2 = 0;
            while (i2 < names.length) {
                if (names[i2].equals(key)) {
                    equ = true;
                }
                ++i2;
            }
            if (!equ) break;
            key = String.valueOf(key) + "_";
        }
        return key;
    }

    public static List getElementFromDir(File dir) {
        logger.debug((Object)"at getElementFromDir");
        Vector<Element> ret = new Vector<Element>();
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return ret;
        }
        int i = 0;
        while (i < files.length) {
            if (!files[i].getName().equals("data") && files[i].isDirectory()) {
                ret.addElement(ProjectBrowserUtils.doDir(files[i]));
            }
            ++i;
        }
        return ret;
    }

    private static Element doDir(File dir) {
        boolean chaseXMLexists = false;
        Element element = null;
        File[] files = dir.listFiles();
        String chaseXML = "phase-viewer.xml";
        int i = 0;
        while (i < files.length) {
            if (files[i].getName().equals(chaseXML)) {
                chaseXMLexists = true;
            }
            ++i;
        }
        if (chaseXMLexists) {
            Document document = XMLUtils.getDocumentFromFile(new File(String.valueOf(dir.getAbsolutePath()) + System.getProperty("file.separator") + chaseXML));
            Element rootElement = document.getRootElement();
            Element typeElement = rootElement.getChild("type");
            if (typeElement != null) {
                element = ProjectBrowserUtils.getSubProjectElement(typeElement.getTextTrim(), dir);
            }
        } else {
            element = ProjectBrowserUtils.getProjectElement(dir);
        }
        if (element == null) {
            return null;
        }
        i = 0;
        while (i < files.length) {
            Element eledir;
            if (files[i].isDirectory() && (eledir = ProjectBrowserUtils.doDir(files[i])) != null) {
                element.addContent((Content)eledir);
            }
            ++i;
        }
        return element;
    }

    private static Element getProjectElement(File currDir) {
        Element elem = new Element("project");
        elem.setAttribute("display", "true");
        boolean hasSub = currDir.listFiles() != null && currDir.listFiles().length != 0;
        elem.setAttribute("hassub", String.valueOf(hasSub));
        elem.setAttribute("subident", "subproject");
        elem.setAttribute("shouldbevisible", "false");
        elem.setAttribute("selected", "false");
        String name = MyElement.encode(currDir.getName());
        Element nameElement = new Element("name").setText(name);
        elem.addContent((Content)nameElement);
        Date date = new Date(currDir.lastModified());
        String dateString = MyElement.encode(date.toString());
        Element dateElement = new Element("date").setText(dateString);
        elem.addContent((Content)dateElement);
        Element typeElement = new Element("type").setText("chase project");
        elem.addContent((Content)typeElement);
        String dirString = MyElement.encode(currDir.getAbsolutePath());
        Element dirElement = new Element("directory").setText(dirString);
        elem.addContent((Content)dirElement);
        return elem;
    }

    private static Element getSubProjectElement(String type, File currDir) {
        Element elem = new Element("subproject");
        elem.setAttribute("display", "true");
        elem.setAttribute("shouldbevisible", "false");
        elem.setAttribute("selected", "false");
        String name = MyElement.encode(currDir.getName());
        Element nameElement = new Element("name").setText(name);
        elem.addContent((Content)nameElement);
        Date date = new Date(currDir.lastModified());
        String dateString = MyElement.encode(date.toString());
        Element dateElement = new Element("date").setText(dateString);
        elem.addContent((Content)dateElement);
        Element typeElement = new Element("type").setText(type);
        elem.addContent((Content)typeElement);
        if (type.equals("ekcal") || type.equals("uvsor-epsilon")) {
            String reldir;
            block13: {
                reldir = "";
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new FileReader(String.valueOf(currDir.getAbsolutePath()) + System.getProperty("file.separator") + "file_names.data"));
                        String line = "";
                        while ((line = reader.readLine()) != null) {
                            if (!(line = line.trim()).startsWith("F_CHGT")) continue;
                            String[] foo = line.split("=");
                            reldir = foo[1].replaceAll("'", "");
                            reldir = new File(reldir).getParent();
                            break;
                        }
                    }
                    catch (Exception line) {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Element assdir = new Element("associated_directory").setText(MyElement.encode(reldir));
            assdir.setAttribute("type", "parent");
            elem.addContent((Content)assdir);
        }
        String dirString = MyElement.encode(currDir.getAbsolutePath());
        Element dirElement = new Element("directory").setText(dirString);
        elem.addContent((Content)dirElement);
        Element commentElement = new Element("comment");
        elem.addContent((Content)commentElement);
        return elem;
    }

    public static boolean remove(ProjectDirBrowserNode node) {
        ProjectInfo info = node.getProjectInfo();
        String dir = info.getProjectDirectory();
        boolean ret = true;
        if (new File(dir).exists()) {
            ret = Utils.deleteDir(new File(dir));
        }
        if (ret) {
            node.getDirBrowser().getTree().scrollPathToVisible(new TreePath(node.getPath()));
            node.getDirBrowser().getTree().setSelectionPath(new TreePath(node.getPath()));
            node.getDirBrowser().removeCurrentNode();
            if (node.getProjectBrowser() != null && node.getProjectBrowser().isVisible()) {
                node.getProjectBrowser().dispose();
            }
        }
        return ret;
    }
}

