/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis.tableforinputinterface;

import ciss.phase_viewer.common.Utils;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTable;
import ciss.phase_viewer.inputinterface.inputinterfacetable.InputInterfaceTableColumns;
import ciss.phase_viewer.primitiveguis.tableforinputinterface.TableModelForInputInterface;
import java.text.DecimalFormat;
import java.util.EventListener;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.Logger;

public class TableModelForTabularData
extends TableModelForInputInterface {
    private static Logger logger = Logger.getLogger((String)TableModelForTabularData.class.getName());
    private Vector tableData = new Vector();
    private String[] idents;

    public TableModelForTabularData(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el) {
        super(inputSpecifications, input, mapSpecCol, el);
        super.init();
    }

    public TableModelForTabularData(String[] inputSpecifications, InputInterface input, int[] mapSpecCol, EventListener el, int columnIndex) {
        super(inputSpecifications, input, mapSpecCol, el, columnIndex);
        super.init();
    }

    @Override
    public void setValueAt(Object data, int row, int col) {
        if (row >= this.getRowCount()) {
            logger.error((Object)("tried to set " + data + " at " + row + ", " + col));
        }
        if (col >= this.mapSpecCol.length) {
            super.setValueAt(data, row, col);
            return;
        }
        if (!this.columns[this.mapSpecCol[col]].format()) {
            super.setValueAt(data, row, col);
        } else {
            Object formatedData;
            DecimalFormat formatter = this.columns[this.mapSpecCol[col]].getFormatter();
            if (data instanceof Double) {
                formatedData = formatter.format((Double)data);
            } else if (data instanceof String) {
                try {
                    Double d = Double.valueOf((String)data);
                    formatedData = formatter.format(d);
                }
                catch (NumberFormatException ne) {
                    formatedData = data;
                }
            } else {
                formatedData = data;
            }
            super.setValueAt(formatedData, row, col);
        }
    }

    @Override
    protected void createTableColumns() {
        if (this.columns == null) {
            return;
        }
        int i = 0;
        while (i < this.mapSpecCol.length) {
            this.addColumn(this.columns[this.mapSpecCol[i]].getName());
            ++i;
        }
        int nrw = this.manager.getTableSpec(this.inputSpecifications[0]).getNumRows();
        if (nrw > 0) {
            this.setRowCount(nrw);
        }
    }

    @Override
    protected void extractInputFile() {
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        this.idents = iitable.getColumnIdentifiers();
        this.tableData = iitable.getTableData();
        this.setInputToModel();
    }

    @Override
    protected void setInputToModel() {
        this.input.setUpdateUndoStack(false);
        this.updateInputInterface = false;
        int icol = this.getColumnCount();
        int irow = this.getRowCount();
        logger.debug((Object)("at setInputToModel(): dump tableData, whose size is " + this.tableData.size()));
        logger.debug((Object)("at setInputToModel(): icol, irow: " + icol + " " + irow));
        int i = 0;
        while (i < this.tableData.size()) {
            String[] tmp = (String[])this.tableData.elementAt(i);
            int j = 0;
            while (j < tmp.length) {
                logger.debug((Object)("tableData at " + i + " " + j + " : " + tmp[j]));
                ++j;
            }
            ++i;
        }
        String[] columnNames = new String[icol];
        Vector<Integer[]> map = new Vector<Integer[]>();
        int firstLetterCapsCol = -1;
        if (this.idents != null && this.tableData != null) {
            int i2;
            int i3 = 0;
            while (i3 < icol) {
                columnNames[i3] = this.getColumnName(i3);
                if (this.columns[this.mapSpecCol[i3]].isFirstLetterCaps()) {
                    firstLetterCapsCol = i3;
                }
                ++i3;
            }
            i3 = 0;
            while (i3 < icol) {
                int j = 0;
                while (j < this.idents.length) {
                    if (columnNames[i3].equalsIgnoreCase(this.idents[j])) {
                        Integer[] it = new Integer[]{new Integer(i3), new Integer(j)};
                        map.addElement(it);
                    }
                    ++j;
                }
                ++i3;
            }
            Vector<Integer> itable = new Vector<Integer>();
            Vector<Integer> iinput = new Vector<Integer>();
            int i4 = 0;
            while (i4 < map.size()) {
                Integer[] it = (Integer[])map.get(i4);
                itable.addElement(it[0]);
                iinput.addElement(it[1]);
                ++i4;
            }
            int dataSize = this.tableData.size();
            Vector<String> dummy = new Vector<String>();
            if (dataSize > irow) {
                i2 = irow;
                while (i2 < dataSize) {
                    int j = 0;
                    while (j < icol) {
                        dummy.addElement("");
                        ++j;
                    }
                    this.addRow(dummy);
                    dummy = new Vector();
                    ++i2;
                }
            }
            i2 = 0;
            while (i2 < this.tableData.size()) {
                String[] rowData = (String[])this.tableData.get(i2);
                int j = 0;
                while (j < map.size()) {
                    int it = (Integer)itable.get(j);
                    int ii = (Integer)iinput.get(j);
                    String dat = rowData[ii];
                    if (it == firstLetterCapsCol) {
                        dat = Utils.firstLetterCaps(dat);
                    }
                    logger.debug((Object)("setting value : " + dat + " at row: " + i2 + " and column: " + it));
                    this.setValueAt(dat, i2, it);
                    ++j;
                }
                ++i2;
            }
        } else {
            logger.debug((Object)"ident or tableData was null.");
        }
        this.updateInputInterface = true;
        this.input.setUpdateUndoStack(true);
    }

    @Override
    public void inputInterfaceInitializing() {
        logger.debug((Object)("intializing TableModel: " + this.inputSpecifications[0]));
        TableModelListener[] listeners = this.getTableModelListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeTableModelListener(listeners[i]);
            ++i;
        }
        int row = this.getRowCount();
        int col = this.getColumnCount();
        int nullCount = 0;
        int i2 = 0;
        while (i2 < row) {
            int j = 0;
            while (j < col) {
                Object obj = this.getValueAt(i2, j);
                if (obj != null && obj instanceof String && ((String)obj).trim().length() == 0) {
                    ++nullCount;
                }
                this.setValueAt("", i2, j);
                ++j;
            }
            if (nullCount == col) break;
            nullCount = 0;
            ++i2;
        }
        i2 = 0;
        while (i2 < listeners.length) {
            this.addTableModelListener(listeners[i2]);
            ++i2;
        }
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent e) {
        logger.debug((Object)("entry changed: " + e.getTag()));
        if (e.getSource() == this) {
            return;
        }
        if (e == null || e.getTag() == null) {
            logger.debug((Object)"something is wrong... InputInterfaceEntryChangeEvent not properly initialized.");
            return;
        }
        if (!e.getTag().trim().equalsIgnoreCase(this.inputSpecifications[0])) {
            return;
        }
        InputInterfaceEntry entry = e.getEntry();
        if (entry.getEntryType() != 1) {
            return;
        }
        logger.debug((Object)("e.getSource(): " + e.getSource()));
        logger.debug((Object)("this: " + this));
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        if (iitable.getColumnIdentifiers() != null) {
            this.idents = iitable.getColumnIdentifiers();
        }
        this.tableData = iitable.getTableData();
        logger.debug((Object)("dump tableData, whose size is " + this.tableData.size()));
        int i = 0;
        while (i < this.tableData.size()) {
            String[] tmp = (String[])this.tableData.elementAt(i);
            int j = 0;
            while (j < tmp.length) {
                logger.debug((Object)("tableData at " + i + " " + j + " : " + tmp[j]));
                ++j;
            }
            ++i;
        }
        TableModelListener[] listeners = this.getTableModelListeners();
        int i2 = 0;
        while (i2 < listeners.length) {
            this.removeTableModelListener(listeners[i2]);
            ++i2;
        }
        int rowCount = this.getEffectiveRowCount();
        int colCount = this.getColumnCount();
        if (rowCount > this.tableData.size()) {
            int i3 = rowCount - 1;
            while (i3 >= this.tableData.size()) {
                int j = 0;
                while (j < colCount) {
                    this.setValueAt("", i3, j);
                    ++j;
                }
                --i3;
            }
        }
        this.setInputToModel();
        this.restoreListeners(listeners);
        if (this.getParentTable() != null) {
            this.getParentTable().repaint();
            this.getParentTable().revalidate();
        }
    }

    private int getEffectiveRowCount() {
        int count = 0;
        int i = 0;
        while (i < this.getRowCount()) {
            int nullcount = 0;
            int j = 0;
            while (j < this.getColumnCount()) {
                Object obj = this.getValueAt(i, j);
                if (obj == null || obj.toString().trim().length() == 0) {
                    ++nullcount;
                }
                ++j;
            }
            if (nullcount == this.getColumnCount()) {
                return count;
            }
            ++count;
            ++i;
        }
        return count;
    }

    @Override
    public void execute(EventObject e) {
        TableModelListener[] listeners = this.getTableModelListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeTableModelListener(listeners[i]);
            ++i;
        }
        TableModelEvent tmde = (TableModelEvent)e;
        int first = 0;
        int last = 0;
        if (tmde == null) {
            this.restoreListeners(listeners);
            return;
        }
        first = tmde.getFirstRow();
        last = tmde.getLastRow();
        logger.debug((Object)("first row that changed: " + tmde.getFirstRow()));
        logger.debug((Object)("last row that changed: " + tmde.getLastRow()));
        logger.debug((Object)("row count: " + this.getRowCount()));
        logger.debug((Object)("type: " + tmde.getType()));
        if (last >= this.getRowCount() || first < 0) {
            this.restoreListeners(listeners);
            return;
        }
        if (first < 0 || last < 0 || last >= this.getRowCount() || first >= this.getRowCount()) {
            this.restoreListeners(listeners);
            return;
        }
        int i2 = 0;
        while (i2 < this.mapSpecCol.length) {
            if (this.columns[this.mapSpecCol[i2]].getDefaultValue().trim().equals("INCRE") && this.columns[this.mapSpecCol[i2]].ignoreOnSave()) {
                this.setValueAt(new Integer(last + 1), last, i2);
            }
            ++i2;
        }
        if (!this.updateInputInterface) {
            this.restoreListeners(listeners);
            return;
        }
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        Vector data = new Vector();
        logger.debug((Object)"updating table data ...");
        int nullCount = 0;
        String[] iden = new String[this.mapSpecCol.length];
        String[] row = new String[this.mapSpecCol.length];
        int rowC = this.getRowCount();
        int i3 = first;
        while (i3 < last + 1) {
            int j = 0;
            while (j < this.mapSpecCol.length) {
                InputInterfaceTableColumns col = this.columns[this.mapSpecCol[j]];
                if (col.ignoreOnSave()) {
                    ++nullCount;
                } else {
                    iitable.setWillChangeRow(i3, InputInterfaceTable.REPLACE);
                    iitable.saveState();
                    String nam = this.columns[this.mapSpecCol[j]].getInputSpecifications();
                    if (i3 >= rowC) {
                        iitable.removeTableDataRow(i3, last);
                        this.restoreListeners(listeners);
                        return;
                    }
                    Object obj = this.getValueAt(i3, j);
                    iden[j] = nam;
                    String string = "";
                    if (obj instanceof String) {
                        string = (String)obj;
                    } else if (obj instanceof Boolean) {
                        boolean bool = (Boolean)obj;
                        String string2 = string = bool ? "1" : "0";
                    }
                    if (string == null || string.trim().length() == 0) {
                        row[j] = "";
                        ++nullCount;
                    } else {
                        row[j] = string;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < this.mapSpecCol.length) {
                logger.debug((Object)"updating inputinterface object...");
                logger.debug((Object)("ident: " + iden[j]));
                logger.debug((Object)("value: " + row[j]));
                ++j;
            }
            iitable.replaceTableDataRow(iden, row, i3);
            ++i3;
        }
        this.input.replaceEntry(iitable, this, this.callListener);
        logger.debug((Object)("size of data: " + data.size()));
        this.restoreListeners(listeners);
    }

    public void clearInputInterfaceTableData() {
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        iitable.initializeData();
    }

    public String toString() {
        String ret = "cols: ";
        int i = 0;
        while (i < this.columns.length) {
            ret = String.valueOf(ret) + " " + this.columns[i].getName();
            ++i;
        }
        return ret;
    }

    @Override
    public void removeRow(int row) {
        logger.debug((Object)"removing row.");
        InputInterfaceTable iitable = this.input.getInputInterfaceTable(this.inputSpecifications[0]);
        iitable.setWillChangeRow(row, InputInterfaceTable.REMOVE);
        iitable.saveState();
        iitable.removeTableDataRow(row, row);
        this.input.replaceEntry(iitable, this, this.callListener);
        logger.debug((Object)"removing row from table.");
        this.updateInputInterface = false;
        super.removeRow(row);
        this.updateInputInterface = true;
        logger.debug((Object)"finished removing row");
    }
}

