/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.acviewer.colormap.BaseColorMap;
import ciss.phase_viewer.primitiveguis.ValueSliderListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class ValueSlider
extends JPanel {
    private Logger logger = Logger.getLogger((String)ValueSlider.class.getName());
    public static int LOG = 0;
    public static int LINEAR = 1;
    public static int FLOAT = 2;
    public static int INT = 3;
    private float minval;
    private float maxval;
    private float initval;
    private int valtype = LINEAR;
    private int valprecision = FLOAT;
    private JSlider jSlider;
    private JLabel minLabel;
    private JLabel maxLabel;
    private JTextField textField;
    private Vector listeners;
    private float incre = -1.0f;
    private TitledBorder titledBorder;
    private float factor;
    private float positiveFloat = 1.0f;
    public static int VERTICAL = 0;
    public static int HORIZONTAL = 1;
    private JPanel panel;

    public ValueSlider(float minval, float maxval) {
        this.minval = minval;
        this.maxval = maxval;
        this.initval = (minval + maxval) * 0.5f;
        this.init();
    }

    public ValueSlider(float minval, float maxval, float incre) {
        this.minval = minval;
        this.maxval = maxval;
        this.incre = incre;
        this.initval = (minval + maxval) * 0.5f;
        this.init();
    }

    public ValueSlider(float minval, float maxval, int valtype) {
        this.minval = minval;
        this.maxval = maxval;
        this.valtype = valtype;
        this.initval = (minval + maxval) * 0.5f;
        this.init();
    }

    public ValueSlider(int minval, int maxval) {
        this.minval = minval;
        this.maxval = maxval;
        this.initval = (float)(minval + maxval) * 0.5f;
        this.valprecision = INT;
        this.init();
    }

    public ValueSlider(int minval, int maxval, int initval) {
        this.minval = minval;
        this.maxval = maxval;
        this.initval = initval;
        this.valprecision = INT;
        this.init();
    }

    public void addValueSliderListener(ValueSliderListener list) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(list);
    }

    public void removeValueSliderListener(ValueSliderListener list) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(list);
    }

    public ValueSliderListener[] getValueSliderListener() {
        if (this.listeners == null) {
            return null;
        }
        Object[] list = new ValueSliderListener[this.listeners.size()];
        this.listeners.copyInto(list);
        return list;
    }

    private void notifyListeners() {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        int i = 0;
        while (i < this.listeners.size()) {
            ((ValueSliderListener)this.listeners.get(i)).valueSliderValueChanged();
            ++i;
        }
    }

    private void genFactor() {
        float ma = this.jSlider.getMaximum() - this.jSlider.getMinimum();
        if (this.valtype == LOG) {
            double lmin = Math.log(this.positiveFloat);
            double lmax = Math.log((double)this.maxval - (double)this.minval + (double)this.positiveFloat);
            this.factor = (float)((lmax - lmin) / (double)ma);
        } else {
            this.factor = (this.maxval - this.minval) / ma;
        }
    }

    private float getVal() {
        float val = 0.0f;
        float ma = this.jSlider.getMaximum() - this.jSlider.getMinimum();
        if (this.valtype == LOG) {
            double scaled = (double)this.jSlider.getValue() / (double)ma;
            val = (float)BaseColorMap.getValueFromLogScaledValue(this.minval, this.maxval, scaled);
        } else {
            val = (float)this.jSlider.getValue() * this.factor + this.minval;
        }
        return val;
    }

    private int getIntVal(float val) {
        if (val > this.maxval) {
            val = this.maxval;
        }
        if (val < this.minval) {
            val = this.minval;
        }
        if (this.valprecision == INT) {
            return (int)val;
        }
        int ival = 0;
        if (this.valtype == LOG) {
            double tmp = BaseColorMap.getLogScaledValue(this.minval, this.maxval, val);
            ival = (int)Math.round(tmp * (double)(this.jSlider.getMaximum() - this.jSlider.getMinimum()));
        } else {
            ival = Math.round((val - this.minval) * (float)(this.jSlider.getMaximum() - this.jSlider.getMinimum()) / (this.maxval - this.minval));
        }
        return ival;
    }

    public void setMinorTickSpacing(int n) {
        if (this.jSlider == null) {
            return;
        }
        this.jSlider.setMinorTickSpacing(n);
    }

    public void setMajorTickSpacing(int n) {
        if (this.jSlider == null) {
            return;
        }
        this.jSlider.setMajorTickSpacing(n);
    }

    public void setOrientation(int orientation) {
        if (orientation == VERTICAL) {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
        } else if (orientation == HORIZONTAL) {
            this.panel.setLayout(new BoxLayout(this.panel, 0));
        }
    }

    public JSlider getSlider() {
        return this.jSlider;
    }

    private void init() {
        this.titledBorder = new TitledBorder("value");
        this.setBorder(this.titledBorder);
        if (this.valprecision == FLOAT) {
            int min = 0;
            int max = 100;
            if (this.incre > 0.0f) {
                max = (int)((this.maxval - this.minval) / this.incre);
            }
            this.jSlider = new JSlider(min, max);
        } else {
            this.jSlider = new JSlider((int)this.minval, (int)this.maxval);
            this.jSlider.setMinorTickSpacing(1);
        }
        int ima = this.jSlider.getMaximum();
        this.genFactor();
        if (this.valprecision == FLOAT) {
            this.minLabel = new JLabel(String.valueOf(this.minval));
            this.maxLabel = new JLabel(String.valueOf(this.maxval));
        } else {
            this.minLabel = new JLabel(String.valueOf((int)this.minval));
            this.maxLabel = new JLabel(String.valueOf((int)this.maxval));
        }
        JPanel sliderPanel = new JPanel();
        sliderPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 17;
        gc.fill = 0;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.gridwidth = 1;
        sliderPanel.add((Component)this.minLabel, gc);
        gc.anchor = 10;
        gc.fill = 0;
        gc.gridx = 0;
        gc.gridy = 1;
        gc.gridwidth = 3;
        sliderPanel.add((Component)this.jSlider, gc);
        gc.gridx = 3;
        gc.gridy = 0;
        gc.anchor = 13;
        gc.gridwidth = 1;
        sliderPanel.add((Component)this.maxLabel, gc);
        this.textField = new JTextField(10);
        if (this.valprecision == FLOAT) {
            this.textField.setText(String.valueOf(this.initval));
        } else {
            this.textField.setText(String.valueOf((int)this.initval));
        }
        JPanel textPanel = new JPanel();
        textPanel.add(this.textField);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.add(textPanel);
        this.panel.add(sliderPanel);
        this.add(this.panel);
        this.jSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CaretListener[] listeners = ValueSlider.this.textField.getCaretListeners();
                if (listeners != null) {
                    int i = 0;
                    while (i < listeners.length) {
                        ValueSlider.this.textField.removeCaretListener(listeners[i]);
                        ++i;
                    }
                }
                if (ValueSlider.this.valprecision == FLOAT) {
                    float val = ValueSlider.this.getVal();
                    ValueSlider.this.textField.setText(String.valueOf(val));
                } else {
                    int val = ValueSlider.this.getValueInt();
                    ValueSlider.this.textField.setText(String.valueOf(val));
                }
                ValueSlider.this.notifyListeners();
                if (listeners != null) {
                    int i = 0;
                    while (i < listeners.length) {
                        ValueSlider.this.textField.addCaretListener(listeners[i]);
                        ++i;
                    }
                }
            }
        });
        this.textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                ChangeListener[] listeners = ValueSlider.this.jSlider.getChangeListeners();
                if (listeners != null) {
                    int i = 0;
                    while (i < listeners.length) {
                        ValueSlider.this.jSlider.removeChangeListener(listeners[i]);
                        ++i;
                    }
                }
                try {
                    float val = Float.parseFloat(ValueSlider.this.textField.getText().trim());
                    if (val > ValueSlider.this.maxval) {
                        val = ValueSlider.this.maxval;
                    }
                    if (val < ValueSlider.this.minval) {
                        val = ValueSlider.this.minval;
                    }
                    int ival = ValueSlider.this.getIntVal(val);
                    ValueSlider.this.jSlider.setValue(ival);
                }
                catch (Exception val) {
                    // empty catch block
                }
                ValueSlider.this.notifyListeners();
                if (listeners != null) {
                    int i = 0;
                    while (i < listeners.length) {
                        ValueSlider.this.jSlider.addChangeListener(listeners[i]);
                        ++i;
                    }
                }
            }
        });
        this.textField.setText(this.textField.getText());
    }

    public float[] getMinMax() {
        return new float[]{this.minval, this.maxval};
    }

    public void setMinMax(float minval, float maxval) {
        this.minval = minval;
        this.maxval = maxval;
        this.valprecision = FLOAT;
        this.genFactor();
        this.minLabel.setText(String.valueOf(minval));
        this.maxLabel.setText(String.valueOf(maxval));
        this.textField.setText(this.textField.getText());
    }

    public void setMinMax(int minval, int maxval) {
        this.minval = minval;
        this.maxval = maxval;
        this.valprecision = INT;
        this.genFactor();
        this.minLabel.setText(String.valueOf(minval));
        this.maxLabel.setText(String.valueOf(maxval));
        try {
            this.textField.setText(String.valueOf((int)Float.parseFloat(this.textField.getText())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValue(float val) {
        try {
            this.textField.setText(String.valueOf(val));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setValueInt(int val) {
        try {
            this.jSlider.setValue(val);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public float getValue() {
        float ret = 0.0f;
        try {
            ret = Float.parseFloat(this.textField.getText());
        }
        catch (Exception exc) {
            ret = this.getVal();
        }
        return ret;
    }

    public int getValueInt() {
        return this.jSlider.getValue();
    }

    public void setTitleForBorder(String ti) {
        this.titledBorder.setTitle(ti);
        this.repaint();
    }
}

