/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class TransparencySelector
extends JPanel {
    private Logger logger = Logger.getLogger((String)TransparencySelector.class.getName());
    private JTextField textTrans;
    private JSlider transparencySlider;

    public TransparencySelector(String title) {
        this.setBorder(new TitledBorder(title));
        this.init();
    }

    public TransparencySelector() {
        this.setBorder(new TitledBorder("transparency"));
        this.init();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.textTrans.setEnabled(b);
        this.transparencySlider.setEnabled(b);
    }

    public void addChangeListener(ChangeListener cl) {
        if (this.transparencySlider != null) {
            this.transparencySlider.addChangeListener(cl);
        }
    }

    public void removeChangeListener(ChangeListener cl) {
        if (this.transparencySlider != null) {
            this.transparencySlider.removeChangeListener(cl);
        }
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 0));
        this.textTrans = new JTextField(5);
        this.textTrans.setText("0");
        JPanel ptexttrans = new JPanel();
        ptexttrans.setBorder(new TitledBorder("val"));
        ptexttrans.add(this.textTrans);
        this.transparencySlider = new JSlider(0, 100, 0);
        this.add(ptexttrans);
        this.add(this.transparencySlider);
        this.transparencySlider.setMajorTickSpacing(25);
        this.transparencySlider.setMinorTickSpacing(10);
        this.transparencySlider.setPaintTicks(true);
        this.transparencySlider.setPaintLabels(true);
        this.transparencySlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int i;
                CaretListener[] listeners = TransparencySelector.this.textTrans.getCaretListeners();
                if (listeners != null) {
                    i = 0;
                    while (i < listeners.length) {
                        TransparencySelector.this.textTrans.removeCaretListener(listeners[i]);
                        ++i;
                    }
                }
                TransparencySelector.this.textTrans.setText(String.valueOf(TransparencySelector.this.transparencySlider.getValue()));
                if (listeners != null) {
                    i = 0;
                    while (i < listeners.length) {
                        TransparencySelector.this.textTrans.addCaretListener(listeners[i]);
                        ++i;
                    }
                }
            }
        });
        this.textTrans.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent ce) {
                ChangeListener[] listeners = TransparencySelector.this.transparencySlider.getChangeListeners();
                if (listeners != null) {
                    int i = 0;
                    while (i < listeners.length) {
                        TransparencySelector.this.transparencySlider.removeChangeListener(listeners[i]);
                        ++i;
                    }
                }
                try {
                    int val = Integer.parseInt(TransparencySelector.this.textTrans.getText().trim());
                    TransparencySelector.this.transparencySlider.setValue(val);
                }
                catch (Exception val) {
                    // empty catch block
                }
                if (listeners != null) {
                    int i = 0;
                    while (i < listeners.length) {
                        TransparencySelector.this.transparencySlider.addChangeListener(listeners[i]);
                        ++i;
                    }
                }
            }
        });
    }

    public void setTransparency(float trans) {
        if (trans > 1.0f) {
            trans = 1.0f;
        }
        if (trans < 0.0f) {
            trans = 0.0f;
        }
        this.textTrans.setText(String.valueOf((int)(trans * 100.0f)));
    }

    public float getTransparency() {
        float trans = 0.0f;
        try {
            trans = (float)Integer.parseInt(this.textTrans.getText().trim()) / 100.0f;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (trans > 1.0f) {
            trans = 1.0f;
        } else if (trans < 0.0f) {
            trans = 0.0f;
        }
        return trans;
    }
}

