/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.inputinterfacetable.ComboBoxChoices;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.apache.log4j.Logger;

public class TSpaceRotChoices
implements ComboBoxChoices {
    private Logger logger = Logger.getLogger((String)TSpaceRotChoices.class.getName());
    private InputInterface inputInterface;
    private String[] tips;
    private String[] choices;
    private String[] tips_torh;
    private String[] choices_torh;

    public TSpaceRotChoices(InputInterface inputInterface) {
        this.inputInterface = inputInterface;
        this.init();
    }

    private void init() {
        InputStream tspacetxt = TSpaceRotChoices.class.getResourceAsStream("/ciss/phase_viewer/primitiveguis/tspace.txt");
        InputStream tspacetxt_trig_hexa = TSpaceRotChoices.class.getResourceAsStream("/ciss/phase_viewer/primitiveguis/tspace_trig_hexa.txt");
        Vector<String> tag = new Vector<String>();
        Vector<String> descript = new Vector<String>();
        BufferedReader reader = null;
        try {
            try {
                String[] arr;
                String str;
                reader = new BufferedReader(new InputStreamReader(tspacetxt));
                String line = "";
                while ((line = reader.readLine()) != null) {
                    str = line.trim();
                    if (str.startsWith("#")) continue;
                    arr = str.split(",");
                    tag.addElement(arr[0].trim());
                    if (arr.length < 2) continue;
                    descript.addElement(arr[1].trim());
                }
                this.choices = new String[tag.size()];
                tag.copyInto(this.choices);
                this.tips = new String[descript.size()];
                descript.copyInto(this.tips);
                reader = new BufferedReader(new InputStreamReader(tspacetxt_trig_hexa));
                tag = new Vector();
                descript = new Vector();
                while ((line = reader.readLine()) != null) {
                    str = line.trim();
                    if (str.startsWith("#")) continue;
                    arr = str.split(",");
                    tag.addElement(arr[0].trim());
                    if (arr.length < 2) continue;
                    descript.addElement(arr[1].trim());
                }
                this.choices_torh = new String[tag.size()];
                tag.copyInto(this.choices_torh);
                this.tips_torh = new String[descript.size()];
                descript.copyInto(this.tips_torh);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Object[] getChoices(String index) {
        return null;
    }

    @Override
    public String getToolTipTexts(int index) {
        if (!this.isTrigOrHexa()) {
            if (this.tips != null && this.tips.length > index) {
                return this.tips[index];
            }
            return "";
        }
        return this.tips_torh[index];
    }

    @Override
    public Object[] getChoices(int index) {
        return null;
    }

    @Override
    public Object[] getChoices() {
        if (!this.isTrigOrHexa()) {
            return this.choices;
        }
        return this.choices_torh;
    }

    private boolean isTrigOrHexa() {
        String buff = this.inputInterface.getCurrentBlock().getFullName();
        InputInterfacePrimitiveEntry entry = this.inputInterface.getInputInterfacePrimitiveEntry("structure.symmetry.tspace.lattice_system");
        this.logger.debug((Object)("current block: " + buff));
        if (entry == null) {
            this.inputInterface.selectBlock(buff);
            return false;
        }
        boolean ret = entry.getValue().equalsIgnoreCase("trigonal") || entry.getValue().equalsIgnoreCase("hexagonal") || entry.getValue().equalsIgnoreCase("rhombohedral");
        this.inputInterface.selectRoot();
        this.inputInterface.selectBlock(buff);
        this.logger.debug((Object)("current block: " + this.inputInterface.getCurrentBlock().getFullName()));
        return ret;
    }
}

