/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfacePrimitiveEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.CaretListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;

public abstract class PrimitiveInputComponents
extends JPanel {
    private static Logger logger = Logger.getLogger((String)PrimitiveInputComponents.class.getName());
    protected String[] inputSpecifications;
    protected String[] fullName;
    protected InputInterface inputInterface;
    protected InputInterfacePrimitiveEntry entry;
    protected InputInterfaceUnits units;
    protected boolean isDoubleQuoted = false;

    public PrimitiveInputComponents(String[] inputSpecifications, InputInterface inputInterface) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.extractInputFile();
    }

    public PrimitiveInputComponents(String[] inputSpecifications, InputInterface inputInterface, boolean isDoubleQuoted) {
        this.inputSpecifications = inputSpecifications;
        this.inputInterface = inputInterface;
        this.isDoubleQuoted = isDoubleQuoted;
        this.extractInputFile();
    }

    protected void addListeners(EventListener listener) {
        Component[] comps = this.getComponents();
        if (comps == null) {
            return;
        }
        int i = 0;
        while (i < comps.length) {
            Component comp = comps[i];
            if (comp != null && comp instanceof Command) {
                if (comp instanceof AbstractButton) {
                    ((AbstractButton)comp).addActionListener((ActionListener)listener);
                    ((AbstractButton)comp).addItemListener((ItemListener)listener);
                    if (comp instanceof JComboBox) {
                        ((JComboBox)comp).addPopupMenuListener((PopupMenuListener)listener);
                    }
                } else if (comp instanceof JTextComponent) {
                    ((JTextComponent)comp).addCaretListener((CaretListener)listener);
                }
            }
            ++i;
        }
    }

    protected void extractInputFile() {
        int is = 0;
        while (is < this.inputSpecifications.length) {
            String st;
            String inp = this.inputSpecifications[is];
            this.fullName = inp.split("\\.");
            String blockIdent = this.fullName[0];
            int i = 1;
            while (i < this.fullName.length - 1) {
                blockIdent = String.valueOf(blockIdent) + "." + this.fullName[i];
                ++i;
            }
            this.inputInterface.selectRoot();
            if (!this.inputInterface.selectBlock(blockIdent)) {
                logger.debug((Object)("couldn't select block: " + blockIdent));
            }
            boolean found = false;
            this.units = this.inputInterface.getUnits();
            if (this.units.getName().trim().length() != 0 || is == this.inputSpecifications.length - 1) {
                logger.debug((Object)("got entry: " + this.units.getName()));
                st = this.inputSpecifications[0];
                found = true;
            }
            this.entry = this.inputInterface.getPrimitiveEntry(this.fullName[this.fullName.length - 1]);
            if (this.entry.getValue().trim().length() != 0 || is == this.inputSpecifications.length - 1) {
                this.entry.setDoubleQuoted(this.isDoubleQuoted);
                logger.debug((Object)("got entry: " + this.entry.getName() + " value: " + this.entry.getValue() + " unit: " + this.entry.getUnit() + " isDoubleQuoted? " + this.entry.isDoubleQuoted()));
                st = this.inputSpecifications[0];
                this.fullName = st.split("\\.");
                this.entry.setName(this.fullName[this.fullName.length - 1].trim());
                found = true;
            }
            if (found) break;
            ++is;
        }
    }
}

