/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.filebrowser.FileBrowserUtils;
import ciss.phase_viewer.inputinterface.filestate.FileStateChangeEvent;
import ciss.phase_viewer.inputinterface.filestate.FileStateListener;
import ciss.phase_viewer.inputinterface.filestate.FileStateObserver;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ComboButton
extends JPanel
implements FileStateListener {
    private Logger logger = Logger.getLogger((String)ComboButton.class.getName());
    private String dir;
    private String[] filters;
    private JComboBox comboBox;
    private JButton button;

    public ComboButton(String dir, String filter) {
        this.dir = dir;
        this.filters = new String[]{filter};
        this.setLayout(new BoxLayout(this, 0));
        FileStateObserver obs = new FileStateObserver(dir, this.filters);
        this.init();
        obs.addFileStateListener(this);
    }

    public ComboButton(String dir, String[] filters) {
        this.dir = dir;
        this.filters = filters;
        this.setLayout(new BoxLayout(this, 0));
        FileStateObserver obs = new FileStateObserver(dir, filters);
        this.init();
        obs.addFileStateListener(this);
    }

    private void init() {
        String[] files = new File(this.dir).list();
        if (files != null && files.length > 0) {
            Vector<String> vector = new Vector<String>();
            int i = 0;
            while (i < files.length) {
                int j = 0;
                while (j < this.filters.length) {
                    if (files[i].matches(this.filters[j])) {
                        vector.addElement(files[i]);
                    }
                    ++j;
                }
                ++i;
            }
            if (vector.size() != 0) {
                this.comboBox = new JComboBox(vector);
                this.button = new JButton("view");
                this.button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileBrowserUtils.bootProgram(false, String.valueOf(ComboButton.this.dir) + System.getProperty("file.separator") + ComboButton.this.comboBox.getSelectedItem().toString().trim());
                    }
                });
                this.add(this.comboBox);
                this.add(this.button);
            }
        }
    }

    public void recreate() {
        this.removeAll();
        this.init();
    }

    @Override
    public void fileStateChanged(FileStateChangeEvent fe) {
        this.logger.debug((Object)fe);
        this.recreate();
        this.revalidate();
    }
}

