/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.primitiveguis;

import ciss.phase_viewer.common.Command;
import ciss.phase_viewer.common.ConstParameters;
import ciss.phase_viewer.inputinterface.InputInterface;
import ciss.phase_viewer.inputinterface.InputInterfaceEntry;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeEvent;
import ciss.phase_viewer.inputinterface.InputInterfaceEntryChangeListener;
import ciss.phase_viewer.inputinterface.InputInterfaceUnits;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JComboBox;
import org.apache.log4j.Logger;

public class ComboBoxPhaseUnit
extends JComboBox
implements Command,
InputInterfaceEntryChangeListener {
    private static Logger logger = Logger.getLogger((String)ComboBoxPhaseUnit.class.getName());
    private String[] inputSpecifications;
    private InputInterface inputinterface;
    private String[] choices;
    private int unitType;
    private boolean writeAll = true;
    public static final int LONGTIME = 1;
    public static final int TIME = 2;
    public static final int LENGTH = 3;
    public static final int ENERGY = 4;
    public static final int FORCE = 5;

    public ComboBoxPhaseUnit(String[] choices, String[] inputSpecifications, InputInterface inputinterface, int unitType) {
        super(choices);
        this.choices = choices;
        this.inputSpecifications = inputSpecifications;
        this.inputinterface = inputinterface;
        this.unitType = unitType;
        inputinterface.addInputInterfaceEntryChangeListener(this);
    }

    @Override
    public void execute(EventObject e) {
        this.inputinterface.selectRoot();
        logger.debug(super.getSelectedItem());
        int inpSpecLength = 1;
        if (this.writeAll) {
            inpSpecLength = this.inputSpecifications.length;
        }
        int is = 0;
        while (is < inpSpecLength) {
            String inp = this.inputSpecifications[is];
            InputInterfaceUnits units = this.inputinterface.getInputInterfaceUnits(inp);
            units.saveState();
            String newText = (String)super.getSelectedItem();
            String[] fname = this.inputSpecifications[0].split("\\.");
            String name = fname[fname.length - 1];
            if (newText != null && !newText.equals(ConstParameters.NO_SELECTION)) {
                String[] unitName = new String[]{newText};
                units.setName(name);
                units.setUnits(unitName);
                this.inputinterface.replaceEntry(units, this);
                logger.debug((Object)("replaced unit at: " + units.getName()));
            } else {
                this.inputinterface.removeEntry(units, this);
                logger.debug((Object)("removed unit at: " + units.getName()));
            }
            ++is;
        }
    }

    @Override
    public void inputInterfaceInitializing() {
        ActionListener[] lists = this.getActionListeners();
        int i = 0;
        while (i < lists.length) {
            this.removeActionListener(lists[i]);
            ++i;
        }
        this.setSelectedIndex(0);
        i = 0;
        while (i < lists.length) {
            this.addActionListener(lists[i]);
            ++i;
        }
    }

    @Override
    public void inputInterfaceInitialized() {
    }

    @Override
    public void inputInterfaceEntryChanged(InputInterfaceEntryChangeEvent evt) {
        if (evt.getSource() == this || evt.getEntry() == null) {
            return;
        }
        String tag = evt.getTag();
        InputInterfaceEntry entry = evt.getEntry();
        if (entry.getEntryType() != 3) {
            return;
        }
        logger.debug((Object)"at inputInterfaceEntryChanged");
        InputInterfaceUnits uentry = (InputInterfaceUnits)entry;
        String fullName = String.valueOf(tag) + ".units";
        ActionListener[] listeners = this.getActionListeners();
        int i = 0;
        while (i < listeners.length) {
            this.removeActionListener(listeners[i]);
            ++i;
        }
        i = 0;
        while (i < this.inputSpecifications.length) {
            logger.debug((Object)("inputSpec : " + this.inputSpecifications[i] + " uentry : name: " + fullName + " val: " + uentry.getUnits()[0]));
            if (fullName.trim().equalsIgnoreCase(this.inputSpecifications[i].trim())) {
                this.setSelectedItem(uentry.getUnits()[0]);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < listeners.length) {
            this.addActionListener(listeners[i]);
            ++i;
        }
    }

    public void writeAllEntries(boolean writeAll) {
        this.writeAll = writeAll;
    }
}

