/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.view;

import ciss.phase_viewer.acviewer.CoordsViewerInterface;
import ciss.phase_viewer.acviewer.MainPanel;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.acviewer.fbz.WignerSeitzCell;
import ciss.phase_viewer.acviewer.scenegraphelements.CellObject;
import ciss.phase_viewer.acviewer.scenegraphelements.TGAtom;
import ciss.phase_viewer.mainpanel.InternalFrameChase;
import ciss.phase_viewer.plugins.viewer.view.WSCellAttrEditor;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.j3d.Node;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class WSCellRealSpace
extends InternalFrameChase {
    private Logger logger = Logger.getLogger((String)WSCellRealSpace.class.getName());
    private CoordsViewerInterface parent;
    private WSCellAttrEditor wsattreditor;
    private WignerSeitzAttributes wsattrs;
    private WignerSeitzCell wscell;
    private CellObject cellObject;

    public WSCellRealSpace(MainPanel parent) {
        super("draw Wigner-Seitz cell", new Dimension(500, 340));
        this.parent = parent;
        parent.addDisposeOnExit(this);
        this.init();
        this.setVisible(true);
    }

    private void init() {
        TGAtom tgat = (TGAtom)this.parent.getScene().getTGAtom();
        Node[] nd = tgat.getChildren(CellObject.class);
        if (nd != null && nd.length != 0) {
            this.cellObject = (CellObject)nd[0];
            this.wscell = this.cellObject.getWSCell();
            if (this.wscell != null) {
                this.wsattrs = this.wscell.getAttributes();
            } else {
                this.wsattrs = new WignerSeitzAttributes();
                this.wsattrs.isReciprocalSpace = false;
            }
        } else {
            this.logger.info((Object)"cell must be shown.");
            this.dispose();
            return;
        }
        this.wsattreditor = new WSCellAttrEditor(this.wsattrs);
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 0));
        JButton apply = new JButton("apply");
        JButton delete2 = new JButton("delete");
        JButton dismiss = new JButton("dismiss");
        btnPanel.add(apply);
        btnPanel.add(delete2);
        btnPanel.add(dismiss);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        container.add(this.wsattreditor);
        container.add(btnPanel);
        apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WSCellRealSpace.this.doApply();
            }
        });
        delete2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                WSCellRealSpace.this.doDelete();
            }
        });
        dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WSCellRealSpace.this.dispose();
            }
        });
    }

    private void doApply() {
        this.wsattreditor.doIt();
        if (this.wscell == null) {
            this.cellObject.createWSCell();
            this.wscell = this.cellObject.getWSCell();
            return;
        }
        this.wscell.recreate();
    }

    private void doDelete() {
        if (this.wscell == null) {
            return;
        }
        this.wscell.detach();
        this.wscell = null;
        this.cellObject.nullifyWSCell();
    }
}

