/*
 * Decompiled with CFR 0.152.
 */
package ciss.phase_viewer.plugins.viewer.view;

import ciss.phase_viewer.acviewer.fbz.WignerSeitzAttributes;
import ciss.phase_viewer.primitiveguis.ColorButton;
import ciss.phase_viewer.primitiveguis.TransparencySelector;
import ciss.phase_viewer.settings.GlobalProperties;
import ciss.phase_viewer.settings.PropertiesManager;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.vecmath.Color3f;
import org.apache.log4j.Logger;

public class WSCellAttrEditor
extends JPanel {
    private Logger logger = Logger.getLogger((String)WSCellAttrEditor.class.getName());
    private WignerSeitzAttributes wsattrs;
    private GlobalProperties gp = PropertiesManager.getGlobalProperties(1);
    private JCheckBox drawEdge;
    private JTextField edgeWidth;
    private ColorButton edgeColor;
    private JCheckBox drawPlane;
    private TransparencySelector planeTransparency;
    private ColorButton planeColor;
    private JCheckBox drawAxis;
    private JTextField axisWidth;
    private ColorButton axisColor;
    private JCheckBox drawSymmetricPoint;
    private JCheckBox gammaIsSymm;
    private JCheckBox planeCenterIsSymm;
    private JCheckBox edgeCenterIsSymm;
    private JCheckBox vertexIsSymm;
    private JTextField symmPointRadius;
    private ColorButton symmPointColor;
    private ColorButton selectedSymmPointColor;
    private JTextField lineWidth;
    private ColorButton lineColor;

    public WSCellAttrEditor(WignerSeitzAttributes wsattrs) {
        this.wsattrs = wsattrs;
        this.init();
    }

    private void init() {
        this.setLayout(new BoxLayout(this, 1));
        if (this.wsattrs.isReciprocalSpace) {
            JTabbedPane tabbedPane = new JTabbedPane();
            tabbedPane.addTab("appearance", this.appPanel());
            tabbedPane.addTab("symm. point", this.symmPointPanel());
            this.add(tabbedPane);
        } else {
            this.add(this.appPanel());
        }
        this.setInitialValues();
    }

    private JPanel appPanel() {
        JPanel edgePanel = new JPanel();
        edgePanel.setLayout(new BoxLayout(edgePanel, 0));
        edgePanel.setBorder(new TitledBorder("edge"));
        this.drawEdge = new JCheckBox("draw edge");
        JPanel ewpanel = new JPanel();
        ewpanel.setBorder(new TitledBorder("edge width"));
        this.edgeWidth = new JTextField(6);
        ewpanel.add(this.edgeWidth);
        this.edgeColor = new ColorButton("edge color");
        JPanel ecpanel = new JPanel();
        ecpanel.add(this.edgeColor);
        edgePanel.add(this.drawEdge);
        edgePanel.add(ewpanel);
        edgePanel.add(ecpanel);
        JPanel planePanel = new JPanel();
        planePanel.setLayout(new BoxLayout(planePanel, 0));
        planePanel.setBorder(new TitledBorder("plane"));
        this.drawPlane = new JCheckBox("draw plane");
        this.planeTransparency = new TransparencySelector();
        this.planeColor = new ColorButton("plane color");
        JPanel pcpanel = new JPanel();
        pcpanel.add(this.planeColor);
        planePanel.add(this.drawPlane);
        planePanel.add(this.planeTransparency);
        planePanel.add(pcpanel);
        JPanel axisPanel = new JPanel();
        axisPanel.setBorder(new TitledBorder("axis"));
        axisPanel.setLayout(new BoxLayout(axisPanel, 0));
        this.drawAxis = new JCheckBox("draw axis");
        JPanel awpanel = new JPanel();
        awpanel.setBorder(new TitledBorder("axis width"));
        this.axisWidth = new JTextField(6);
        awpanel.add(this.axisWidth);
        this.axisColor = new ColorButton("axis color");
        JPanel acpanel = new JPanel();
        acpanel.add(this.axisColor);
        axisPanel.add(this.drawAxis);
        axisPanel.add(awpanel);
        axisPanel.add(acpanel);
        JPanel app = new JPanel();
        app.setLayout(new BoxLayout(app, 1));
        app.add(edgePanel);
        app.add(planePanel);
        app.add(axisPanel);
        this.drawEdge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean b = WSCellAttrEditor.this.drawEdge.isSelected();
                WSCellAttrEditor.this.edgeColor.setEnabled(b);
                WSCellAttrEditor.this.edgeWidth.setEnabled(b);
            }
        });
        this.drawAxis.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                boolean b = WSCellAttrEditor.this.drawAxis.isSelected();
                WSCellAttrEditor.this.axisColor.setEnabled(b);
                WSCellAttrEditor.this.axisWidth.setEnabled(b);
            }
        });
        this.drawPlane.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean b = WSCellAttrEditor.this.drawPlane.isSelected();
                WSCellAttrEditor.this.planeColor.setEnabled(b);
                WSCellAttrEditor.this.planeTransparency.setEnabled(b);
            }
        });
        return app;
    }

    private JPanel symmPointPanel() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 1));
        JPanel pdraw = new JPanel();
        this.drawSymmetricPoint = new JCheckBox("draw symmetric points");
        pdraw.add(this.drawSymmetricPoint);
        JPanel pdraw_sub = new JPanel();
        pdraw_sub.setLayout(new GridLayout(2, 2));
        pdraw_sub.setBorder(new TitledBorder("regard the following as symmetric"));
        this.gammaIsSymm = new JCheckBox("gamma point");
        this.planeCenterIsSymm = new JCheckBox("center of plane");
        this.edgeCenterIsSymm = new JCheckBox("center of edge");
        this.vertexIsSymm = new JCheckBox("vertex");
        pdraw_sub.add(this.gammaIsSymm);
        pdraw_sub.add(this.planeCenterIsSymm);
        pdraw_sub.add(this.edgeCenterIsSymm);
        pdraw_sub.add(this.vertexIsSymm);
        JPanel psympoint = new JPanel();
        psympoint.setLayout(new BoxLayout(psympoint, 0));
        this.symmPointRadius = new JTextField(10);
        JPanel pspr = new JPanel();
        pspr.setBorder(new TitledBorder("symmetry point radius"));
        pspr.add(this.symmPointRadius);
        psympoint.add(pspr);
        this.symmPointColor = new ColorButton("color");
        JPanel psympcolor = new JPanel();
        psympcolor.add(this.symmPointColor);
        psympoint.add(psympcolor);
        this.selectedSymmPointColor = new ColorButton("selected color");
        JPanel pselecolor = new JPanel();
        pselecolor.add(this.selectedSymmPointColor);
        psympoint.add(pselecolor);
        JPanel psymline = new JPanel();
        psymline.setBorder(new TitledBorder("symmetric line"));
        psymline.setLayout(new BoxLayout(psymline, 0));
        this.lineWidth = new JTextField(10);
        JPanel plinewidth = new JPanel();
        plinewidth.setBorder(new TitledBorder("line width"));
        plinewidth.add(this.lineWidth);
        psymline.add(plinewidth);
        JPanel plinecolor = new JPanel();
        this.lineColor = new ColorButton("line color");
        plinecolor.add(this.lineColor);
        psymline.add(plinecolor);
        ret.add(pdraw);
        ret.add(pdraw_sub);
        ret.add(psympoint);
        ret.add(psymline);
        return ret;
    }

    private void setInitialValues() {
        try {
            this.drawAxis.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.DRAW_AXIS)));
            this.drawEdge.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.DRAW_EDGE)));
            this.drawPlane.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.DRAW_PLANE)));
            this.planeTransparency.setTransparency(Float.parseFloat(this.gp.getProperty(WignerSeitzAttributes.PLANE_TRANSPARENCY)));
            this.edgeWidth.setText(String.valueOf(Float.parseFloat(this.gp.getProperty(WignerSeitzAttributes.EDGE_WIDTH))));
            this.axisWidth.setText(String.valueOf(Float.parseFloat(this.gp.getProperty(WignerSeitzAttributes.AXIS_WIDTH))));
            String[] pcolor = this.gp.getProperty(WignerSeitzAttributes.PLANE_COLOR).split(",");
            this.planeColor.setColorf(Float.parseFloat(pcolor[0]), Float.parseFloat(pcolor[1]), Float.parseFloat(pcolor[2]));
            String[] ecolor = this.gp.getProperty(WignerSeitzAttributes.EDGE_COLOR).split(",");
            this.edgeColor.setColorf(Float.parseFloat(ecolor[0]), Float.parseFloat(ecolor[1]), Float.parseFloat(ecolor[2]));
            String[] acolor = this.gp.getProperty(WignerSeitzAttributes.AXIS_COLOR).split(",");
            this.axisColor.setColorf(Float.parseFloat(acolor[0]), Float.parseFloat(acolor[1]), Float.parseFloat(acolor[2]));
            if (this.wsattrs.isReciprocalSpace) {
                this.drawSymmetricPoint.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.DRAW_SYMMETRIC_POINTS)));
                this.gammaIsSymm.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.GAMMA_IS_SYMMETRIC)));
                this.planeCenterIsSymm.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.PLANE_CENTER_IS_SYMMETRIC)));
                this.edgeCenterIsSymm.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.EDGE_CENTER_IS_SYMMETRIC)));
                this.vertexIsSymm.setSelected(new Boolean(this.gp.getProperty(WignerSeitzAttributes.VERTEX_IS_SYMMETRIC)));
                this.symmPointRadius.setText(String.valueOf(Float.parseFloat(this.gp.getProperty(WignerSeitzAttributes.SYMMETRIC_POINT_RADIUS))));
                this.lineWidth.setText(String.valueOf(Float.parseFloat(this.gp.getProperty(WignerSeitzAttributes.SYMMETRIC_LINE_WIDTH))));
                String[] spcolor = this.gp.getProperty(WignerSeitzAttributes.SYMMETRIC_POINT_COLOR).split(",");
                this.symmPointColor.setColorf(Float.parseFloat(spcolor[0]), Float.parseFloat(spcolor[1]), Float.parseFloat(spcolor[2]));
                String[] selecolor = this.gp.getProperty(WignerSeitzAttributes.SELECTED_SYMMETRIC_POINT_COLOR).split(",");
                this.selectedSymmPointColor.setColorf(Float.parseFloat(selecolor[0]), Float.parseFloat(selecolor[1]), Float.parseFloat(selecolor[2]));
                String[] slcolor = this.gp.getProperty(WignerSeitzAttributes.SYMMETRIC_LINE_COLOR).split(",");
                this.lineColor.setColorf(Float.parseFloat(slcolor[0]), Float.parseFloat(slcolor[1]), Float.parseFloat(slcolor[2]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doIt() {
        if (this.wsattrs == null) {
            this.logger.error((Object)"Wigner-Seitz is invalid");
            return;
        }
        try {
            this.gp.setProperty(WignerSeitzAttributes.DRAW_AXIS, String.valueOf(this.drawAxis.isSelected()));
            this.gp.setProperty(WignerSeitzAttributes.DRAW_EDGE, String.valueOf(this.drawEdge.isSelected()));
            this.gp.setProperty(WignerSeitzAttributes.DRAW_PLANE, String.valueOf(this.drawPlane.isSelected()));
            this.gp.setProperty(WignerSeitzAttributes.EDGE_WIDTH, this.edgeWidth.getText());
            this.gp.setProperty(WignerSeitzAttributes.AXIS_WIDTH, this.axisWidth.getText());
            this.gp.setProperty(WignerSeitzAttributes.PLANE_TRANSPARENCY, String.valueOf(this.planeTransparency.getTransparency()));
            Color3f acolor = this.axisColor.getColor3f();
            String astr = String.valueOf(String.valueOf(acolor.x)) + "," + String.valueOf(acolor.y) + "," + String.valueOf(acolor.z);
            this.gp.setProperty(WignerSeitzAttributes.AXIS_COLOR, astr);
            Color3f ecolor = this.edgeColor.getColor3f();
            String estr = String.valueOf(String.valueOf(ecolor.x)) + "," + String.valueOf(ecolor.y) + "," + String.valueOf(ecolor.z);
            this.gp.setProperty(WignerSeitzAttributes.EDGE_COLOR, estr);
            Color3f pcolor = this.planeColor.getColor3f();
            String pstr = String.valueOf(String.valueOf(pcolor.x)) + "," + String.valueOf(pcolor.y) + "," + String.valueOf(pcolor.z);
            this.gp.setProperty(WignerSeitzAttributes.PLANE_COLOR, pstr);
            if (this.wsattrs.isReciprocalSpace) {
                this.gp.setProperty(WignerSeitzAttributes.DRAW_SYMMETRIC_POINTS, String.valueOf(this.drawSymmetricPoint.isSelected()));
                this.gp.setProperty(WignerSeitzAttributes.GAMMA_IS_SYMMETRIC, String.valueOf(this.gammaIsSymm.isSelected()));
                this.gp.setProperty(WignerSeitzAttributes.PLANE_CENTER_IS_SYMMETRIC, String.valueOf(this.planeCenterIsSymm.isSelected()));
                this.gp.setProperty(WignerSeitzAttributes.EDGE_CENTER_IS_SYMMETRIC, String.valueOf(this.edgeCenterIsSymm.isSelected()));
                this.gp.setProperty(WignerSeitzAttributes.VERTEX_IS_SYMMETRIC, String.valueOf(this.vertexIsSymm.isSelected()));
                this.gp.setProperty(WignerSeitzAttributes.SYMMETRIC_POINT_RADIUS, this.symmPointRadius.getText());
                this.gp.setProperty(WignerSeitzAttributes.SYMMETRIC_LINE_WIDTH, this.lineWidth.getText());
                Color3f symmpc = this.symmPointColor.getColor3f();
                String spstr = String.valueOf(String.valueOf(symmpc.x)) + "," + String.valueOf(symmpc.y) + "," + String.valueOf(symmpc.z);
                this.gp.setProperty(WignerSeitzAttributes.SYMMETRIC_POINT_COLOR, spstr);
                Color3f selec = this.selectedSymmPointColor.getColor3f();
                String selestr = String.valueOf(String.valueOf(selec.x)) + "," + String.valueOf(selec.y) + "," + String.valueOf(selec.z);
                this.gp.setProperty(WignerSeitzAttributes.SELECTED_SYMMETRIC_POINT_COLOR, selestr);
                Color3f lco = this.lineColor.getColor3f();
                String lcostr = String.valueOf(String.valueOf(lco.x)) + "," + String.valueOf(lco.y) + "," + String.valueOf(lco.z);
                this.gp.setProperty(WignerSeitzAttributes.SYMMETRIC_LINE_COLOR, lcostr);
            }
            this.gp.storeProperty();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }
}

